/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.platform;

import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class MinecraftComponent
implements IComponent {
    private final class_5250 component;

    public MinecraftComponent(class_5250 component) {
        this.component = component;
    }

    public MinecraftComponent(class_2561 component) {
        this.component = component.method_27661();
    }

    public class_5250 getHandle() {
        return this.component;
    }

    @Override
    public String getRawText() {
        return this.component.getString();
    }

    @Override
    public IComponent setStyle(class_2583 style) {
        this.component.method_10862(style);
        return this;
    }

    @Override
    public class_2583 getStyle() {
        return this.component.method_10866();
    }

    @Override
    public IComponent append(IComponent sibling) {
        if (sibling instanceof MinecraftComponent) {
            MinecraftComponent mc = (MinecraftComponent)sibling;
            this.component.method_10852((class_2561)mc.getHandle());
        }
        return this;
    }

    @Override
    public List<IComponent> getSiblings() {
        return this.component.method_10855().stream().filter(c -> c instanceof class_5250).map(c -> new MinecraftComponent((class_5250)c)).map(c -> c).toList();
    }

    @Override
    public IComponent copy() {
        return new MinecraftComponent(this.component.method_27661());
    }

    @Override
    public IComponent withStyle(class_124 formatting) {
        return new MinecraftComponent(this.component.method_27661().method_27694(s -> s.method_27706(formatting)));
    }

    @Override
    public IComponent withStyle(class_2583 style) {
        return new MinecraftComponent(this.component.method_27661().method_27694(s -> style));
    }

    @Override
    public IComponent withStyle(UnaryOperator<class_2583> styleUpdater) {
        return new MinecraftComponent(this.component.method_27661().method_27694(styleUpdater));
    }

    @Override
    public IComponent withColor(int rgb) {
        return new MinecraftComponent(this.component.method_27661().method_27694(s -> s.method_27703(class_5251.method_27717((int)rgb))));
    }

    @Override
    public IComponent withColorHex(String hex) {
        if (hex == null || hex.isEmpty()) {
            return this.copy();
        }
        String cleaned = hex.startsWith("#") ? hex.substring(1) : hex;
        try {
            int rgb = Integer.parseInt(cleaned, 16);
            return this.withColor(rgb);
        }
        catch (NumberFormatException e) {
            return this.copy();
        }
    }

    @Override
    public IComponent withFormatting(class_124 formatting) {
        if (formatting == null) {
            return this.copy();
        }
        return new MinecraftComponent(this.component.method_27661().method_27694(s -> s.method_27706(formatting)));
    }

    @Override
    public IComponent withColor(String hexOrFormatCode) {
        if (hexOrFormatCode == null || hexOrFormatCode.isEmpty()) {
            return this.copy();
        }
        if (hexOrFormatCode.startsWith("#")) {
            return this.withColorHex(hexOrFormatCode.substring(1));
        }
        try {
            int rgb = Integer.parseInt(hexOrFormatCode, 16);
            return this.withColor(rgb);
        }
        catch (NumberFormatException e) {
            class_124 format = class_124.method_533((String)hexOrFormatCode);
            if (format != null && format.method_543()) {
                return this.withFormatting(format);
            }
            return this.copy();
        }
    }

    @Override
    public IComponent resetStyle() {
        return new MinecraftComponent(this.component.method_27661().method_27694(s -> class_2583.field_24360));
    }

    @Override
    public IComponent onClickRunCommand(String command) {
        return new MinecraftComponent(this.component.method_27661().method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11750, command))));
    }

    @Override
    public IComponent onClickSuggestCommand(String command) {
        return new MinecraftComponent(this.component.method_27661().method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11745, command))));
    }

    @Override
    public IComponent onClickOpenUrl(String url) {
        String u = url == null ? "" : (url.startsWith("http://") || url.startsWith("https://") ? url : "https://" + url);
        return new MinecraftComponent(this.component.method_27661().method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11749, u))));
    }

    @Override
    public IComponent onClickCopyToClipboard(String text) {
        String value = text != null ? text : "";
        return new MinecraftComponent(this.component.method_27661().method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_21462, value))));
    }

    @Override
    public IComponent onHoverText(String text) {
        class_5250 hover = class_2561.method_43470((String)(text != null ? text : ""));
        return new MinecraftComponent(this.component.method_27661().method_27694(arg_0 -> MinecraftComponent.lambda$onHoverText$12((class_2561)hover, arg_0)));
    }

    @Override
    public IComponent onHoverComponent(IComponent comp) {
        class_5250 hover;
        if (comp instanceof MinecraftComponent) {
            MinecraftComponent mc = (MinecraftComponent)comp;
            hover = mc.getHandle();
        } else {
            hover = class_2561.method_43470((String)(comp != null ? comp.getRawText() : ""));
        }
        return new MinecraftComponent(this.component.method_27661().method_27694(arg_0 -> MinecraftComponent.lambda$onHoverComponent$13((class_2561)hover, arg_0)));
    }

    @Override
    public class_2561 getOriginalText() {
        return this.component;
    }

    private static /* synthetic */ class_2583 lambda$onHoverComponent$13(class_2561 hover, class_2583 s) {
        return s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hover));
    }

    private static /* synthetic */ class_2583 lambda$onHoverText$12(class_2561 hover, class_2583 s) {
        return s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hover));
    }
}

