/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.configs.MainConfigHandler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugLogger {
    private static final Logger SLF4J_LOGGER = LoggerFactory.getLogger((String)"eu.avalanche7.paradigm");
    private final MainConfigHandler.Config mainConfig;
    private static boolean isDebugConfigured = false;

    public DebugLogger(MainConfigHandler.Config mainConfig) {
        this.mainConfig = mainConfig;
        this.configureDebugLevel();
    }

    private void configureDebugLevel() {
        if (!isDebugConfigured && this.mainConfig != null) {
            boolean debugEnabledInConfig = (Boolean)this.mainConfig.debugEnable.value;
            if (debugEnabledInConfig) {
                Configurator.setLevel((String)"eu.avalanche7.paradigm", (Level)Level.DEBUG);
                SLF4J_LOGGER.info("[Paradigm] Debug logging is ENABLED. Verbose logs will now be shown.");
            } else {
                Configurator.setLevel((String)"eu.avalanche7.paradigm", (Level)Level.INFO);
                SLF4J_LOGGER.info("[Paradigm] Debug logging is DISABLED. To see verbose logs, enable 'debugEnable' in the main config.");
            }
            isDebugConfigured = true;
        }
    }

    public void debugLog(String message) {
        if (this.mainConfig != null && ((Boolean)this.mainConfig.debugEnable.value).booleanValue()) {
            SLF4J_LOGGER.debug("[Paradigm-Debug] " + message);
        }
    }

    public void debugLog(String message, Exception e) {
        if (this.mainConfig != null && ((Boolean)this.mainConfig.debugEnable.value).booleanValue()) {
            SLF4J_LOGGER.warn("[Paradigm-Debug] " + message, (Throwable)e);
        }
    }

    public void debugLog(String message, Object ... args) {
        if (this.mainConfig != null && ((Boolean)this.mainConfig.debugEnable.value).booleanValue()) {
            SLF4J_LOGGER.debug("[Paradigm-Debug] " + message, args);
        }
    }
}

