/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.avalanche7.paradigm.Paradigm;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.utils.MessageParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import org.slf4j.Logger;

public class Lang {
    private final Logger logger;
    private final Path langFolder = FabricLoader.getInstance().getConfigDir().resolve("paradigm/lang");
    private final Map<String, String> translations = new HashMap<String, String>();
    private String currentLanguage;
    private final MainConfigHandler.Config mainConfig;
    private final MessageParser messageParser;

    public Lang(Logger logger, MainConfigHandler.Config mainConfig, MessageParser messageParser) {
        this.logger = logger;
        this.mainConfig = mainConfig;
        this.messageParser = messageParser;
        try {
            this.ensureDefaultLangFiles();
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("Failed to initialize Lang class", (Throwable)e);
            }
            System.err.println("Failed to initialize Lang class and logger is null: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Lang(Logger logger) {
        this(logger, null, null);
    }

    public void initializeLanguage() {
        if (this.mainConfig == null || this.mainConfig.defaultLanguage == null) {
            if (this.logger != null) {
                this.logger.warn("Lang: MainConfig or defaultLanguage setting is null. Using default language 'en'.");
            }
            this.loadLanguage("en");
            return;
        }
        String language = (String)this.mainConfig.defaultLanguage.value;
        if (this.logger != null) {
            this.logger.info("Paradigm: Loaded language setting: {}", (Object)language);
        }
        this.loadLanguage(language);
    }

    public void loadLanguage(String language) {
        block15: {
            if (this.logger != null) {
                this.logger.info("Paradigm: Attempting to load language: {}", (Object)language);
            }
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            Path langFile = this.langFolder.resolve(language + ".json");
            if (!Files.exists(langFile, new LinkOption[0])) {
                if (this.logger != null) {
                    this.logger.error("Language file not found: {}. Attempting to use 'en'.", (Object)langFile);
                }
                if (!language.equals("en")) {
                    this.loadLanguage("en");
                } else if (this.logger != null) {
                    this.logger.error("English language file also missing. Translations will not work.");
                }
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(langFile, StandardCharsets.UTF_8);){
                Map rawMap = (Map)gson.fromJson((Reader)reader, type);
                this.translations.clear();
                this.flattenMap("", rawMap);
                this.currentLanguage = language;
                if (this.logger != null) {
                    this.logger.info("Paradigm: Successfully loaded language: {}", (Object)language);
                }
            }
            catch (Exception e) {
                if (this.logger == null) break block15;
                this.logger.error("Paradigm: Failed to load language file: " + language, (Throwable)e);
            }
        }
    }

    private void flattenMap(String prefix, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                this.translations.put(key, (String)value);
                continue;
            }
            if (value instanceof Map) {
                Map castedMap = (Map)value;
                this.flattenMap(key, castedMap);
                continue;
            }
            if (value == null) continue;
            this.translations.put(key, value.toString());
        }
    }

    public class_2561 translate(String key) {
        String translatedText = this.translations.getOrDefault(key, key);
        translatedText = translatedText.replace("&", "\u00a7");
        if (this.messageParser == null) {
            if (this.logger != null) {
                this.logger.warn("Lang.translate: MessageParser is null for key '{}'. Returning literal text.", (Object)key);
            }
            return class_2561.method_43470((String)translatedText);
        }
        return this.messageParser.parseMessage(translatedText, null).getOriginalText();
    }

    public String getTranslation(String key) {
        String translatedText = this.translations.getOrDefault(key, key);
        return translatedText.replace("&", "\u00a7");
    }

    public void setLanguage(String language) {
        this.loadLanguage(language);
    }

    public String getCurrentLanguage() {
        return this.currentLanguage != null ? this.currentLanguage : "en";
    }

    public boolean isLanguageAvailable(String language) {
        Path langFile = this.langFolder.resolve(language + ".json");
        return Files.exists(langFile, new LinkOption[0]);
    }

    public String[] getAvailableLanguages() {
        List<String> availableLanguages = List.of("en", "cs", "ru");
        return (String[])availableLanguages.stream().filter(this::isLanguageAvailable).toArray(String[]::new);
    }

    private void ensureDefaultLangFiles() throws IOException {
        if (!Files.exists(this.langFolder, new LinkOption[0])) {
            Files.createDirectories(this.langFolder, new FileAttribute[0]);
        }
        List<String> availableLanguages = List.of("en", "cs", "ru");
        for (String langCode : availableLanguages) {
            Path langFile = this.langFolder.resolve(langCode + ".json");
            if (Files.exists(langFile, new LinkOption[0])) continue;
            if (this.logger != null) {
                this.logger.warn("Language file missing: {}.json. Attempting to copy from resources.", (Object)langCode);
            }
            try {
                InputStream in = Paradigm.class.getResourceAsStream("/lang/" + langCode + ".json");
                try {
                    if (in == null) {
                        if (this.logger == null) continue;
                        this.logger.error("Default language file /lang/{}.json not found in JAR resources.", (Object)langCode);
                        continue;
                    }
                    Files.copy(in, langFile, StandardCopyOption.REPLACE_EXISTING);
                    if (this.logger == null) continue;
                    this.logger.info("Copied default language file for: {}", (Object)langCode);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (Exception e) {
                if (this.logger == null) continue;
                this.logger.warn("Failed to copy default language file for: " + langCode, (Throwable)e);
            }
        }
    }
}

