/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.JsonValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncementsConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"paradigm");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("paradigm/announcements.json");
    public static Config CONFIG = new Config();
    private static JsonValidator jsonValidator;

    public static void setJsonValidator(DebugLogger debugLogger) {
        jsonValidator = new JsonValidator(debugLogger);
    }

    public static void load() {
        boolean shouldSaveMerged;
        Config defaultConfig;
        block30: {
            defaultConfig = new Config();
            shouldSaveMerged = false;
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH, StandardCharsets.UTF_8);){
                    int c;
                    StringBuilder content = new StringBuilder();
                    while ((c = ((Reader)reader).read()) != -1) {
                        content.append((char)c);
                    }
                    if (jsonValidator != null) {
                        JsonValidator.ValidationResult result = jsonValidator.validateAndFix(content.toString());
                        if (result.isValid()) {
                            Config loadedConfig;
                            if (result.hasIssues()) {
                                LOGGER.info("[Paradigm] Fixed JSON syntax issues in announcements.json: " + result.getIssuesSummary());
                                LOGGER.info("[Paradigm] Saving corrected version to preserve user values");
                                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                                try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                                    writer.write(result.getFixedJson());
                                    LOGGER.info("[Paradigm] Saved corrected announcements.json with preserved user values");
                                }
                                catch (IOException saveError) {
                                    LOGGER.warn("[Paradigm] Failed to save corrected file: " + saveError.getMessage());
                                }
                            }
                            if ((loadedConfig = (Config)GSON.fromJson(result.getFixedJson(), Config.class)) != null) {
                                AnnouncementsConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                                LOGGER.info("[Paradigm] Successfully loaded announcements.json configuration");
                                shouldSaveMerged = true;
                            }
                            break block30;
                        }
                        LOGGER.warn("[Paradigm] Critical JSON syntax errors in announcements.json: " + result.getMessage());
                        LOGGER.warn("[Paradigm] Please fix the JSON syntax manually. Using default values for this session.");
                        LOGGER.warn("[Paradigm] Your file has NOT been modified - fix the syntax and restart the server.");
                        break block30;
                    }
                    Config loadedConfig = (Config)GSON.fromJson(content.toString(), Config.class);
                    if (loadedConfig != null) {
                        AnnouncementsConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                        shouldSaveMerged = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("[Paradigm] Could not parse announcements.json, using defaults and regenerating file.", (Throwable)e);
                }
            } else {
                LOGGER.info("[Paradigm] announcements.json not found, generating with default values.");
            }
        }
        CONFIG = defaultConfig;
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            AnnouncementsConfigHandler.save();
            LOGGER.info("[Paradigm] Generated new announcements.json with default values.");
        } else if (shouldSaveMerged) {
            try {
                AnnouncementsConfigHandler.save();
                LOGGER.info("[Paradigm] Synchronized announcements.json with new defaults while preserving user values.");
            }
            catch (Exception e) {
                LOGGER.warn("[Paradigm] Failed to write merged announcements.json: " + e.getMessage());
            }
        }
    }

    private static void mergeConfigs(Config defaults, Config loaded) {
        try {
            Field[] fields;
            for (Field field : fields = Config.class.getDeclaredFields()) {
                if (field.getType() != ConfigEntry.class) continue;
                field.setAccessible(true);
                ConfigEntry loadedEntry = (ConfigEntry)field.get(loaded);
                ConfigEntry defaultEntry = (ConfigEntry)field.get(defaults);
                if (loadedEntry != null && loadedEntry.value != null) {
                    defaultEntry.value = loadedEntry.value;
                    LOGGER.debug("[Paradigm] Preserved user setting for: " + field.getName());
                    continue;
                }
                LOGGER.debug("[Paradigm] Using default value for new/missing config: " + field.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("[Paradigm] Error merging announcement configs", (Throwable)e);
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Announcements config", e);
        }
    }

    public static class Config {
        public ConfigEntry<String> orderMode = new ConfigEntry<String>("RANDOM", "The order in which messages are broadcast. Options: SEQUENTIAL, RANDOM");
        public ConfigEntry<Boolean> globalEnable = new ConfigEntry<Boolean>(true, "Enable or disable global announcements in chat.");
        public ConfigEntry<Boolean> headerAndFooter = new ConfigEntry<Boolean>(true, "Enable or disable the header and footer around global chat announcements.");
        public ConfigEntry<Integer> globalInterval = new ConfigEntry<Integer>(1800, "The interval in seconds between each global chat announcement.");
        public ConfigEntry<String> prefix = new ConfigEntry<String>("&9&l[&b&lPREFIX&9&l]", "A prefix prepended to all announcement messages. Use {Prefix} in messages to apply.");
        public ConfigEntry<String> header = new ConfigEntry<String>("&7*&m---------------------------------------------------&7*", "The header message sent before a global announcement.");
        public ConfigEntry<String> footer = new ConfigEntry<String>("&7*&m---------------------------------------------------&7*", "The footer message sent after a global announcement.");
        public ConfigEntry<String> sound = new ConfigEntry<String>("", "Sound to play for players when an announcement is made. E.g., 'minecraft:block.note_block.pling'. Leave empty for no sound.");
        public ConfigEntry<List<String>> globalMessages = new ConfigEntry<List<String>>(List.of("{Prefix} &7This is global message with a link: [link=https://www.google.com]"), "List of messages to be broadcast in global chat.");
        public ConfigEntry<Boolean> actionbarEnable = new ConfigEntry<Boolean>(true, "Enable or disable announcements shown on the action bar.");
        public ConfigEntry<Integer> actionbarInterval = new ConfigEntry<Integer>(1800, "The interval in seconds between each action bar announcement.");
        public ConfigEntry<List<String>> actionbarMessages = new ConfigEntry<List<String>>(List.of("{Prefix} &7This is an actionbar message."), "List of messages to be broadcast on the action bar.");
        public ConfigEntry<Boolean> titleEnable = new ConfigEntry<Boolean>(true, "Enable or disable announcements shown as a screen title.");
        public ConfigEntry<Integer> titleInterval = new ConfigEntry<Integer>(1800, "The interval in seconds between each title announcement.");
        public ConfigEntry<List<String>> titleMessages = new ConfigEntry<List<String>>(List.of("{Prefix} &7This is a title message."), "List of messages to be broadcast as a title. Use '\\n' for a subtitle.");
        public ConfigEntry<Boolean> bossbarEnable = new ConfigEntry<Boolean>(true, "Enable or disable announcements shown as a temporary boss bar.");
        public ConfigEntry<Integer> bossbarInterval = new ConfigEntry<Integer>(1800, "The interval in seconds between each boss bar announcement.");
        public ConfigEntry<String> bossbarColor = new ConfigEntry<String>("PURPLE", "Color of the boss bar. Options: BLUE, GREEN, PINK, PURPLE, RED, WHITE, YELLOW.");
        public ConfigEntry<Integer> bossbarTime = new ConfigEntry<Integer>(10, "How long the boss bar should remain on screen, in seconds.");
        public ConfigEntry<List<String>> bossbarMessages = new ConfigEntry<List<String>>(List.of("{Prefix} &7This is a bossbar message."), "List of messages to be broadcast in a boss bar.");
    }
}

