/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.JsonValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"paradigm");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("paradigm/main.json");
    public static Config CONFIG = new Config();
    private static JsonValidator jsonValidator;

    public static void setJsonValidator(DebugLogger debugLogger) {
        jsonValidator = new JsonValidator(debugLogger);
    }

    public static void load() {
        boolean shouldSaveMerged;
        Config defaultConfig;
        block30: {
            defaultConfig = new Config();
            shouldSaveMerged = false;
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH, StandardCharsets.UTF_8);){
                    int c;
                    StringBuilder content = new StringBuilder();
                    while ((c = ((Reader)reader).read()) != -1) {
                        content.append((char)c);
                    }
                    if (jsonValidator != null) {
                        JsonValidator.ValidationResult result = jsonValidator.validateAndFix(content.toString());
                        if (result.isValid()) {
                            Config loadedConfig;
                            if (result.hasIssues()) {
                                LOGGER.info("[Paradigm] Fixed JSON syntax issues in main.json: " + result.getIssuesSummary());
                                LOGGER.info("[Paradigm] Saving corrected version to preserve user values");
                                try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                                    writer.write(result.getFixedJson());
                                    LOGGER.info("[Paradigm] Saved corrected main.json with preserved user values");
                                }
                                catch (IOException saveError) {
                                    LOGGER.warn("[Paradigm] Failed to save corrected file: " + saveError.getMessage());
                                }
                            }
                            if ((loadedConfig = (Config)GSON.fromJson(result.getFixedJson(), Config.class)) != null) {
                                MainConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                                LOGGER.info("[Paradigm] Successfully loaded main.json configuration");
                                shouldSaveMerged = true;
                            }
                            break block30;
                        }
                        LOGGER.warn("[Paradigm] Critical JSON syntax errors in main.json: " + result.getMessage());
                        LOGGER.warn("[Paradigm] Please fix the JSON syntax manually. Using default values for this session.");
                        LOGGER.warn("[Paradigm] Your file has NOT been modified - fix the syntax and restart the server.");
                        break block30;
                    }
                    Config loadedConfig = (Config)GSON.fromJson(content.toString(), Config.class);
                    if (loadedConfig != null) {
                        MainConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                        shouldSaveMerged = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("[Paradigm] Could not parse main.json, using defaults and regenerating file.", (Throwable)e);
                }
            } else {
                LOGGER.info("[Paradigm] main.json not found, generating with default values.");
            }
        }
        CONFIG = defaultConfig;
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            MainConfigHandler.save();
            LOGGER.info("[Paradigm] Generated new main.json with default values.");
        } else if (shouldSaveMerged) {
            try {
                MainConfigHandler.save();
                LOGGER.info("[Paradigm] Synchronized main.json with new defaults while preserving user values.");
            }
            catch (Exception e) {
                LOGGER.warn("[Paradigm] Failed to write merged main.json: " + e.getMessage());
            }
        }
    }

    private static void mergeConfigs(Config defaults, Config loaded) {
        try {
            Field[] fields;
            for (Field field : fields = Config.class.getDeclaredFields()) {
                if (field.getType() != ConfigEntry.class) continue;
                field.setAccessible(true);
                ConfigEntry loadedEntry = (ConfigEntry)field.get(loaded);
                ConfigEntry defaultEntry = (ConfigEntry)field.get(defaults);
                if (loadedEntry != null && loadedEntry.value != null) {
                    defaultEntry.value = loadedEntry.value;
                    LOGGER.debug("[Paradigm] Preserved user setting for: " + field.getName());
                    continue;
                }
                LOGGER.debug("[Paradigm] Using default value for new/missing config: " + field.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("[Paradigm] Error merging main configs", (Throwable)e);
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Main config", e);
        }
    }

    public static class Config {
        public ConfigEntry<Boolean> announcementsEnable = new ConfigEntry<Boolean>(true, "Enables the automated announcements module.");
        public ConfigEntry<Boolean> motdEnable = new ConfigEntry<Boolean>(true, "Enables the Message of the Day module for when players join.");
        public ConfigEntry<Boolean> mentionsEnable = new ConfigEntry<Boolean>(true, "Enables the @player and @everyone mention system in chat.");
        public ConfigEntry<Boolean> restartEnable = new ConfigEntry<Boolean>(true, "Enables the automated server restart module.");
        public ConfigEntry<Boolean> debugEnable = new ConfigEntry<Boolean>(false, "Enables verbose debug logging in the console for development.");
        public ConfigEntry<String> defaultLanguage = new ConfigEntry<String>("en", "Default language file to use (e.g., 'en', 'cs'). Must match a file in the lang folder.");
        public ConfigEntry<Boolean> commandManagerEnable = new ConfigEntry<Boolean>(true, "Enables the custom commands module.");
        public ConfigEntry<Boolean> telemetryEnable = new ConfigEntry<Boolean>(true, "Enables anonymous telemetry (server count, online players). Sends only anonymized metrics.");
        public ConfigEntry<Integer> telemetryIntervalSeconds = new ConfigEntry<Integer>(900, "Telemetry ping interval in seconds.");
        public ConfigEntry<String> telemetryServerId = new ConfigEntry<String>("", "Anonymous server ID (auto-generated when empty).");
        public ConfigEntry<Boolean> webEditorTestUrl = new ConfigEntry<Boolean>(false, "Use local testing URL");
    }
}

