/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.mixin;

import eu.avalanche7.paradigm.Paradigm;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.core.Services;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public class PlayerManagerMixin {
    @Inject(method={"broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void paradigm$maybeSuppressBroadcast(Component message, boolean overlay, CallbackInfo ci) {
        if (message == null) {
            return;
        }
        Services services = Paradigm.getServices();
        if (services == null) {
            return;
        }
        ChatConfigHandler.Config chatConfig = services.getChatConfig();
        if (chatConfig == null) {
            return;
        }
        ComponentContents componentContents = message.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            String key = tc.getKey();
            if ("multiplayer.player.joined".equals(key) || "multiplayer.player.joined.renamed".equals(key)) {
                if (chatConfig.enableJoinLeaveMessages.get().booleanValue() || chatConfig.enableFirstJoinMessage.get().booleanValue()) {
                    ci.cancel();
                }
                return;
            }
            if ("multiplayer.player.left".equals(key) && chatConfig.enableJoinLeaveMessages.get().booleanValue()) {
                ci.cancel();
            }
        }
    }
}

