/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

public class CustomCommands
implements ParadigmModule {
    private static final String NAME = "CustomCommands";
    private Services services;
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return services.getMainConfig().commandManagerEnable.get();
    }

    @Override
    public void onLoad(FMLCommonSetupEvent event, Services services, IEventBus modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("CustomCommands module loaded.");
        services.getCmConfig().loadCommands();
    }

    @Override
    public void onServerStarting(ServerStartingEvent event, Services services) {
    }

    @Override
    public void onEnable(Services services) {
    }

    @Override
    public void onDisable(Services services) {
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event, Services services) {
    }

    @Override
    public void registerCommands(CommandDispatcher<?> dispatcher, Services services) {
        CommandDispatcher<?> dispatcherCS = dispatcher;
        services.getCmConfig().getLoadedCommands().forEach(command -> {
            LiteralArgumentBuilder commandBuilder = (LiteralArgumentBuilder)Commands.literal((String)command.getName()).requires(source -> this.platform.hasPermissionForCustomCommand(source, (CustomCommand)command));
            commandBuilder = command.getArguments().isEmpty() ? (LiteralArgumentBuilder)((LiteralArgumentBuilder)commandBuilder.executes(ctx -> {
                ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
                this.executeCustomCommand(source, (CustomCommand)command, new String[0]);
                return 1;
            })).then(Commands.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
                String rawArgs = StringArgumentType.getString((CommandContext)ctx, (String)"args");
                String[] argsTokens = this.tokenizeArgs(rawArgs);
                ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
                this.executeCustomCommand(source, (CustomCommand)command, argsTokens);
                return 1;
            })) : this.buildTypedCommand((LiteralArgumentBuilder<CommandSourceStack>)commandBuilder, (CustomCommand)command, 0);
            dispatcherCS.register(commandBuilder);
        });
        dispatcherCS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"customcommandsreload").requires(source -> source.hasPermission(2))).executes(ctx -> {
            services.getCmConfig().reloadCommands();
            IComponent message = services.getMessageParser().parseMessage("&aReloaded custom commands from config.", null);
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            this.platform.sendSuccess(source, message, false);
            return 1;
        }));
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildTypedCommand(LiteralArgumentBuilder<CommandSourceStack> builder, CustomCommand command, int argIndex) {
        List<CustomCommand.ArgumentDefinition> args = command.getArguments();
        if (argIndex >= args.size()) {
            return (LiteralArgumentBuilder)builder.executes(ctx -> this.executeTypedCommand((CommandContext<CommandSourceStack>)ctx, command, args));
        }
        CustomCommand.ArgumentDefinition argDef = args.get(argIndex);
        RequiredArgumentBuilder argBuilder = this.createArgumentBuilder(argDef);
        argBuilder = argBuilder.suggests(this.createSuggestionProvider(argDef));
        if (!argDef.isRequired()) {
            builder = (LiteralArgumentBuilder)builder.executes(ctx -> this.executeTypedCommand((CommandContext<CommandSourceStack>)ctx, command, args));
        }
        argBuilder = argIndex == args.size() - 1 ? (RequiredArgumentBuilder)argBuilder.executes(ctx -> this.executeTypedCommand((CommandContext<CommandSourceStack>)ctx, command, args)) : (RequiredArgumentBuilder)argBuilder.then(this.buildNextArgument(command, argIndex + 1));
        return (LiteralArgumentBuilder)builder.then((ArgumentBuilder)argBuilder);
    }

    private RequiredArgumentBuilder<CommandSourceStack, ?> buildNextArgument(CustomCommand command, int argIndex) {
        List<CustomCommand.ArgumentDefinition> args = command.getArguments();
        if (argIndex >= args.size()) {
            return Commands.argument((String)"dummy", (ArgumentType)StringArgumentType.string());
        }
        CustomCommand.ArgumentDefinition argDef = args.get(argIndex);
        RequiredArgumentBuilder argBuilder = this.createArgumentBuilder(argDef);
        argBuilder = argBuilder.suggests(this.createSuggestionProvider(argDef));
        if (!argDef.isRequired()) {
            argBuilder = (RequiredArgumentBuilder)argBuilder.executes(ctx -> this.executeTypedCommand((CommandContext<CommandSourceStack>)ctx, command, args));
        }
        argBuilder = argIndex == args.size() - 1 ? (RequiredArgumentBuilder)argBuilder.executes(ctx -> this.executeTypedCommand((CommandContext<CommandSourceStack>)ctx, command, args)) : (RequiredArgumentBuilder)argBuilder.then(this.buildNextArgument(command, argIndex + 1));
        return argBuilder;
    }

    private RequiredArgumentBuilder<CommandSourceStack, ?> createArgumentBuilder(CustomCommand.ArgumentDefinition argDef) {
        switch (argDef.getType()) {
            case "integer": {
                if (argDef.getMinValue() != null && argDef.getMaxValue() != null) {
                    return Commands.argument((String)argDef.getName(), (ArgumentType)IntegerArgumentType.integer((int)argDef.getMinValue(), (int)argDef.getMaxValue()));
                }
                if (argDef.getMinValue() != null) {
                    return Commands.argument((String)argDef.getName(), (ArgumentType)IntegerArgumentType.integer((int)argDef.getMinValue()));
                }
                return Commands.argument((String)argDef.getName(), (ArgumentType)IntegerArgumentType.integer());
            }
            case "boolean": {
                return Commands.argument((String)argDef.getName(), (ArgumentType)BoolArgumentType.bool());
            }
        }
        return Commands.argument((String)argDef.getName(), (ArgumentType)StringArgumentType.string());
    }

    private SuggestionProvider<CommandSourceStack> createSuggestionProvider(CustomCommand.ArgumentDefinition argDef) {
        return (ctx, builder) -> {
            switch (argDef.getType()) {
                case "player": {
                    return SharedSuggestionProvider.suggest(this.platform.getOnlinePlayerNames(), (SuggestionsBuilder)builder);
                }
                case "world": {
                    return SharedSuggestionProvider.suggest(this.platform.getWorldNames(), (SuggestionsBuilder)builder);
                }
                case "gamemode": {
                    return SharedSuggestionProvider.suggest(List.of("survival", "creative", "adventure", "spectator"), (SuggestionsBuilder)builder);
                }
                case "custom": {
                    return SharedSuggestionProvider.suggest(argDef.getCustomCompletions(), (SuggestionsBuilder)builder);
                }
                case "boolean": {
                    return SharedSuggestionProvider.suggest(List.of("true", "false"), (SuggestionsBuilder)builder);
                }
            }
            return Suggestions.empty();
        };
    }

    private int executeTypedCommand(CommandContext<CommandSourceStack> ctx, CustomCommand command, List<CustomCommand.ArgumentDefinition> argDefs) {
        ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
        String[] validatedArgs = new String[argDefs.size()];
        for (int i = 0; i < argDefs.size(); ++i) {
            CustomCommand.ArgumentDefinition argDef = argDefs.get(i);
            try {
                Object value = this.getArgumentValue(ctx, argDef);
                if (value == null && argDef.isRequired()) {
                    this.platform.sendFailure(source, this.services.getMessageParser().parseMessage(argDef.getErrorMessage(), source.getPlayer()));
                    return 0;
                }
                validatedArgs[i] = value != null ? value.toString() : "";
                continue;
            }
            catch (Exception e) {
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage(argDef.getErrorMessage(), source.getPlayer()));
                return 0;
            }
        }
        this.executeCustomCommand(source, command, validatedArgs);
        return 1;
    }

    private Object getArgumentValue(CommandContext<CommandSourceStack> ctx, CustomCommand.ArgumentDefinition argDef) {
        try {
            switch (argDef.getType()) {
                case "integer": {
                    return IntegerArgumentType.getInteger(ctx, (String)argDef.getName());
                }
                case "boolean": {
                    return BoolArgumentType.getBool(ctx, (String)argDef.getName());
                }
            }
            return StringArgumentType.getString(ctx, (String)argDef.getName());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void executeCustomCommand(ICommandSource source, CustomCommand command, String[] argsTokens) {
        IPlayer player = source.getPlayer();
        CustomCommand.AreaRestriction area = command.getAreaRestriction();
        if (area != null) {
            if (player == null) {
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cThis command can only be run by a player in a specific area.", null));
                return;
            }
            if (!this.platform.isPlayerInArea(player, area.getWorld(), area.getCorner1(), area.getCorner2())) {
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage(area.getRestrictionMessage(), player));
                return;
            }
        }
        if (command.getCooldownSeconds() != null && command.getCooldownSeconds() > 0 && player != null) {
            long lastUsage = this.services.getCooldownConfigHandler().getLastUsage(UUID.fromString(player.getUUID()), command.getName());
            long cooldownMillis = (long)command.getCooldownSeconds().intValue() * 1000L;
            long currentTime = System.currentTimeMillis();
            if (currentTime < lastUsage + cooldownMillis) {
                long remainingMillis = lastUsage + cooldownMillis - currentTime;
                long remainingSeconds = remainingMillis / 1000L + (long)(remainingMillis % 1000L > 0L ? 1 : 0);
                String cooldownMessage = command.getCooldownMessage();
                if (cooldownMessage == null || cooldownMessage.isEmpty()) {
                    cooldownMessage = "&cThis command is on cooldown! Please wait &e{remaining_time} &cseconds.";
                }
                String formattedMessage = cooldownMessage.replace("{remaining_time}", String.valueOf(remainingSeconds));
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage(formattedMessage, player));
                return;
            }
            this.services.getCooldownConfigHandler().setLastUsage(UUID.fromString(player.getUUID()), command.getName(), currentTime);
        }
        String rawArgs = String.join((CharSequence)" ", argsTokens);
        this.executeActions(source, command.getActions(), player, argsTokens, rawArgs);
    }

    private String[] tokenizeArgs(String rawArgs) {
        if (rawArgs == null || rawArgs.isBlank()) {
            return new String[0];
        }
        return rawArgs.trim().split("\\s+");
    }

    private void executeActions(ICommandSource source, List<CustomCommand.Action> actions, IPlayer player, String[] argsTokens, String rawArgs) {
        block15: for (CustomCommand.Action action : actions) {
            switch (action.getType()) {
                case "message": {
                    if (action.getText() == null) continue block15;
                    for (String line : action.getText()) {
                        String expandedLine = this.expandCommand(line, player, argsTokens, rawArgs);
                        IComponent formattedMessage = this.services.getMessageParser().parseMessage(expandedLine, player);
                        this.platform.sendSuccess(source, formattedMessage, false);
                    }
                    continue block15;
                }
                case "teleport": {
                    if (player != null && action.getX() != null && action.getY() != null && action.getZ() != null) {
                        this.platform.teleportPlayer(player, action.getX().intValue(), action.getY().intValue(), action.getZ().intValue());
                        break;
                    }
                    if (player == null) {
                        this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cTeleport action can only be performed by a player.", null));
                        break;
                    }
                    this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cInvalid teleport coordinates.", player));
                    break;
                }
                case "run_command": 
                case "runcmd": {
                    String processed;
                    if (action.getCommands() == null) continue block15;
                    for (String cmd : action.getCommands()) {
                        processed = this.expandCommand(cmd, player, argsTokens, rawArgs);
                        this.platform.executeCommandAs(source, processed);
                    }
                    continue block15;
                }
                case "run_console": {
                    String processed;
                    if (action.getCommands() == null) continue block15;
                    for (String cmd : action.getCommands()) {
                        processed = this.expandCommand(cmd, player, argsTokens, rawArgs);
                        this.platform.executeCommandAsConsole(processed);
                    }
                    continue block15;
                }
                case "conditional": {
                    if (this.checkAllConditions(source, action.getConditions(), player)) {
                        this.executeActions(source, action.getOnSuccess(), player, argsTokens, rawArgs);
                        break;
                    }
                    this.executeActions(source, action.getOnFailure(), player, argsTokens, rawArgs);
                    break;
                }
                default: {
                    this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cUnknown action type: " + action.getType(), player));
                }
            }
        }
    }

    private String expandCommand(String cmd, IPlayer player, String[] argsTokens, String rawArgs) {
        String out = this.platform.replacePlaceholders(cmd, player);
        if (out.contains("$*")) {
            out = out.replace("$*", rawArgs == null ? "" : rawArgs);
        }
        for (int i = 0; i < argsTokens.length; ++i) {
            String token = "$" + (i + 1);
            if (!out.contains(token)) continue;
            String argValue = argsTokens[i];
            if (argValue == null || argValue.isEmpty()) {
                argValue = "";
            }
            out = out.replace(token, argValue);
        }
        out = out.replaceAll("\\$(?:[1-9][0-9]*)", "");
        return out.trim();
    }

    private boolean checkAllConditions(ICommandSource source, List<CustomCommand.Condition> conditions, IPlayer player) {
        if (conditions.isEmpty()) {
            return true;
        }
        for (CustomCommand.Condition condition : conditions) {
            if (this.checkCondition(source, condition, player)) continue;
            return false;
        }
        return true;
    }

    private boolean checkCondition(ICommandSource source, CustomCommand.Condition condition, IPlayer player) {
        boolean result = false;
        if (player == null) {
            switch (condition.getType()) {
                case "has_permission": 
                case "has_item": 
                case "is_op": {
                    this.services.getDebugLogger().debugLog("Conditional check '" + condition.getType() + "' requires a player, but was run from console. Failing condition.");
                    return false;
                }
            }
        }
        switch (condition.getType()) {
            case "has_permission": {
                if (player == null || condition.getValue() == null) break;
                result = this.platform.hasPermission(player, condition.getValue());
                break;
            }
            case "has_item": {
                if (player == null || condition.getValue() == null) break;
                result = this.platform.playerHasItem(player, condition.getValue(), condition.getItemAmount());
                break;
            }
            case "is_op": {
                if (player == null) break;
                int level = 2;
                try {
                    if (condition.getValue() != null) {
                        level = Integer.parseInt(condition.getValue());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                result = this.platform.hasPermission(player, "minecraft.command.op", level);
                break;
            }
            default: {
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cUnknown condition type: " + condition.getType(), player));
                return false;
            }
        }
        return condition.isNegate() != result;
    }

    @Override
    public void registerEventListeners(IEventBus forgeEventBus, Services services) {
    }
}

