/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IEventSystem;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.commands.Commands;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

public class Mentions
implements ParadigmModule,
IEventSystem.ChatEventListener {
    private static final String NAME = "Mentions";
    private final HashMap<String, Long> lastIndividualMentionBySender = new HashMap();
    private final HashMap<String, Long> lastEveryoneMentionBySender = new HashMap();
    private Services services;
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return services.getMainConfig().mentionsEnable.get();
    }

    @Override
    public void onLoad(FMLCommonSetupEvent event, Services services, IEventBus modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("Mentions module loaded.");
    }

    @Override
    public void onServerStarting(ServerStartingEvent event, Services services) {
    }

    @Override
    public void onEnable(Services services) {
    }

    @Override
    public void onDisable(Services services) {
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event, Services services) {
    }

    @Override
    public void registerCommands(CommandDispatcher<?> dispatcher, Services services) {
        CommandDispatcher<?> dispatcherCS = dispatcher;
        dispatcherCS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mention").requires(source -> source.hasPermission(0))).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this::executeMentionCommand)));
    }

    @Override
    public void registerEventListeners(IEventBus forgeEventBus, Services services) {
        this.platform.getEventSystem().registerChatListener(this);
    }

    @Override
    public void onPlayerChat(IEventSystem.ChatEvent event) {
        if (this.services == null || !this.isEnabled(this.services)) {
            return;
        }
        String rawMessage = event.getMessage();
        IPlayer sender = event.getPlayer();
        String mentionSymbol = MentionConfigHandler.CONFIG.MENTION_SYMBOL.get();
        String everyoneMentionPlaceholder = mentionSymbol + "everyone";
        Pattern everyonePattern = Pattern.compile(Pattern.quote(everyoneMentionPlaceholder), 2);
        Matcher everyoneMatcher = everyonePattern.matcher(rawMessage);
        if (everyoneMatcher.find()) {
            if (!this.platform.hasPermission(sender, "paradigm.mention.everyone", 2)) {
                this.platform.sendSystemMessage(sender, this.services.getLang().translate("mention.no_permission_everyone"));
                event.setCancelled(true);
                return;
            }
            if (!this.canMentionEveryoneNow(sender)) {
                this.platform.sendSystemMessage(sender, this.services.getLang().translate("mention.too_frequent_mention_everyone"));
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            this.notifyEveryone(this.platform.getOnlinePlayers(), sender, rawMessage, false, everyoneMatcher.group(0));
            this.markMentionEveryoneUsed(sender);
            this.sendSenderFeedbackEveryone(sender, rawMessage, everyoneMatcher.group(0));
            return;
        }
        Pattern allPlayersPattern = this.buildAllPlayersMentionPattern(this.platform.getOnlinePlayers(), mentionSymbol);
        Matcher mentionMatcher = allPlayersPattern.matcher(rawMessage);
        if (!mentionMatcher.find()) {
            return;
        }
        mentionMatcher.reset();
        if (!this.platform.hasPermission(sender, "paradigm.mention.player", 0)) {
            return;
        }
        if (!this.canMentionIndividualNow(sender)) {
            this.platform.sendSystemMessage(sender, this.services.getLang().translate("mention.too_frequent_mention_player"));
            event.setCancelled(true);
            return;
        }
        IComponent finalMessageComponent = this.platform.createLiteralComponent("");
        int lastEnd = 0;
        boolean mentionedSomeone = false;
        LinkedHashSet<String> mentionedNames = new LinkedHashSet<String>();
        while (mentionMatcher.find()) {
            String playerName = mentionMatcher.group(1);
            IPlayer targetPlayer = this.platform.getPlayerByName(playerName);
            if (targetPlayer == null) continue;
            mentionedSomeone = true;
            mentionedNames.add(targetPlayer.getName());
            finalMessageComponent.append(this.platform.createLiteralComponent(rawMessage.substring(lastEnd, mentionMatcher.start())));
            this.notifyPlayer(targetPlayer, sender, rawMessage, false, mentionMatcher.group(0));
            finalMessageComponent.append(this.platform.getPlayerDisplayName(targetPlayer));
            lastEnd = mentionMatcher.end();
        }
        if (mentionedSomeone) {
            event.setCancelled(true);
            finalMessageComponent.append(this.platform.createLiteralComponent(rawMessage.substring(lastEnd)));
            IComponent finalMessage = this.platform.createTranslatableComponent("chat.type.text", this.platform.getPlayerDisplayName(sender), finalMessageComponent);
            this.platform.broadcastChatMessage(finalMessage);
            this.markMentionIndividualUsed(sender);
            this.sendSenderFeedbackPlayers(sender, rawMessage, mentionedNames, allPlayersPattern);
        }
    }

    private int executeMentionCommand(CommandContext<?> context) {
        ICommandSource source = this.platform.wrapCommandSource(context.getSource());
        String message = StringArgumentType.getString(context, (String)"message");
        boolean isConsole = source.isConsole();
        IPlayer sender = source.getPlayer();
        String everyoneMentionPlaceholder = MentionConfigHandler.CONFIG.MENTION_SYMBOL.get() + "everyone";
        Matcher everyoneMatcher = Pattern.compile(Pattern.quote(everyoneMentionPlaceholder), 2).matcher(message);
        if (everyoneMatcher.find()) {
            if (sender != null) {
                if (!this.platform.hasPermission(sender, "paradigm.mention.everyone", 2)) {
                    this.platform.sendSystemMessage(sender, this.services.getLang().translate("mention.no_permission_everyone"));
                    return 0;
                }
                if (!this.canMentionEveryoneNow(sender)) {
                    this.platform.sendSystemMessage(sender, this.services.getLang().translate("mention.too_frequent_mention_everyone"));
                    return 0;
                }
            }
            this.notifyEveryone(this.platform.getOnlinePlayers(), sender, message, isConsole, everyoneMatcher.group(0));
            if (sender != null) {
                this.markMentionEveryoneUsed(sender);
                this.sendSenderFeedbackEveryone(sender, message, everyoneMatcher.group(0));
            }
            this.platform.sendSuccess(source, this.platform.createLiteralComponent("Mentioned everyone successfully."), !isConsole);
            return 1;
        }
        List<IPlayer> players = this.platform.getOnlinePlayers();
        Pattern allPlayersPattern = this.buildAllPlayersMentionPattern(players, MentionConfigHandler.CONFIG.MENTION_SYMBOL.get());
        Matcher m = allPlayersPattern.matcher(message);
        boolean containsAnyMention = m.find();
        if (containsAnyMention && sender != null) {
            if (!this.platform.hasPermission(sender, "paradigm.mention.player", 0)) {
                this.platform.sendFailure(source, this.platform.createLiteralComponent("No permission to mention players."));
                return 0;
            }
            if (!this.canMentionIndividualNow(sender)) {
                this.platform.sendFailure(source, this.services.getLang().translate("mention.too_frequent_mention_player"));
                return 0;
            }
        }
        int mentionedCount = 0;
        LinkedHashSet<String> mentionedNames = new LinkedHashSet<String>();
        for (IPlayer targetPlayer : players) {
            String playerMentionPlaceholder = MentionConfigHandler.CONFIG.MENTION_SYMBOL.get() + targetPlayer.getName();
            Pattern playerMentionPattern = Pattern.compile(Pattern.quote(playerMentionPlaceholder), 2);
            if (!playerMentionPattern.matcher(message).find()) continue;
            this.notifyPlayer(targetPlayer, sender, message, isConsole, playerMentionPlaceholder);
            ++mentionedCount;
            mentionedNames.add(targetPlayer.getName());
        }
        if (mentionedCount > 0) {
            if (sender != null) {
                this.markMentionIndividualUsed(sender);
                this.sendSenderFeedbackPlayers(sender, message, mentionedNames, allPlayersPattern);
            }
            this.platform.sendSuccess(source, this.platform.createLiteralComponent("Mentioned " + mentionedCount + " player(s) successfully."), !isConsole);
        } else {
            this.platform.sendFailure(source, this.platform.createLiteralComponent("No valid mentions found in the message."));
        }
        return mentionedCount > 0 ? 1 : 0;
    }

    private void notifyEveryone(List<IPlayer> players, IPlayer sender, String originalMessage, boolean isConsole, String matchedEveryoneMention) {
        String senderName = isConsole || sender == null ? "Console" : sender.getName();
        String chatFormat = MentionConfigHandler.CONFIG.EVERYONE_MENTION_MESSAGE.get();
        String titleFormat = MentionConfigHandler.CONFIG.EVERYONE_TITLE_MESSAGE.get();
        String content = this.extractContentAfterToken(originalMessage, matchedEveryoneMention);
        String chatMessageText = String.format(chatFormat, senderName);
        String titleMessageText = String.format(titleFormat, senderName);
        for (IPlayer targetPlayer : players) {
            this.sendMentionNotification(targetPlayer, chatMessageText, titleMessageText, content);
        }
    }

    private void notifyPlayer(IPlayer targetPlayer, IPlayer sender, String originalMessage, boolean isConsole, String matchedPlayerMention) {
        String senderName = isConsole || sender == null ? "Console" : sender.getName();
        String chatFormat = MentionConfigHandler.CONFIG.INDIVIDUAL_MENTION_MESSAGE.get();
        String titleFormat = MentionConfigHandler.CONFIG.INDIVIDUAL_TITLE_MESSAGE.get();
        String content = this.extractContentAfterToken(originalMessage, matchedPlayerMention);
        String chatMessageText = String.format(chatFormat, senderName);
        String titleMessageText = String.format(titleFormat, senderName);
        this.sendMentionNotification(targetPlayer, chatMessageText, titleMessageText, content);
    }

    private void sendMentionNotification(IPlayer targetPlayer, String chatMessage, String titleMessage, String contentMessage) {
        boolean enableChat = MentionConfigHandler.CONFIG.enableChatNotification.get();
        boolean enableTitle = MentionConfigHandler.CONFIG.enableTitleNotification.get();
        boolean enableSubtitle = MentionConfigHandler.CONFIG.enableSubtitleNotification.get();
        if (enableChat) {
            IComponent mainComponent = this.services.getMessageParser().parseMessage(chatMessage, targetPlayer);
            if (contentMessage != null && !contentMessage.isEmpty()) {
                String prefix = MentionConfigHandler.CONFIG.CHAT_APPEND_PREFIX.get();
                IComponent contentComponent = this.services.getMessageParser().parseMessage(contentMessage, targetPlayer);
                mainComponent.append(this.platform.createLiteralComponent("\n" + prefix)).append(contentComponent);
            }
            IComponent finalChatMessage = mainComponent;
            this.platform.sendSystemMessage(targetPlayer, finalChatMessage);
        }
        if (enableTitle) {
            IComponent parsedTitleMessage = this.services.getMessageParser().parseMessage(titleMessage, targetPlayer);
            IComponent parsedSubtitleMessage = this.platform.createLiteralComponent("");
            if (enableSubtitle && contentMessage != null && !contentMessage.isEmpty()) {
                parsedSubtitleMessage = this.services.getMessageParser().parseMessage(contentMessage, targetPlayer);
            }
            this.platform.sendTitle(targetPlayer, parsedTitleMessage, parsedSubtitleMessage);
        }
        this.platform.playSound(targetPlayer, "minecraft:entity.player.levelup", IPlatformAdapter.SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    private Pattern buildAllPlayersMentionPattern(List<IPlayer> players, String mentionSymbol) {
        if (players.isEmpty()) {
            return Pattern.compile("a^");
        }
        String allPlayerNames = players.stream().map(IPlayer::getName).map(Pattern::quote).collect(Collectors.joining("|"));
        return Pattern.compile(Pattern.quote(mentionSymbol) + "(" + allPlayerNames + ")", 2);
    }

    private boolean canMentionEveryoneNow(IPlayer sender) {
        if (sender == null) {
            return true;
        }
        if (this.platform.hasPermission(sender, "minecraft.command.op", 2)) {
            return true;
        }
        int rateLimit = MentionConfigHandler.CONFIG.EVERYONE_MENTION_RATE_LIMIT.get();
        if (rateLimit <= 0) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        String key = sender.getUUID();
        Long last = this.lastEveryoneMentionBySender.get(key);
        return last == null || currentTime - last >= (long)rateLimit * 1000L;
    }

    private void markMentionEveryoneUsed(IPlayer sender) {
        if (sender == null) {
            return;
        }
        this.lastEveryoneMentionBySender.put(sender.getUUID(), System.currentTimeMillis());
    }

    private boolean canMentionIndividualNow(IPlayer sender) {
        if (sender == null) {
            return true;
        }
        if (this.platform.hasPermission(sender, "minecraft.command.op", 2)) {
            return true;
        }
        int rateLimit = MentionConfigHandler.CONFIG.INDIVIDUAL_MENTION_RATE_LIMIT.get();
        if (rateLimit <= 0) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        String key = sender.getUUID();
        Long last = this.lastIndividualMentionBySender.get(key);
        return last == null || currentTime - last >= (long)rateLimit * 1000L;
    }

    private void markMentionIndividualUsed(IPlayer sender) {
        if (sender == null) {
            return;
        }
        this.lastIndividualMentionBySender.put(sender.getUUID(), System.currentTimeMillis());
    }

    private void sendSenderFeedbackEveryone(IPlayer sender, String fullMessage, String matchedToken) {
        if (sender == null) {
            return;
        }
        String base = MentionConfigHandler.CONFIG.SENDER_FEEDBACK_EVERYONE_MESSAGE.get();
        IComponent feedback = this.services.getMessageParser().parseMessage(base, sender);
        String appended = this.extractContentAfterToken(fullMessage, matchedToken);
        if (!appended.isEmpty()) {
            String prefix = MentionConfigHandler.CONFIG.CHAT_APPEND_PREFIX.get();
            IComponent nl = this.platform.createLiteralComponent("\n" + prefix);
            IComponent appendedComp = this.services.getMessageParser().parseMessage(appended, sender);
            feedback = feedback.append(nl).append(appendedComp);
        }
        this.platform.sendSystemMessage(sender, feedback);
    }

    private void sendSenderFeedbackPlayers(IPlayer sender, String fullMessage, Set<String> mentionedNames, Pattern firstMentionPattern) {
        if (sender == null || mentionedNames.isEmpty()) {
            return;
        }
        String list = String.join((CharSequence)", ", mentionedNames);
        String formatted = String.format(MentionConfigHandler.CONFIG.SENDER_FEEDBACK_PLAYER_MESSAGE.get(), list);
        IComponent feedback = this.services.getMessageParser().parseMessage(formatted, sender);
        String appended = this.extractContentAfterFirstMatch(fullMessage, firstMentionPattern);
        if (!appended.isEmpty()) {
            String prefix = MentionConfigHandler.CONFIG.CHAT_APPEND_PREFIX.get();
            IComponent nl = this.platform.createLiteralComponent("\n" + prefix);
            IComponent appendedComp = this.services.getMessageParser().parseMessage(appended, sender);
            feedback = feedback.append(nl).append(appendedComp);
        }
        this.platform.sendSystemMessage(sender, feedback);
    }

    private String extractContentAfterToken(String originalMessage, String matchedToken) {
        if (originalMessage == null || matchedToken == null) {
            return "";
        }
        int idx = originalMessage.toLowerCase().indexOf(matchedToken.toLowerCase());
        if (idx < 0) {
            return "";
        }
        int end = idx + matchedToken.length();
        if (end >= originalMessage.length()) {
            return "";
        }
        return originalMessage.substring(end).replaceAll("[\\r\\n]+", " ").trim();
    }

    private String extractContentAfterFirstMatch(String message, Pattern pattern) {
        if (message == null || pattern == null) {
            return "";
        }
        Matcher m = pattern.matcher(message);
        if (!m.find()) {
            return "";
        }
        int end = m.end();
        if (end >= message.length()) {
            return "";
        }
        return message.substring(end).replaceAll("[\\r\\n]+", " ").trim();
    }
}

