/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules.chat;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.modules.chat.StaffChat;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IEventSystem;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import eu.avalanche7.paradigm.utils.GroupChatManager;
import java.util.UUID;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

public class GroupChat
implements ParadigmModule,
IEventSystem.ChatEventListener {
    private static final String NAME = "GroupChat";
    private GroupChatManager groupChatManager;
    private IPlatformAdapter platform;
    private Services services;

    public GroupChat(GroupChatManager groupChatManager) {
        this.groupChatManager = groupChatManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        try {
            return services.getChatConfig().enableGroupChat.get();
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    @Override
    public void onLoad(FMLCommonSetupEvent event, Services services, IEventBus modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("GroupChat module loaded.");
    }

    @Override
    public void onServerStarting(ServerStartingEvent event, Services services) {
    }

    @Override
    public void onEnable(Services services) {
    }

    @Override
    public void onDisable(Services services) {
        if (this.groupChatManager != null) {
            this.groupChatManager.clearAllGroupsAndPlayerData();
        }
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event, Services services) {
        this.onDisable(services);
    }

    @Override
    public void registerCommands(CommandDispatcher<?> dispatcher, Services services) {
        CommandDispatcher<?> dispatcherCS = dispatcher;
        dispatcherCS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"groupchat").executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            if (player != null) {
                this.displayHelp(player);
            }
            return 1;
        })).then(Commands.literal((String)"create").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            return player != null && this.groupChatManager.createGroup(player, StringArgumentType.getString((CommandContext)ctx, (String)"name")) ? 1 : 0;
        })))).then(Commands.literal((String)"delete").executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            return player != null && this.groupChatManager.deleteGroup(player) ? 1 : 0;
        }))).then(Commands.literal((String)"invite").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer inviter = source.getPlayer();
            IPlayer target = MinecraftPlayer.of(EntityArgument.getPlayer((CommandContext)ctx, (String)"player"));
            return inviter != null && this.groupChatManager.invitePlayer(inviter, target) ? 1 : 0;
        })))).then(Commands.literal((String)"join").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            if (player != null) {
                this.groupChatManager.requestJoinGroup(player, StringArgumentType.getString((CommandContext)ctx, (String)"name"));
                return 1;
            }
            return 0;
        })))).then(Commands.literal((String)"list").executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            if (player != null) {
                this.groupChatManager.listGroups(player);
            }
            return 1;
        }))).then(Commands.literal((String)"accept").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            if (player != null) {
                return this.groupChatManager.acceptInvite(player, StringArgumentType.getString((CommandContext)ctx, (String)"group")) ? 1 : 0;
            }
            return 0;
        })))).then(Commands.literal((String)"acceptreq").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer owner = source.getPlayer();
            String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            if (owner != null) {
                return this.groupChatManager.acceptJoinRequest(owner, playerName) ? 1 : 0;
            }
            return 0;
        })))).then(Commands.literal((String)"deny").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            if (player != null) {
                return this.groupChatManager.denyInvite(player, StringArgumentType.getString((CommandContext)ctx, (String)"group")) ? 1 : 0;
            }
            return 0;
        })))).then(Commands.literal((String)"denyreq").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer owner = source.getPlayer();
            String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            if (owner != null) {
                return this.groupChatManager.denyJoinRequest(owner, playerName) ? 1 : 0;
            }
            return 0;
        })))).then(Commands.literal((String)"leave").executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            return player != null && this.groupChatManager.leaveGroup(player) ? 1 : 0;
        }))).then(Commands.literal((String)"toggle").executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            if (player != null) {
                this.groupChatManager.toggleGroupChat(player);
            }
            return 1;
        }))).then(Commands.literal((String)"help").executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer player = source.getPlayer();
            if (player != null) {
                this.displayHelp(player);
            }
            return 1;
        }))).then(Commands.literal((String)"kick").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ICommandSource source = this.platform.wrapCommandSource(ctx.getSource());
            if (!this.checkGroupEnabled(source)) {
                return 0;
            }
            IPlayer owner = source.getPlayer();
            String targetName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            if (owner != null) {
                return this.groupChatManager.kickMember(owner, targetName) ? 1 : 0;
            }
            return 0;
        }))));
    }

    private boolean checkGroupEnabled(ICommandSource source) {
        try {
            if (!this.services.getChatConfig().enableGroupChat.get().booleanValue()) {
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cGroup chat is disabled.", null));
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void registerEventListeners(IEventBus forgeEventBus, Services services) {
        this.platform.getEventSystem().registerChatListener(this);
    }

    @Override
    public void onPlayerChat(IEventSystem.ChatEvent event) {
        if (this.services == null || !this.isEnabled(this.services) || this.groupChatManager == null) {
            return;
        }
        IPlayer player = event.getPlayer();
        if (StaffChat.isStaffChatEnabled(UUID.fromString(player.getUUID()))) {
            return;
        }
        if (this.groupChatManager.isGroupChatToggled(player)) {
            String groupName = this.groupChatManager.getPlayerData(player).getCurrentGroup();
            if (groupName != null) {
                event.setCancelled(true);
                this.groupChatManager.sendMessageToGroup(player, groupName, event.getMessage());
                this.services.getLogger().info("[GroupChat] [{}] {}: {}", new Object[]{groupName, player.getName(), event.getMessage()});
            } else {
                this.platform.sendSystemMessage(player, this.services.getLang().translate("group.no_group_to_send_message"));
                this.groupChatManager.setGroupChatToggled(player, false);
                this.platform.sendSystemMessage(player, this.services.getLang().translate("group.chat_disabled"));
            }
        }
    }

    private void displayHelp(IPlayer player) {
        String label = "groupchat";
        this.platform.sendSystemMessage(player, this.services.getLang().translate("group.help_title"));
        this.sendHelpMessage(player, label, "create <n>", "group.help_create");
        this.sendHelpMessage(player, label, "delete", "group.help_delete");
        this.sendHelpMessage(player, label, "invite <player>", "group.help_invite");
        this.sendHelpMessage(player, label, "join <group>", "group.help_join");
        this.sendHelpMessage(player, label, "accept <group>", "group.help_accept");
        this.sendHelpMessage(player, label, "deny <group>", "group.help_deny");
        this.sendHelpMessage(player, label, "accept <player>", "group.help_acceptreq");
        this.sendHelpMessage(player, label, "deny <player>", "group.help_denyreq");
        this.sendHelpMessage(player, label, "requests", "group.help_requests");
        this.sendHelpMessage(player, label, "leave", "group.help_leave");
        this.sendHelpMessage(player, label, "list", "group.help_list");
        this.sendHelpMessage(player, label, "info [group]", "group.help_info");
        this.sendHelpMessage(player, label, "say <message>", "group.help_say");
        this.sendHelpMessage(player, label, "toggle", "group.help_toggle");
        this.sendHelpMessage(player, label, "kick <player>", "group.help_kick");
    }

    private void sendHelpMessage(IPlayer player, String label, String command, String descriptionKey) {
        String translatedDescription = this.services.getLang().translate(descriptionKey).getRawText();
        IComponent hoverText = this.platform.createLiteralComponent(translatedDescription);
        IComponent message = this.platform.createLiteralComponent(" \u00a79> \u00a7e/" + label + " " + command).withColorHex("FFFF55").onClickSuggestCommand("/" + label + " " + command).onHoverComponent(hoverText);
        this.platform.sendSystemMessage(player, message);
    }
}

