/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.platform;

import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IEventSystem;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class MinecraftEventSystem
implements IEventSystem {
    private final CopyOnWriteArrayList<IEventSystem.ChatEventListener> chatListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<IEventSystem.PlayerJoinEventListener> joinListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<IEventSystem.PlayerLeaveEventListener> leaveListeners = new CopyOnWriteArrayList();

    @Override
    public void registerChatListener(IEventSystem.ChatEventListener listener) {
        this.chatListeners.add(listener);
    }

    @Override
    public void registerJoinListener(IEventSystem.PlayerJoinEventListener listener) {
        this.joinListeners.add(listener);
    }

    @Override
    public void registerLeaveListener(IEventSystem.PlayerLeaveEventListener listener) {
        this.leaveListeners.add(listener);
    }

    @Override
    public void unregisterChatListener(IEventSystem.ChatEventListener listener) {
        this.chatListeners.remove(listener);
    }

    @Override
    public void unregisterJoinListener(IEventSystem.PlayerJoinEventListener listener) {
        this.joinListeners.remove(listener);
    }

    @Override
    public void unregisterLeaveListener(IEventSystem.PlayerLeaveEventListener listener) {
        this.leaveListeners.remove(listener);
    }

    public DispatchResult dispatchChatRaw(ServerPlayer player, String raw) {
        if (this.chatListeners.isEmpty()) {
            return new DispatchResult(raw, false);
        }
        RawChatEvent evt = new RawChatEvent(player, raw);
        for (IEventSystem.ChatEventListener l : this.chatListeners) {
            try {
                l.onPlayerChat(evt);
            }
            catch (Exception e) {
                System.err.println("Error in chat event listener: " + e.getMessage());
            }
        }
        return new DispatchResult(evt.msg, evt.cancelled);
    }

    public List<IEventSystem.ChatEventListener> getChatListenersInternal() {
        return this.chatListeners;
    }

    public void dispatchJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.joinListeners.isEmpty()) {
            return;
        }
        MinecraftPlayerJoinEvent joinEvent = new MinecraftPlayerJoinEvent(event);
        for (IEventSystem.PlayerJoinEventListener listener : this.joinListeners) {
            try {
                listener.onPlayerJoin(joinEvent);
            }
            catch (Exception e) {
                System.err.println("Error in player join event listener: " + e.getMessage());
            }
        }
    }

    public void dispatchLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (this.leaveListeners.isEmpty()) {
            return;
        }
        MinecraftPlayerLeaveEvent leaveEvent = new MinecraftPlayerLeaveEvent(event);
        for (IEventSystem.PlayerLeaveEventListener listener : this.leaveListeners) {
            try {
                listener.onPlayerLeave(leaveEvent);
            }
            catch (Exception e) {
                System.err.println("Error in player leave event listener: " + e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.dispatchJoin(event);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.dispatchLeave(event);
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        ServerPlayer sp = event.getPlayer();
        String raw = event.getMessage().getString();
        DispatchResult result = this.dispatchChatRaw(sp, raw);
        if (result.cancelled || !raw.equals(result.message)) {
            event.setCanceled(true);
        }
    }

    public static final class DispatchResult {
        public final String message;
        public final boolean cancelled;

        public DispatchResult(String message, boolean cancelled) {
            this.message = message;
            this.cancelled = cancelled;
        }
    }

    private static class RawChatEvent
    implements IEventSystem.ChatEvent {
        private final IPlayer player;
        private String msg;
        private boolean cancelled;

        RawChatEvent(ServerPlayer sp, String raw) {
            this.player = MinecraftPlayer.of(sp);
            this.msg = raw;
        }

        @Override
        public IPlayer getPlayer() {
            return this.player;
        }

        @Override
        public String getMessage() {
            return this.msg;
        }

        @Override
        public void setMessage(String message) {
            if (message != null) {
                this.msg = message;
            }
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }

    private static class MinecraftPlayerJoinEvent
    implements IEventSystem.PlayerJoinEvent {
        private final IPlayer player;

        public MinecraftPlayerJoinEvent(PlayerEvent.PlayerLoggedInEvent neoforgeEvent) {
            this.player = MinecraftPlayer.of((ServerPlayer)neoforgeEvent.getEntity());
        }

        @Override
        public IPlayer getPlayer() {
            return this.player;
        }

        @Override
        public IComponent getJoinMessage() {
            return null;
        }

        @Override
        public void setJoinMessage(IComponent message) {
        }
    }

    private static class MinecraftPlayerLeaveEvent
    implements IEventSystem.PlayerLeaveEvent {
        private final IPlayer player;

        public MinecraftPlayerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent neoforgeEvent) {
            this.player = MinecraftPlayer.of((ServerPlayer)neoforgeEvent.getEntity());
        }

        @Override
        public IPlayer getPlayer() {
            return this.player;
        }

        @Override
        public IComponent getLeaveMessage() {
            return null;
        }

        @Override
        public void setLeaveMessage(IComponent message) {
        }
    }
}

