/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.configs.CMConfig;
import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.utils.DebugLogger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;
import org.slf4j.Logger;

public class PermissionsHandler {
    private final Logger logger;
    private final CMConfig cmConfig;
    private final DebugLogger debugLogger;
    public static final String MENTION_EVERYONE_PERMISSION = "paradigm.mention.everyone";
    public static final String MENTION_PLAYER_PERMISSION = "paradigm.mention.player";
    public static final String STAFF_CHAT_PERMISSION = "paradigm.staff";
    public static final String RESTART_MANAGE_PERMISSION = "paradigm.restart.manage";
    public static final String BROADCAST_PERMISSION = "paradigm.broadcast";
    public static final String ACTIONBAR_PERMISSION = "paradigm.actionbar";
    public static final String TITLE_PERMISSION = "paradigm.title";
    public static final String BOSSBAR_PERMISSION = "paradigm.bossbar";
    public static final String RELOAD_PERMISSION = "paradigm.reload";
    public static final String GROUPCHAT_PERMISSION = "paradigm.groupchat";
    public static final int MENTION_EVERYONE_PERMISSION_LEVEL = 2;
    public static final int MENTION_PLAYER_PERMISSION_LEVEL = 0;
    public static final int STAFF_CHAT_PERMISSION_LEVEL = 2;
    public static final int RESTART_MANAGE_PERMISSION_LEVEL = 2;
    public static final int BROADCAST_PERMISSION_LEVEL = 2;
    public static final int ACTIONBAR_PERMISSION_LEVEL = 2;
    public static final int TITLE_PERMISSION_LEVEL = 2;
    public static final int BOSSBAR_PERMISSION_LEVEL = 2;
    public static final int RELOAD_PERMISSION_LEVEL = 2;
    private PermissionChecker checker;

    public PermissionsHandler(Logger logger, CMConfig cmConfig, DebugLogger debugLogger) {
        this.logger = logger;
        this.cmConfig = cmConfig;
        this.debugLogger = debugLogger;
    }

    public void initialize() {
        this.initializeChecker();
        this.registerLuckPermsPermissions();
    }

    public void refreshCustomCommandPermissions() {
        this.registerLuckPermsPermissions();
    }

    public Map<String, String> knownPermissionNodes() {
        LinkedHashMap<String, String> nodes = new LinkedHashMap<String, String>();
        nodes.put(STAFF_CHAT_PERMISSION, "Access to /sc (Staff Chat) and receiving staff messages.");
        nodes.put(MENTION_EVERYONE_PERMISSION, "Allows using @everyone to ping all players in Mentions module.");
        nodes.put(MENTION_PLAYER_PERMISSION, "Allows mentioning individual players in Mentions module.");
        nodes.put(RESTART_MANAGE_PERMISSION, "Allows managing restarts: /restart now, /restart cancel.");
        nodes.put(BROADCAST_PERMISSION, "Allows using /paradigm broadcast, actionbar, title, and bossbar commands.");
        nodes.put(ACTIONBAR_PERMISSION, "Allows sending actionbar messages via /paradigm actionbar.");
        nodes.put(TITLE_PERMISSION, "Allows sending titles via /paradigm title.");
        nodes.put(BOSSBAR_PERMISSION, "Allows sending bossbar messages via /paradigm bossbar.");
        nodes.put(GROUPCHAT_PERMISSION, "Allows using /groupchat commands (create, invite, join, etc.).");
        nodes.put(RELOAD_PERMISSION, "Allows using /paradigm reload and /customcommandsreload commands.");
        if (this.cmConfig != null && this.cmConfig.getLoadedCommands() != null) {
            for (CustomCommand cmd : this.cmConfig.getLoadedCommands()) {
                if (!cmd.isRequirePermission() || cmd.getPermission() == null || cmd.getPermission().trim().isEmpty()) continue;
                String desc = cmd.getDescription() != null && !cmd.getDescription().trim().isEmpty() ? cmd.getDescription() : "Custom command: /" + cmd.getName();
                nodes.put(cmd.getPermission(), desc);
            }
        }
        return nodes;
    }

    private void registerLuckPermsPermissions() {
        if (!ModList.get().isLoaded("luckperms")) {
            return;
        }
        this.registerPermissionsWithLuckPermsRetry(0);
    }

    private void registerPermissionsWithLuckPermsRetry(int attemptCount) {
        if (attemptCount >= 5) {
            this.logger.warn("Paradigm: Failed to register permissions with LuckPerms after {} attempts.", (Object)attemptCount);
            return;
        }
        try {
            LuckPerms api = LuckPermsProvider.get();
            Map<String, String> all = this.knownPermissionNodes();
            UUID dummyUuid = UUID.fromString("00000000-0000-0000-0000-000000000000");
            User dummyUser = (User)api.getUserManager().loadUser(dummyUuid).join();
            if (dummyUser != null) {
                for (String node : all.keySet()) {
                    dummyUser.getCachedData().getPermissionData().checkPermission(node);
                    this.debugLogger.debugLog("Registered permission with LuckPerms: " + node);
                }
                this.logger.info("Paradigm: Made {} permissions visible to LuckPerms.", (Object)all.size());
            }
        }
        catch (IllegalStateException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("API isn't loaded")) {
                this.debugLogger.debugLog("LuckPerms not ready yet, retrying in " + (attemptCount + 1) + " seconds... (attempt " + (attemptCount + 1) + "/5)");
                this.scheduleRetry(attemptCount);
            } else {
                this.logger.warn("Paradigm: Failed to register permissions with LuckPerms: {}", (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            this.logger.warn("Paradigm: Failed to register permissions with LuckPerms: {}", (Object)e.getMessage());
        }
    }

    private void scheduleRetry(int attemptCount) {
        new Thread(() -> {
            try {
                Thread.sleep((long)(attemptCount + 1) * 1000L);
                this.registerPermissionsWithLuckPermsRetry(attemptCount + 1);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }, "Paradigm-LPReg-Retry").start();
    }

    private void initializeChecker() {
        if (this.checker == null) {
            if (ModList.get().isLoaded("luckperms")) {
                this.checker = new LuckPermsCheckerImpl();
                this.logger.info("Paradigm: Using LuckPerms for permission checks.");
            } else {
                this.checker = new VanillaPermissionCheckerImpl();
                this.logger.info("Paradigm: LuckPerms not found. Using vanilla operator permissions for checks.");
            }
        }
    }

    public boolean hasPermission(ServerPlayer player, String permission) {
        if (player == null) {
            return false;
        }
        if (this.checker == null) {
            this.logger.warn("PermissionsHandler: Checker not initialized. Attempting first-time initialization.");
            this.initialize();
        }
        return this.checker.hasPermission(player, permission);
    }

    public boolean hasReloadPermission(ServerPlayer player) {
        return this.hasPermission(player, RELOAD_PERMISSION);
    }

    public static interface PermissionChecker {
        public boolean hasPermission(ServerPlayer var1, String var2);
    }

    public static class LuckPermsCheckerImpl
    implements PermissionChecker {
        @Override
        public boolean hasPermission(ServerPlayer player, String permission) {
            try {
                LuckPerms api = LuckPermsProvider.get();
                User user = api.getUserManager().getUser(player.getUUID());
                if (user != null) {
                    return user.getCachedData().getPermissionData().checkPermission(permission).asBoolean();
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }

    private static class VanillaPermissionCheckerImpl
    implements PermissionChecker {
        private VanillaPermissionCheckerImpl() {
        }

        @Override
        public boolean hasPermission(ServerPlayer player, String permission) {
            int requiredLevel = this.getPermissionLevelForVanilla(permission);
            return player.hasPermissions(requiredLevel);
        }

        private int getPermissionLevelForVanilla(String permission) {
            if (permission == null) {
                return 4;
            }
            return switch (permission) {
                case PermissionsHandler.STAFF_CHAT_PERMISSION -> 2;
                case PermissionsHandler.MENTION_EVERYONE_PERMISSION -> 2;
                case PermissionsHandler.MENTION_PLAYER_PERMISSION -> 0;
                case PermissionsHandler.BROADCAST_PERMISSION -> 2;
                case PermissionsHandler.ACTIONBAR_PERMISSION -> 2;
                case PermissionsHandler.TITLE_PERMISSION -> 2;
                case PermissionsHandler.BOSSBAR_PERMISSION -> 2;
                case PermissionsHandler.RESTART_MANAGE_PERMISSION -> 2;
                case PermissionsHandler.RELOAD_PERMISSION -> 2;
                case PermissionsHandler.GROUPCHAT_PERMISSION -> 0;
                default -> permission.startsWith("paradigm.") ? 0 : 4;
            };
        }
    }
}

