/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.webeditor.socket;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public enum SocketMessageType {
    HELLO("hello"),
    HELLO_REPLY("hello-reply"),
    CONNECTED("connected"),
    CHANGE_REQUEST("change-request"),
    CHANGE_RESPONSE("change-response"),
    PING("ping"),
    PONG("pong");

    public final String id;
    private static final Map<String, SocketMessageType> LOOKUP;

    private SocketMessageType(String id) {
        this.id = id;
    }

    public JsonBuilder builder() {
        JsonBuilder b = new JsonBuilder();
        b.add("type", this.id);
        return b;
    }

    public static SocketMessageType getById(String id) {
        SocketMessageType type = LOOKUP.get(id);
        if (type == null) {
            throw new IllegalArgumentException(id);
        }
        return type;
    }

    static {
        LOOKUP = new HashMap<String, SocketMessageType>();
        for (SocketMessageType t : SocketMessageType.values()) {
            LOOKUP.put(t.id, t);
        }
    }

    public static final class JsonBuilder {
        private final JsonObject obj = new JsonObject();

        public JsonBuilder add(String key, String value) {
            this.obj.addProperty(key, value);
            return this;
        }

        public JsonBuilder add(String key, boolean value) {
            this.obj.addProperty(key, Boolean.valueOf(value));
            return this;
        }

        public JsonObject toJson() {
            return this.obj;
        }
    }
}

