/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm;

import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.configs.CMConfig;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.configs.MOTDConfigHandler;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.modules.Announcements;
import eu.avalanche7.paradigm.modules.CommandManager;
import eu.avalanche7.paradigm.modules.GroupChat;
import eu.avalanche7.paradigm.modules.MOTD;
import eu.avalanche7.paradigm.modules.Mentions;
import eu.avalanche7.paradigm.modules.Restart;
import eu.avalanche7.paradigm.modules.StaffChat;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.GroupChatManager;
import eu.avalanche7.paradigm.utils.Lang;
import eu.avalanche7.paradigm.utils.MessageParser;
import eu.avalanche7.paradigm.utils.PermissionsHandler;
import eu.avalanche7.paradigm.utils.Placeholders;
import eu.avalanche7.paradigm.utils.TaskScheduler;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="paradigm", name="Paradigm", version="12.0.6", acceptableRemoteVersions="*")
public class Paradigm {
    public static final String MOD_ID = "paradigm";
    public static final String NAME = "Paradigm";
    public static final String VERSION = "12.0.6";
    private static final Logger LOGGER = LogManager.getLogger((String)"paradigm");
    private final List<ParadigmModule> modules = new ArrayList<ParadigmModule>();
    private Services services;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("Initializing Paradigm Mod for Minecraft 1.12.2...");
        File configDir = new File(event.getSuggestedConfigurationFile().getParentFile(), MOD_ID);
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        MainConfigHandler.init(configDir);
        AnnouncementsConfigHandler.init(configDir);
        MOTDConfigHandler.init(configDir);
        MentionConfigHandler.init(configDir);
        RestartConfigHandler.init(configDir);
        ChatConfigHandler.init(configDir);
        this.createServices(configDir);
        this.registerModules();
        this.modules.forEach(module -> {
            module.onLoad(event, this.services);
            module.registerEventListeners(this.services);
        });
    }

    private void createServices(File configDir) {
        DebugLogger debugLoggerInstance = new DebugLogger(LOGGER, MainConfigHandler.CONFIG);
        Placeholders placeholdersInstance = new Placeholders();
        MessageParser messageParserInstance = new MessageParser(placeholdersInstance);
        CMConfig cmConfigInstance = new CMConfig(debugLoggerInstance);
        cmConfigInstance.init(configDir);
        Lang langInstance = new Lang(LOGGER, MainConfigHandler.CONFIG, messageParserInstance);
        langInstance.init(configDir);
        langInstance.initializeLanguage();
        TaskScheduler taskSchedulerInstance = new TaskScheduler(debugLoggerInstance);
        PermissionsHandler permissionsHandlerInstance = new PermissionsHandler(LOGGER, cmConfigInstance, debugLoggerInstance);
        GroupChatManager groupChatManagerInstance = new GroupChatManager();
        this.services = new Services(LOGGER, MainConfigHandler.CONFIG, AnnouncementsConfigHandler.CONFIG, MOTDConfigHandler.getConfig(), MentionConfigHandler.CONFIG, RestartConfigHandler.CONFIG, ChatConfigHandler.CONFIG, cmConfigInstance, groupChatManagerInstance, debugLoggerInstance, langInstance, messageParserInstance, permissionsHandlerInstance, placeholdersInstance, taskSchedulerInstance);
        groupChatManagerInstance.setServices(this.services);
        permissionsHandlerInstance.initialize();
    }

    private void registerModules() {
        this.modules.add(new Announcements());
        this.modules.add(new MOTD());
        this.modules.add(new Mentions());
        this.modules.add(new Restart());
        this.modules.add(new StaffChat());
        this.modules.add(new GroupChat(new GroupChatManager()));
        this.modules.add(new CommandManager());
        LOGGER.info("Paradigm: Registered {} modules.", (Object)this.modules.size());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.services.setServer(event.getServer());
        this.services.getTaskScheduler().initialize(event.getServer());
        LOGGER.info("==================================================");
        LOGGER.info("{} - Version {}", (Object)NAME, (Object)VERSION);
        LOGGER.info("Author: Avalanche7CZ");
        LOGGER.info("Discord: https://discord.com/invite/qZDcQdEFqQ");
        LOGGER.info("==================================================");
        UpdateChecker.checkForUpdates();
        this.modules.forEach(module -> {
            if (module.isEnabled(this.services)) {
                LOGGER.info("Paradigm: Enabling module: {}", (Object)module.getName());
                module.onServerStarting(event, this.services);
                module.onEnable(this.services);
                if (module.getCommand() != null) {
                    event.registerServerCommand(module.getCommand());
                }
            } else {
                LOGGER.info("Paradigm: Module disabled by config: {}", (Object)module.getName());
            }
        });
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.modules.forEach(module -> {
            if (module.isEnabled(this.services)) {
                module.onServerStopping(event, this.services);
                module.onDisable(this.services);
            }
        });
        if (this.services.getTaskScheduler() != null) {
            this.services.getTaskScheduler().onServerStopping();
        }
        LOGGER.info("Paradigm modules have been processed for server stop.");
    }

    public static class UpdateChecker {
        private static final String LATEST_VERSION_URL = "https://raw.githubusercontent.com/Avalanche7CZ/Paradigm/1.12.2/version.txt?v=1";

        public static void checkForUpdates() {
            new Thread(() -> {
                try {
                    URL url = new URL(LATEST_VERSION_URL);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                    String latestVersion = reader.readLine();
                    reader.close();
                    if (latestVersion != null && !Paradigm.VERSION.equals(latestVersion.trim())) {
                        LOGGER.info("A new version of Paradigm is available: " + latestVersion.trim());
                        LOGGER.info("Please update at: https://www.curseforge.com/minecraft/mc-mods/paradigm or https://modrinth.com/mod/paradigm");
                    } else if (latestVersion != null) {
                        LOGGER.info("Paradigm is up to date: 12.0.6");
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Paradigm: Failed to check for updates: " + e.getMessage());
                }
            }).start();
        }
    }
}

