/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;

public class AnnouncementsConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path configPath;
    public static Config CONFIG;

    public static void init(File configDir) {
        configPath = configDir.toPath().resolve("announcements.json");
        AnnouncementsConfigHandler.load();
    }

    public static void load() {
        if (Files.exists(configPath, new LinkOption[0])) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                Config loadedConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (loadedConfig != null) {
                    CONFIG = loadedConfig;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read Announcements config for 1.12.2", e);
            }
        }
        AnnouncementsConfigHandler.save();
    }

    public static void save() {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Announcements config for 1.12.2", e);
        }
    }

    static {
        CONFIG = new Config();
    }

    public static class Config {
        public ConfigEntry<String> orderMode = new ConfigEntry<String>("RANDOM", "Order mode for messages (RANDOM or SEQUENTIAL)");
        public ConfigEntry<Boolean> globalEnable = new ConfigEntry<Boolean>(true, "Enable global messages");
        public ConfigEntry<Boolean> headerAndFooter = new ConfigEntry<Boolean>(true, "Enable header and footer");
        public ConfigEntry<Integer> globalInterval = new ConfigEntry<Integer>(1800, "Interval in seconds for global messages");
        public ConfigEntry<String> prefix = new ConfigEntry<String>("\u00a79\u00a7l[\u00a7b\u00a7lPREFIX\u00a79\u00a7l]", "Prefix for messages");
        public ConfigEntry<String> header = new ConfigEntry<String>("\u00a77*\u00a77\u00a7m---------------------------------------------------\u00a77*", "Header for messages");
        public ConfigEntry<String> footer = new ConfigEntry<String>("\u00a77*\u00a77\u00a7m---------------------------------------------------\u00a77*", "Footer for messages");
        public ConfigEntry<String> sound = new ConfigEntry<String>("", "Sound to play");
        public ConfigEntry<List<String>> globalMessages = new ConfigEntry<List<String>>(Arrays.asList("{Prefix} \u00a77This is global message with link: https://link/."), "Global messages to broadcast");
        public ConfigEntry<Boolean> actionbarEnable = new ConfigEntry<Boolean>(true, "Enable actionbar messages");
        public ConfigEntry<Integer> actionbarInterval = new ConfigEntry<Integer>(1800, "Interval in seconds for actionbar messages");
        public ConfigEntry<List<String>> actionbarMessages = new ConfigEntry<List<String>>(Arrays.asList("{Prefix} \u00a77This is an actionbar message."), "Actionbar messages to broadcast");
        public ConfigEntry<Boolean> titleEnable = new ConfigEntry<Boolean>(true, "Enable title messages");
        public ConfigEntry<Integer> titleInterval = new ConfigEntry<Integer>(1800, "Interval in seconds for title messages");
        public ConfigEntry<List<String>> titleMessages = new ConfigEntry<List<String>>(Arrays.asList("{Prefix} \u00a77This is a title message."), "Title messages to broadcast");
        public ConfigEntry<Boolean> bossbarEnable = new ConfigEntry<Boolean>(true, "Enable bossbar messages");
        public ConfigEntry<Integer> bossbarInterval = new ConfigEntry<Integer>(1800, "Interval in seconds for bossbar messages");
        public ConfigEntry<String> bossbarColor = new ConfigEntry<String>("PURPLE", "Color of the bossbar");
        public ConfigEntry<Integer> bossbarTime = new ConfigEntry<Integer>(10, "How long the bossbar stays on for (seconds)");
        public ConfigEntry<List<String>> bossbarMessages = new ConfigEntry<List<String>>(Arrays.asList("{Prefix} \u00a77This is a bossbar message."), "Bossbar messages to broadcast");
    }
}

