/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.utils.DebugLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CMConfig {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private File configFolder;
    private List<CustomCommand> loadedCommands = new ArrayList<CustomCommand>();
    private final DebugLogger debugLogger;

    public CMConfig(DebugLogger debugLogger) {
        this.debugLogger = debugLogger;
    }

    public void init(File modConfigDir) {
        this.configFolder = new File(modConfigDir, "commands");
    }

    public void loadCommands() {
        File[] commandFiles;
        this.loadedCommands.clear();
        if (!this.configFolder.exists()) {
            this.configFolder.mkdirs();
        }
        if ((commandFiles = this.configFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".json"))) == null || commandFiles.length == 0) {
            this.debugLogger.debugLog("CMConfig: No command files found. Generating example commands.");
            this.generateDefaultConfigs();
            commandFiles = this.configFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".json"));
        }
        if (commandFiles != null) {
            for (File file : commandFiles) {
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                    CustomCommand command = (CustomCommand)this.gson.fromJson((Reader)reader, CustomCommand.class);
                    if (command != null && command.getName() != null && !command.getName().trim().isEmpty()) {
                        this.loadedCommands.add(command);
                        this.debugLogger.debugLog("CMConfig: Loaded command '" + command.getName() + "' from file: " + file.getName());
                        continue;
                    }
                    this.debugLogger.debugLog("CMConfig: Skipped a null or invalid command entry in file: " + file.getName());
                }
                catch (JsonSyntaxException | IOException e) {
                    this.debugLogger.debugLog("CMConfig: Failed to load or parse command from file: " + file.getName(), (Exception)e);
                }
            }
        }
    }

    private void generateDefaultConfigs() {
        this.saveCommandToFile(this.createExampleMessage(), "example_message.json");
        this.saveCommandToFile(this.createExampleTeleport(), "example_teleport.json");
        this.saveCommandToFile(this.createExampleAdmin(), "example_admin_gift.json");
    }

    private void saveCommandToFile(CustomCommand command, String fileName) {
        if (!this.configFolder.exists()) {
            this.configFolder.mkdirs();
        }
        File file = new File(this.configFolder, fileName);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            this.gson.toJson((Object)command, (Appendable)writer);
        }
        catch (IOException e) {
            this.debugLogger.debugLog("CMConfig: Failed to save example command to " + fileName, e);
        }
    }

    private CustomCommand createExampleMessage() {
        CustomCommand cmd = new CustomCommand();
        cmd.setName("example");
        cmd.setDescription("An example custom command.");
        cmd.setRequirePermission(false);
        CustomCommand.Action action = new CustomCommand.Action();
        action.setType("message");
        action.setText(Arrays.asList("&aHello &6{player}! &bWelcome to the server!", "&aEnjoy your stay."));
        cmd.setActions(Collections.singletonList(action));
        return cmd;
    }

    private CustomCommand createExampleTeleport() {
        CustomCommand cmd = new CustomCommand();
        cmd.setName("spawn");
        cmd.setDescription("Teleports the player to spawn.");
        cmd.setRequirePermission(false);
        ArrayList<CustomCommand.Action> actions = new ArrayList<CustomCommand.Action>();
        CustomCommand.Action tpAction = new CustomCommand.Action();
        tpAction.setType("teleport");
        tpAction.setX(0.5);
        tpAction.setY(65.0);
        tpAction.setZ(0.5);
        actions.add(tpAction);
        CustomCommand.Action msgAction = new CustomCommand.Action();
        msgAction.setType("message");
        msgAction.setText(Collections.singletonList("&aYou have been teleported to spawn!"));
        actions.add(msgAction);
        cmd.setActions(actions);
        return cmd;
    }

    private CustomCommand createExampleAdmin() {
        CustomCommand cmd = new CustomCommand();
        cmd.setName("admingift");
        cmd.setDescription("Runs multiple commands as the console.");
        cmd.setRequirePermission(true);
        cmd.setPermission("paradigm.command.admingift");
        cmd.setPermissionErrorMessage("&cYou do not have permission to use this command.");
        CustomCommand.Action runCmdAction = new CustomCommand.Action();
        runCmdAction.setType("run_console");
        runCmdAction.setCommands(Arrays.asList("say {player} used the admin gift command!", "give {player} minecraft:diamond 1"));
        cmd.setActions(Collections.singletonList(runCmdAction));
        return cmd;
    }

    public List<CustomCommand> getLoadedCommands() {
        return this.loadedCommands;
    }

    public void reloadCommands() {
        this.debugLogger.debugLog("CMConfig: Reloading custom commands...");
        this.loadCommands();
        this.debugLogger.debugLog("CMConfig: Custom commands reloaded. Found " + this.loadedCommands.size() + " commands.");
    }
}

