/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ChatConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path configPath;
    public static Config CONFIG;

    public static void init(File configDir) {
        configPath = configDir.toPath().resolve("chat.json");
        ChatConfigHandler.load();
    }

    public static void load() {
        if (Files.exists(configPath, new LinkOption[0])) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                Config loadedConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (loadedConfig != null) {
                    CONFIG = loadedConfig;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read Chat config for 1.12.2", e);
            }
        }
        ChatConfigHandler.save();
    }

    public static void save() {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Chat config for 1.12.2", e);
        }
    }

    static {
        CONFIG = new Config();
    }

    public static class Config {
        public ConfigEntry<Boolean> enableStaffChat = new ConfigEntry<Boolean>(true, "Enable staff chat feature");
        public ConfigEntry<String> staffChatFormat = new ConfigEntry<String>("\u00a7f[\u00a7cStaff Chat\u00a7f] \u00a7d%s \u00a77> \u00a7f%s", "Format for staff chat messages");
        public ConfigEntry<Boolean> enableStaffBossBar = new ConfigEntry<Boolean>(true, "Enable boss bar while staff chat is enabled");
    }
}

