/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class MainConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path configPath;
    public static Config CONFIG;

    public static void init(File configDir) {
        configPath = configDir.toPath().resolve("main.json");
        MainConfigHandler.load();
    }

    public static void load() {
        if (Files.exists(configPath, new LinkOption[0])) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                Config loadedConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (loadedConfig != null) {
                    CONFIG = loadedConfig;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read Main config for 1.12.2", e);
            }
        }
        MainConfigHandler.save();
    }

    public static void save() {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Main config for 1.12.2", e);
        }
    }

    static {
        CONFIG = new Config();
    }

    public static class Config {
        public ConfigEntry<Boolean> announcementsEnable = new ConfigEntry<Boolean>(true, "Enable or disable announcements feature");
        public ConfigEntry<Boolean> motdEnable = new ConfigEntry<Boolean>(true, "Enable or disable MOTD feature");
        public ConfigEntry<Boolean> mentionsEnable = new ConfigEntry<Boolean>(true, "Enable or disable mentions feature");
        public ConfigEntry<Boolean> restartEnable = new ConfigEntry<Boolean>(true, "Enable or disable restart feature");
        public ConfigEntry<Boolean> debugEnable = new ConfigEntry<Boolean>(false, "Enable or disable debug mode");
        public ConfigEntry<Boolean> commandManagerEnable = new ConfigEntry<Boolean>(true, "Enable or disable CommandManager feature");
        public ConfigEntry<String> defaultLanguage = new ConfigEntry<String>("en", "Set the default language");
    }
}

