/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class MentionConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path configPath;
    public static Config CONFIG;

    public static void init(File configDir) {
        configPath = configDir.toPath().resolve("mentions.json");
        MentionConfigHandler.load();
    }

    public static void load() {
        if (Files.exists(configPath, new LinkOption[0])) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                Config loadedConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (loadedConfig != null) {
                    CONFIG = loadedConfig;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read Mentions config for 1.12.2", e);
            }
        }
        MentionConfigHandler.save();
    }

    public static void save() {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Mentions config for 1.12.2", e);
        }
    }

    static {
        CONFIG = new Config();
    }

    public static class Config {
        public ConfigEntry<String> MENTION_SYMBOL = new ConfigEntry<String>("@", "Symbol to mention players");
        public ConfigEntry<String> INDIVIDUAL_MENTION_MESSAGE = new ConfigEntry<String>("\u00a74%s \u00a7cmentioned you in chat!", "Message displayed to a player when they are mentioned");
        public ConfigEntry<String> EVERYONE_MENTION_MESSAGE = new ConfigEntry<String>("\u00a74%s \u00a7cmentioned everyone in chat!", "Message displayed to everyone when @everyone is used");
        public ConfigEntry<String> INDIVIDUAL_TITLE_MESSAGE = new ConfigEntry<String>("\u00a74%s \u00a7cmentioned you!", "Title message displayed to a player when they are mentioned");
        public ConfigEntry<String> EVERYONE_TITLE_MESSAGE = new ConfigEntry<String>("\u00a74%s \u00a7cmentioned everyone!", "Title message displayed to everyone when @everyone is used");
        public ConfigEntry<Integer> INDIVIDUAL_MENTION_RATE_LIMIT = new ConfigEntry<Integer>(60, "Rate limit for individual mentions in seconds");
        public ConfigEntry<Integer> EVERYONE_MENTION_RATE_LIMIT = new ConfigEntry<Integer>(300, "Rate limit for everyone mentions in seconds");
    }
}

