/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;

public class RestartConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path configPath;
    public static Config CONFIG;

    public static void init(File configDir) {
        configPath = configDir.toPath().resolve("restarts.json");
        RestartConfigHandler.load();
    }

    public static void load() {
        if (Files.exists(configPath, new LinkOption[0])) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                Config loadedConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (loadedConfig != null) {
                    CONFIG = loadedConfig;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read Restart config for 1.12.2", e);
            }
        }
        RestartConfigHandler.save();
    }

    public static void save() {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configPath.toFile()), StandardCharsets.UTF_8);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Restart config for 1.12.2", e);
        }
    }

    static {
        CONFIG = new Config();
    }

    public static class Config {
        public ConfigEntry<String> restartType = new ConfigEntry<String>("Realtime", "Type of automatic restart (Fixed, Realtime, None).");
        public ConfigEntry<Double> restartInterval = new ConfigEntry<Double>(6.0, "Interval for fixed restarts in hours.");
        public ConfigEntry<List<String>> realTimeInterval = new ConfigEntry<List<String>>(Arrays.asList("00:00", "06:00", "12:00", "18:00"), "Times for real-time restarts (24-hour format).");
        public ConfigEntry<Boolean> bossbarEnabled = new ConfigEntry<Boolean>(false, "Enable boss bar for restart countdown.");
        public ConfigEntry<String> bossBarMessage = new ConfigEntry<String>("The server will be restarting in {minutes}:{seconds}", "Message to display in boss bar on restart warnings.");
        public ConfigEntry<Boolean> timerUseChat = new ConfigEntry<Boolean>(true, "Broadcast restart warnings in chat.");
        public ConfigEntry<String> broadcastMessage = new ConfigEntry<String>("The server will be restarting in {minutes}:{seconds}", "Custom broadcast message for restart warnings.");
        public ConfigEntry<List<Integer>> timerBroadcast = new ConfigEntry<List<Integer>>(Arrays.asList(600, 300, 240, 180, 120, 60, 30, 5, 4, 3, 2, 1), "Warning times in seconds before reboot.");
        public ConfigEntry<String> defaultRestartReason = new ConfigEntry<String>("", "Default reason shown for a restart.");
        public ConfigEntry<Boolean> playSoundEnabled = new ConfigEntry<Boolean>(true, "Enable notification sound on restart warnings.");
        public ConfigEntry<String> playSoundString = new ConfigEntry<String>("block.note.pling", "Sound to play on restart warnings. Use sound event IDs from Minecraft 1.12.2.");
        public ConfigEntry<Double> playSoundFirstTime = new ConfigEntry<Double>(600.0, "When to start playing notification sound (same as one of broadcast timers).");
        public ConfigEntry<Boolean> titleEnabled = new ConfigEntry<Boolean>(true, "Enable title message on restart warnings.");
        public ConfigEntry<Integer> titleStayTime = new ConfigEntry<Integer>(2, "Duration of title message display (in seconds).");
        public ConfigEntry<String> titleMessage = new ConfigEntry<String>("The server will be restarting in {minutes}:{seconds}", "Message to display in title on restart warnings.");
    }
}

