/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;

public class Announcements
implements ParadigmModule {
    private static final String NAME = "Announcements";
    private final Random random = new Random();
    private int globalMessageIndex = 0;
    private int actionbarMessageIndex = 0;
    private int titleMessageIndex = 0;
    private int bossbarMessageIndex = 0;
    private Services services;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getMainConfig().announcementsEnable.value;
    }

    @Override
    public void onLoad(FMLPreInitializationEvent event, Services services) {
        this.services = services;
        services.getDebugLogger().debugLog("Announcements module loaded.");
    }

    @Override
    public void onServerStarting(FMLServerStartingEvent event, Services services) {
        if (this.isEnabled(services)) {
            services.getDebugLogger().debugLog("Announcements module: Server starting, scheduling announcements if enabled.");
            this.scheduleConfiguredAnnouncements(services);
        }
    }

    @Override
    public void onEnable(Services services) {
        services.getDebugLogger().debugLog("Announcements module enabled.");
        if (services.getMinecraftServer() != null && this.isEnabled(services)) {
            this.scheduleConfiguredAnnouncements(services);
        }
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("Announcements module disabled. Tasks should be implicitly stopped by TaskScheduler shutdown.");
    }

    @Override
    public void onServerStopping(FMLServerStoppingEvent event, Services services) {
        services.getDebugLogger().debugLog("Announcements module: Server stopping.");
    }

    @Override
    public ICommand getCommand() {
        return new AnnouncementsCommand(this.services);
    }

    @Override
    public void registerEventListeners(Services services) {
    }

    private void scheduleConfiguredAnnouncements(Services services) {
        AnnouncementsConfigHandler.Config config = services.getAnnouncementsConfig();
        MinecraftServer server = services.getMinecraftServer();
        if (server == null) {
            services.getDebugLogger().debugLog("Announcements: Cannot schedule announcements, server instance is null.");
            return;
        }
        if (((Boolean)config.globalEnable.value).booleanValue()) {
            long globalInterval = ((Integer)config.globalInterval.value).intValue();
            services.getTaskScheduler().scheduleAtFixedRate(() -> this.broadcastGlobalMessages(services), globalInterval, globalInterval, TimeUnit.SECONDS);
            services.getDebugLogger().debugLog("Announcements: Scheduled global messages with interval: " + globalInterval + " seconds");
        }
        if (((Boolean)config.actionbarEnable.value).booleanValue()) {
            long actionbarInterval = ((Integer)config.actionbarInterval.value).intValue();
            services.getTaskScheduler().scheduleAtFixedRate(() -> this.broadcastActionbarMessages(services), actionbarInterval, actionbarInterval, TimeUnit.SECONDS);
            services.getDebugLogger().debugLog("Announcements: Scheduled actionbar messages with interval: " + actionbarInterval + " seconds");
        }
        if (((Boolean)config.titleEnable.value).booleanValue()) {
            long titleInterval = ((Integer)config.titleInterval.value).intValue();
            services.getTaskScheduler().scheduleAtFixedRate(() -> this.broadcastTitleMessages(services), titleInterval, titleInterval, TimeUnit.SECONDS);
            services.getDebugLogger().debugLog("Announcements: Scheduled title messages with interval: " + titleInterval + " seconds");
        }
        if (((Boolean)config.bossbarEnable.value).booleanValue()) {
            long bossbarInterval = ((Integer)config.bossbarInterval.value).intValue();
            services.getTaskScheduler().scheduleAtFixedRate(() -> this.broadcastBossbarMessages(services), bossbarInterval, bossbarInterval, TimeUnit.SECONDS);
            services.getDebugLogger().debugLog("Announcements: Scheduled bossbar messages with interval: " + bossbarInterval + " seconds");
        }
    }

    private void broadcastGlobalMessages(Services services) {
        String messageText;
        MinecraftServer server = services.getMinecraftServer();
        AnnouncementsConfigHandler.Config config = services.getAnnouncementsConfig();
        if (server == null || ((List)config.globalMessages.value).isEmpty()) {
            return;
        }
        List messages = (List)config.globalMessages.value;
        String prefix = (String)config.prefix.value + "\u00a7r";
        String header = (String)config.header.value;
        String footer = (String)config.footer.value;
        if ("SEQUENTIAL".equalsIgnoreCase((String)config.orderMode.value)) {
            messageText = ((String)messages.get(this.globalMessageIndex)).replace("{Prefix}", prefix);
            this.globalMessageIndex = (this.globalMessageIndex + 1) % messages.size();
        } else {
            messageText = ((String)messages.get(this.random.nextInt(messages.size()))).replace("{Prefix}", prefix);
        }
        ITextComponent message = services.getMessageParser().parseMessage(messageText, null);
        if (((Boolean)config.headerAndFooter.value).booleanValue()) {
            ITextComponent headerComp = services.getMessageParser().parseMessage(header, null);
            ITextComponent footerComp = services.getMessageParser().parseMessage(footer, null);
            server.func_184103_al().func_181057_v().forEach(player -> {
                player.func_145747_a(headerComp);
                player.func_145747_a(message);
                player.func_145747_a(footerComp);
            });
        } else {
            server.func_184103_al().func_148539_a(message);
        }
        services.getDebugLogger().debugLog("Announcements: Broadcasted global message: " + message.func_150260_c());
    }

    private void broadcastActionbarMessages(Services services) {
        String messageText;
        MinecraftServer server = services.getMinecraftServer();
        AnnouncementsConfigHandler.Config config = services.getAnnouncementsConfig();
        if (server == null || ((List)config.actionbarMessages.value).isEmpty()) {
            return;
        }
        List messages = (List)config.actionbarMessages.value;
        String prefix = (String)config.prefix.value + "\u00a7r";
        if ("SEQUENTIAL".equalsIgnoreCase((String)config.orderMode.value)) {
            messageText = ((String)messages.get(this.actionbarMessageIndex)).replace("{Prefix}", prefix);
            this.actionbarMessageIndex = (this.actionbarMessageIndex + 1) % messages.size();
        } else {
            messageText = ((String)messages.get(this.random.nextInt(messages.size()))).replace("{Prefix}", prefix);
        }
        ITextComponent message = services.getMessageParser().parseMessage(messageText, null);
        SPacketTitle packet = new SPacketTitle(SPacketTitle.Type.ACTIONBAR, message);
        server.func_184103_al().func_148540_a((Packet)packet);
        services.getDebugLogger().debugLog("Announcements: Broadcasted actionbar message: " + message.func_150260_c());
    }

    private void broadcastTitleMessages(Services services) {
        String messageText;
        MinecraftServer server = services.getMinecraftServer();
        AnnouncementsConfigHandler.Config config = services.getAnnouncementsConfig();
        if (server == null || ((List)config.titleMessages.value).isEmpty()) {
            return;
        }
        List messages = (List)config.titleMessages.value;
        String prefix = (String)config.prefix.value + "\u00a7r";
        if ("SEQUENTIAL".equalsIgnoreCase((String)config.orderMode.value)) {
            messageText = ((String)messages.get(this.titleMessageIndex)).replace("{Prefix}", prefix);
            this.titleMessageIndex = (this.titleMessageIndex + 1) % messages.size();
        } else {
            messageText = ((String)messages.get(this.random.nextInt(messages.size()))).replace("{Prefix}", prefix);
        }
        String[] parts = messageText.split(" \\|\\| ", 2);
        ITextComponent titleComponent = services.getMessageParser().parseMessage(parts[0], null);
        TextComponentString subtitleComponent = parts.length > 1 ? services.getMessageParser().parseMessage(parts[1], null) : new TextComponentString("");
        SPacketTitle titlePacket = new SPacketTitle(SPacketTitle.Type.TITLE, titleComponent);
        SPacketTitle subtitlePacket = new SPacketTitle(SPacketTitle.Type.SUBTITLE, (ITextComponent)subtitleComponent);
        SPacketTitle clearPacket = new SPacketTitle(SPacketTitle.Type.RESET, null);
        server.func_184103_al().func_181057_v().forEach(arg_0 -> Announcements.lambda$broadcastTitleMessages$5(clearPacket, titlePacket, parts, (ITextComponent)subtitleComponent, subtitlePacket, arg_0));
        services.getDebugLogger().debugLog("Announcements: Broadcasted title message: " + messageText);
    }

    private void broadcastBossbarMessages(Services services) {
        String messageText;
        BossInfo.Color bossbarColor;
        MinecraftServer server = services.getMinecraftServer();
        AnnouncementsConfigHandler.Config config = services.getAnnouncementsConfig();
        if (server == null || ((List)config.bossbarMessages.value).isEmpty()) {
            return;
        }
        List messages = (List)config.bossbarMessages.value;
        String prefix = (String)config.prefix.value + "\u00a7r";
        int bossbarTime = (Integer)config.bossbarTime.value;
        try {
            bossbarColor = BossInfo.Color.valueOf((String)((String)config.bossbarColor.value).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            services.getDebugLogger().debugLog("Announcements: Invalid bossbar color: " + (String)config.bossbarColor.value + ". Defaulting to PURPLE.");
            bossbarColor = BossInfo.Color.PURPLE;
        }
        if ("SEQUENTIAL".equalsIgnoreCase((String)config.orderMode.value)) {
            messageText = ((String)messages.get(this.bossbarMessageIndex)).replace("{Prefix}", prefix);
            this.bossbarMessageIndex = (this.bossbarMessageIndex + 1) % messages.size();
        } else {
            messageText = ((String)messages.get(this.random.nextInt(messages.size()))).replace("{Prefix}", prefix);
        }
        ITextComponent message = services.getMessageParser().parseMessage(messageText, null);
        BossInfoServer bossInfo = new BossInfoServer(message, bossbarColor, BossInfo.Overlay.PROGRESS);
        bossInfo.func_186735_a(1.0f);
        server.func_184103_al().func_181057_v().forEach(arg_0 -> ((BossInfoServer)bossInfo).func_186760_a(arg_0));
        services.getDebugLogger().debugLog("Announcements: Broadcasted bossbar message: " + message.func_150260_c());
        services.getTaskScheduler().schedule(() -> new ArrayList<EntityPlayerMP>(bossInfo.func_186757_c()).forEach(arg_0 -> ((BossInfoServer)bossInfo).func_186761_b(arg_0)), bossbarTime, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void lambda$broadcastTitleMessages$5(SPacketTitle clearPacket, SPacketTitle titlePacket, String[] parts, ITextComponent subtitleComponent, SPacketTitle subtitlePacket, EntityPlayerMP player) {
        player.field_71135_a.func_147359_a((Packet)clearPacket);
        player.field_71135_a.func_147359_a((Packet)titlePacket);
        if (parts.length > 1 && !subtitleComponent.func_150260_c().isEmpty()) {
            player.field_71135_a.func_147359_a((Packet)subtitlePacket);
        }
    }

    public static class AnnouncementsCommand
    extends CommandBase {
        private final Services services;

        public AnnouncementsCommand(Services services) {
            this.services = services;
        }

        public String func_71517_b() {
            return "paradigm";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/paradigm <broadcast|actionbar|title|bossbar> <message> [options]";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            String type;
            if (args.length < 2) {
                throw new CommandException("Usage: " + this.func_71518_a(sender), new Object[0]);
            }
            switch (type = args[0].toLowerCase()) {
                case "broadcast": {
                    this.handleBroadcast(server, sender, args);
                    break;
                }
                case "actionbar": {
                    this.handleActionbar(server, sender, args);
                    break;
                }
                case "title": {
                    this.handleTitle(server, sender, args);
                    break;
                }
                case "bossbar": {
                    this.handleBossbar(server, sender, args);
                    break;
                }
                default: {
                    throw new CommandException("Invalid message type: " + type, new Object[0]);
                }
            }
        }

        private void handleBroadcast(MinecraftServer server, ICommandSender sender, String[] args) {
            String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            ITextComponent broadcastMessage = this.services.getMessageParser().parseMessage(message, null);
            server.func_184103_al().func_148539_a(broadcastMessage);
            AnnouncementsCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Broadcasted global message.", (Object[])new Object[0]);
        }

        private void handleActionbar(MinecraftServer server, ICommandSender sender, String[] args) {
            String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            ITextComponent actionbarMessage = this.services.getMessageParser().parseMessage(message, null);
            SPacketTitle packet = new SPacketTitle(SPacketTitle.Type.ACTIONBAR, actionbarMessage);
            server.func_184103_al().func_148540_a((Packet)packet);
            AnnouncementsCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Broadcasted actionbar message.", (Object[])new Object[0]);
        }

        private void handleTitle(MinecraftServer server, ICommandSender sender, String[] args) {
            String combined = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            String[] parts = combined.split(" \\|\\| ", 2);
            ITextComponent title = this.services.getMessageParser().parseMessage(parts[0], null);
            TextComponentString subtitle = parts.length > 1 ? this.services.getMessageParser().parseMessage(parts[1], null) : new TextComponentString("");
            SPacketTitle titlePacket = new SPacketTitle(SPacketTitle.Type.TITLE, title);
            SPacketTitle subtitlePacket = new SPacketTitle(SPacketTitle.Type.SUBTITLE, (ITextComponent)subtitle);
            SPacketTitle clearPacket = new SPacketTitle(SPacketTitle.Type.RESET, null);
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                player.field_71135_a.func_147359_a((Packet)clearPacket);
                player.field_71135_a.func_147359_a((Packet)titlePacket);
                if (parts.length <= 1) continue;
                player.field_71135_a.func_147359_a((Packet)subtitlePacket);
            }
            AnnouncementsCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Broadcasted title.", (Object[])new Object[0]);
        }

        private void handleBossbar(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            BossInfo.Color color;
            if (args.length < 4) {
                throw new CommandException("Usage: /paradigm bossbar <interval> <color> <message>", new Object[0]);
            }
            int interval = AnnouncementsCommand.func_180528_a((String)args[1], (int)1);
            try {
                color = BossInfo.Color.valueOf((String)args[2].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new CommandException("Invalid bossbar color: " + args[2], new Object[0]);
            }
            String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length));
            ITextComponent bossbarMessage = this.services.getMessageParser().parseMessage(message, null);
            BossInfoServer bossInfo = new BossInfoServer(bossbarMessage, color, BossInfo.Overlay.PROGRESS);
            server.func_184103_al().func_181057_v().forEach(arg_0 -> ((BossInfoServer)bossInfo).func_186760_a(arg_0));
            this.services.getTaskScheduler().schedule(() -> new ArrayList<EntityPlayerMP>(bossInfo.func_186757_c()).forEach(arg_0 -> ((BossInfoServer)bossInfo).func_186761_b(arg_0)), interval, TimeUnit.SECONDS);
            AnnouncementsCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("Broadcasted bossbar message for " + interval + " seconds."), (Object[])new Object[0]);
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            if (args.length == 1) {
                return AnnouncementsCommand.func_71530_a((String[])args, (String[])new String[]{"broadcast", "actionbar", "title", "bossbar"});
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("bossbar")) {
                return AnnouncementsCommand.func_71530_a((String[])args, (String[])new String[]{"PINK", "BLUE", "RED", "GREEN", "YELLOW", "PURPLE", "WHITE"});
            }
            return Collections.emptyList();
        }
    }
}

