/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.data.CustomCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;

public class CommandManager
implements ParadigmModule {
    private static final String NAME = "CustomCommands";
    private final List<ICommand> commandsToRegister = new ArrayList<ICommand>();
    private Services services;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getMainConfig().commandManagerEnable.value;
    }

    @Override
    public void onLoad(FMLPreInitializationEvent event, Services services) {
        this.services = services;
        services.getDebugLogger().debugLog("CustomCommands module loaded.");
        services.getCmConfig().init(new File(event.getModConfigurationDirectory(), "paradigm"));
        services.getCmConfig().loadCommands();
        for (CustomCommand cmd : services.getCmConfig().getLoadedCommands()) {
            this.commandsToRegister.add((ICommand)new DynamicCommand(cmd, services));
        }
        this.commandsToRegister.add((ICommand)new ReloadCommands(services));
    }

    @Override
    public void onServerStarting(FMLServerStartingEvent event, Services services) {
        services.getDebugLogger().debugLog("CustomCommands module: Server starting.");
        for (ICommand cmd : this.commandsToRegister) {
            event.registerServerCommand(cmd);
        }
        services.getDebugLogger().debugLog("Registered " + this.commandsToRegister.size() + " custom commands.");
    }

    @Override
    public void onEnable(Services services) {
        services.getDebugLogger().debugLog("CustomCommands module enabled.");
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("CustomCommands module disabled.");
    }

    @Override
    public void onServerStopping(FMLServerStoppingEvent event, Services services) {
        services.getDebugLogger().debugLog("CustomCommands module: Server stopping.");
    }

    @Override
    public ICommand getCommand() {
        return null;
    }

    @Override
    public void registerEventListeners(Services services) {
    }

    private static class ReloadCommands
    extends CommandBase {
        private final Services services;

        public ReloadCommands(Services services) {
            this.services = services;
        }

        public String func_71517_b() {
            return "paradigmcmdreload";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/paradigmcmdreload";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            this.services.getCmConfig().reloadCommands();
            sender.func_145747_a(this.services.getMessageParser().parseMessage("&aReloaded custom command actions. A server restart is required to register new commands.", null));
            this.services.getDebugLogger().debugLog("Custom commands reloaded via command.");
        }
    }

    private static class DynamicCommand
    extends CommandBase {
        private final CustomCommand customCommand;
        private final Services services;

        public DynamicCommand(CustomCommand customCommand, Services services) {
            this.customCommand = customCommand;
            this.services = services;
        }

        public String func_71517_b() {
            return this.customCommand.getName();
        }

        public String func_71518_a(ICommandSender sender) {
            return "/" + this.customCommand.getName();
        }

        public int func_82362_a() {
            return this.customCommand.isRequirePermission() ? 2 : 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            String errorMsg;
            if (!this.customCommand.isRequirePermission()) {
                return true;
            }
            if (!(sender instanceof EntityPlayerMP)) {
                return super.func_184882_a(server, sender);
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            boolean hasPerm = this.services.getPermissionsHandler().hasPermission(player, this.customCommand.getPermission());
            if (!hasPerm && (errorMsg = this.customCommand.getPermissionErrorMessage()) != null && !errorMsg.isEmpty()) {
                player.func_145747_a(this.services.getMessageParser().parseMessage(errorMsg, player));
            }
            return hasPerm || super.func_184882_a(server, sender);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.executeCustomCommand(sender, server, this.customCommand, this.services);
        }

        private void executeCustomCommand(ICommandSender sender, MinecraftServer server, CustomCommand command, Services services) {
            EntityPlayerMP player = sender instanceof EntityPlayerMP ? (EntityPlayerMP)sender : null;
            block13: for (CustomCommand.Action action : command.getActions()) {
                switch (action.getType().toLowerCase()) {
                    case "message": {
                        if (action.getText() == null) continue block13;
                        for (String line : action.getText()) {
                            ITextComponent formattedMessage = services.getMessageParser().parseMessage(line, player);
                            sender.func_145747_a(formattedMessage);
                        }
                        continue block13;
                    }
                    case "teleport": {
                        if (player != null && action.getX() != null && action.getY() != null && action.getZ() != null) {
                            player.func_70634_a(action.getX().doubleValue(), action.getY().doubleValue(), action.getZ().doubleValue());
                            break;
                        }
                        if (player == null) {
                            sender.func_145747_a(services.getMessageParser().parseMessage("&cTeleport action can only be performed by a player.", null));
                            break;
                        }
                        sender.func_145747_a(services.getMessageParser().parseMessage("&cInvalid teleport coordinates.", player));
                        break;
                    }
                    case "run_command": 
                    case "runcmd": {
                        String processedCmd;
                        if (action.getCommands() == null) continue block13;
                        for (String cmd : action.getCommands()) {
                            processedCmd = player != null ? services.getPlaceholders().replacePlaceholders(cmd, player) : cmd;
                            server.func_71187_D().func_71556_a(sender, processedCmd);
                        }
                        continue block13;
                    }
                    case "run_console": {
                        String processedCmd;
                        if (action.getCommands() == null) continue block13;
                        for (String cmd : action.getCommands()) {
                            processedCmd = player != null ? services.getPlaceholders().replacePlaceholders(cmd, player) : cmd;
                            server.func_71187_D().func_71556_a((ICommandSender)server, processedCmd);
                        }
                        continue block13;
                    }
                    default: {
                        sender.func_145747_a(services.getMessageParser().parseMessage("&cUnknown action type '" + action.getType() + "'.", player));
                    }
                }
            }
        }
    }
}

