/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.data.PlayerGroupData;
import eu.avalanche7.paradigm.utils.GroupChatManager;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GroupChat
implements ParadigmModule {
    private static final String NAME = "GroupChat";
    private GroupChatManager groupChatManager;
    private Services services;

    public GroupChat(GroupChatManager groupChatManager) {
        this.groupChatManager = groupChatManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return true;
    }

    @Override
    public void onLoad(FMLPreInitializationEvent event, Services services) {
        this.services = services;
        if (this.groupChatManager != null) {
            this.groupChatManager.setServices(services);
        }
        services.getDebugLogger().debugLog("GroupChat module loaded.");
    }

    @Override
    public void onServerStarting(FMLServerStartingEvent event, Services services) {
        services.getDebugLogger().debugLog("GroupChat module: Server starting.");
    }

    @Override
    public void onEnable(Services services) {
        services.getDebugLogger().debugLog("GroupChat module enabled.");
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("GroupChat module disabled.");
        if (this.groupChatManager != null) {
            this.groupChatManager.clearAllGroupsAndPlayerData();
        }
    }

    @Override
    public void onServerStopping(FMLServerStoppingEvent event, Services services) {
        services.getDebugLogger().debugLog("GroupChat module: Server stopping.");
        this.onDisable(services);
    }

    @Override
    public ICommand getCommand() {
        return new GroupChatCommand(this.groupChatManager, this.services);
    }

    @Override
    public void registerEventListeners(Services services) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerChat(ServerChatEvent event) {
        if (this.services == null || !this.isEnabled(this.services) || this.groupChatManager == null) {
            return;
        }
        EntityPlayerMP player = event.getPlayer();
        PlayerGroupData data = this.groupChatManager.getPlayerData(player);
        if (this.groupChatManager.isGroupChatToggled(player)) {
            String groupName = data.getCurrentGroup();
            if (groupName != null) {
                event.setCanceled(true);
                this.groupChatManager.sendMessageToGroup(player, groupName, event.getMessage());
                this.services.getLogger().info("[GroupChat] [{}] {}: {}", (Object)groupName, (Object)player.func_70005_c_(), (Object)event.getMessage());
            } else {
                player.func_145747_a(this.services.getLang().translate("group.no_group_to_send_message"));
                this.groupChatManager.setGroupChatToggled(player, false);
                player.func_145747_a(this.services.getLang().translate("group.chat_disabled"));
            }
        }
    }

    public static class GroupChatCommand
    extends CommandBase {
        private final GroupChatManager groupChatManager;
        private final Services services;

        public GroupChatCommand(GroupChatManager groupChatManager, Services services) {
            this.groupChatManager = groupChatManager;
            this.services = services;
        }

        public String func_71517_b() {
            return "groupchat";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/groupchat <subcommand>";
        }

        public int func_82362_a() {
            return 0;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            String subCommand;
            if (!(sender instanceof EntityPlayerMP)) {
                throw new CommandException("This command can only be used by players.", new Object[0]);
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
                this.displayHelp(player, this.services);
                return;
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "create": {
                    if (args.length < 2) {
                        throw new CommandException("/groupchat create <name>", new Object[0]);
                    }
                    this.groupChatManager.createGroup(player, args[1]);
                    break;
                }
                case "delete": {
                    this.groupChatManager.deleteGroup(player);
                    break;
                }
                case "invite": {
                    if (args.length < 2) {
                        throw new CommandException("/groupchat invite <player>", new Object[0]);
                    }
                    EntityPlayerMP target = GroupChatCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                    this.groupChatManager.invitePlayer(player, target);
                    break;
                }
                case "join": {
                    if (args.length < 2) {
                        throw new CommandException("/groupchat join <name>", new Object[0]);
                    }
                    this.groupChatManager.joinGroup(player, args[1]);
                    break;
                }
                case "leave": {
                    this.groupChatManager.leaveGroup(player);
                    break;
                }
                case "list": {
                    this.groupChatManager.listGroups(player);
                    break;
                }
                case "info": {
                    String groupName;
                    String string = groupName = args.length > 1 ? args[1] : this.groupChatManager.getPlayerData(player).getCurrentGroup();
                    if (groupName != null) {
                        this.groupChatManager.groupInfo(player, groupName);
                        break;
                    }
                    player.func_145747_a(this.services.getLang().translate("group.no_group_to_info"));
                    break;
                }
                case "say": {
                    if (args.length < 2) {
                        throw new CommandException("/groupchat say <message>", new Object[0]);
                    }
                    String message = GroupChatCommand.func_180529_a((String[])args, (int)1);
                    this.groupChatManager.sendMessageFromCommand(player, message);
                    break;
                }
                case "toggle": {
                    this.groupChatManager.toggleGroupChat(player);
                    break;
                }
                default: {
                    throw new CommandException("Unknown subcommand. Use /groupchat help.", new Object[0]);
                }
            }
        }

        private void displayHelp(EntityPlayerMP player, Services services) {
            String label = this.func_71517_b();
            player.func_145747_a(services.getLang().translate("group.help_title"));
            this.sendHelpMessage(player, label, "create <name>", services.getLang().translate("group.help_create").func_150260_c(), services);
            this.sendHelpMessage(player, label, "delete", services.getLang().translate("group.help_delete").func_150260_c(), services);
            this.sendHelpMessage(player, label, "invite <player>", services.getLang().translate("group.help_invite").func_150260_c(), services);
            this.sendHelpMessage(player, label, "join <group_name>", services.getLang().translate("group.help_join").func_150260_c(), services);
            this.sendHelpMessage(player, label, "leave", services.getLang().translate("group.help_leave").func_150260_c(), services);
            this.sendHelpMessage(player, label, "list", services.getLang().translate("group.help_list").func_150260_c(), services);
            this.sendHelpMessage(player, label, "info [group_name]", services.getLang().translate("group.help_info").func_150260_c(), services);
            this.sendHelpMessage(player, label, "say <message>", services.getLang().translate("group.help_say").func_150260_c(), services);
            this.sendHelpMessage(player, label, "toggle", services.getLang().translate("group.help_toggle").func_150260_c(), services);
        }

        private void sendHelpMessage(EntityPlayerMP player, String label, String command, String description, Services services) {
            ITextComponent hoverText = new TextComponentString(description).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA));
            TextComponentString message = new TextComponentString(" \u00a79> \u00a7e/" + label + " " + command);
            message.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + label + " " + command)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverText));
            player.func_145747_a((ITextComponent)message);
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            if (args.length == 1) {
                return GroupChatCommand.func_71530_a((String[])args, (String[])new String[]{"create", "delete", "invite", "join", "leave", "list", "info", "say", "toggle", "help"});
            }
            if (args.length == 2) {
                if (args[0].equalsIgnoreCase("invite")) {
                    return GroupChatCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
                if (args[0].equalsIgnoreCase("join") || args[0].equalsIgnoreCase("info")) {
                    return GroupChatCommand.func_175762_a((String[])args, this.groupChatManager.getAllGroupNames());
                }
            }
            return Collections.emptyList();
        }
    }
}

