/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class MOTD
implements ParadigmModule {
    private static final String NAME = "MOTD";
    private Services services;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getMainConfig().motdEnable.value;
    }

    @Override
    public void onLoad(FMLPreInitializationEvent event, Services services) {
        this.services = services;
        services.getDebugLogger().debugLog("MOTD module loaded.");
    }

    @Override
    public void onServerStarting(FMLServerStartingEvent event, Services services) {
        services.getDebugLogger().debugLog("MOTD module: Server starting.");
    }

    @Override
    public void onEnable(Services services) {
        services.getDebugLogger().debugLog("MOTD module enabled.");
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("MOTD module disabled.");
    }

    @Override
    public void onServerStopping(FMLServerStoppingEvent event, Services services) {
        services.getDebugLogger().debugLog("MOTD module: Server stopping.");
    }

    @Override
    public ICommand getCommand() {
        return null;
    }

    @Override
    public void registerEventListeners(Services services) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.services == null || !this.isEnabled(this.services) || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        ITextComponent motdMessage = this.createMOTDMessage(player, this.services);
        player.func_145747_a(motdMessage);
        this.services.getDebugLogger().debugLog("Sent MOTD to " + player.func_70005_c_());
    }

    private ITextComponent createMOTDMessage(EntityPlayerMP player, Services services) {
        if (services == null || services.getMotdConfig() == null) {
            if (services != null && services.getDebugLogger() != null) {
                services.getDebugLogger().debugLog("MOTDModule: Services or MOTDConfig is null in createMOTDMessage.");
            }
            return new TextComponentString("");
        }
        List lines = (List)services.getMotdConfig().motdLines.value;
        if (lines == null || lines.isEmpty()) {
            return new TextComponentString("");
        }
        TextComponentString motdMessage = new TextComponentString("");
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (services.getMessageParser() != null) {
                motdMessage.func_150257_a(services.getMessageParser().parseMessage(line, player));
            } else {
                if (services.getDebugLogger() != null) {
                    services.getDebugLogger().debugLog("MOTDModule: MessageParser is null in createMOTDMessage loop.");
                }
                motdMessage.func_150257_a((ITextComponent)new TextComponentString(line));
            }
            if (i >= lines.size() - 1) continue;
            motdMessage.func_150257_a((ITextComponent)new TextComponentString("\n"));
        }
        return motdMessage;
    }
}

