/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Mentions
implements ParadigmModule {
    private static final String NAME = "Mentions";
    private final HashMap<UUID, Long> lastIndividualMentionBySender = new HashMap();
    private final HashMap<UUID, Long> lastEveryoneMentionBySender = new HashMap();
    private Services services;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getMainConfig().mentionsEnable.value;
    }

    @Override
    public void onLoad(FMLPreInitializationEvent event, Services services) {
        this.services = services;
        services.getDebugLogger().debugLog("Mentions module loaded.");
    }

    @Override
    public void onServerStarting(FMLServerStartingEvent event, Services services) {
        services.getDebugLogger().debugLog("Mentions module: Server starting.");
    }

    @Override
    public void onEnable(Services services) {
        services.getDebugLogger().debugLog("Mentions module enabled.");
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("Mentions module disabled.");
    }

    @Override
    public void onServerStopping(FMLServerStoppingEvent event, Services services) {
        services.getDebugLogger().debugLog("Mentions module: Server stopping.");
    }

    @Override
    public ICommand getCommand() {
        return new MentionCommand(this.services);
    }

    @Override
    public void registerEventListeners(Services services) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onChatMessage(ServerChatEvent event) {
        if (this.services == null || !this.isEnabled(this.services)) {
            return;
        }
        MentionConfigHandler.Config mentionConfig = MentionConfigHandler.CONFIG;
        String rawMessage = event.getMessage();
        EntityPlayerMP sender = event.getPlayer();
        String mentionSymbol = (String)mentionConfig.MENTION_SYMBOL.value;
        String everyoneMentionPlaceholder = mentionSymbol + "everyone";
        Pattern everyonePattern = Pattern.compile(Pattern.quote(everyoneMentionPlaceholder), 2);
        Matcher everyoneMatcher = everyonePattern.matcher(rawMessage);
        if (everyoneMatcher.find()) {
            this.handleEveryoneMention(event, sender, rawMessage, mentionConfig, everyoneMatcher.group(0));
        } else {
            this.handleIndividualMentions(event, sender, rawMessage, mentionConfig);
        }
    }

    private void handleEveryoneMention(ServerChatEvent event, EntityPlayerMP sender, String rawMessage, MentionConfigHandler.Config mentionConfig, String matchedEveryoneMention) {
        if (!this.hasPermission(sender, "paradigm.mention.everyone", 2)) {
            sender.func_145747_a(this.services.getMessageParser().parseMessage("&cYou do not have permission to mention everyone.", null));
            event.setCanceled(true);
            return;
        }
        if (!this.canMentionEveryoneNow(sender, mentionConfig)) {
            sender.func_145747_a(this.services.getMessageParser().parseMessage("&cYou are mentioning everyone too frequently. Please wait.", null));
            event.setCanceled(true);
            return;
        }
        this.services.getDebugLogger().debugLog("Mention everyone detected in chat by " + sender.func_70005_c_());
        this.notifyEveryone(sender.func_184102_h().func_184103_al().func_181057_v(), sender, rawMessage, false, mentionConfig, matchedEveryoneMention);
        this.markMentionEveryoneUsed(sender);
        event.setCanceled(true);
    }

    private void handleIndividualMentions(ServerChatEvent event, EntityPlayerMP sender, String rawMessage, MentionConfigHandler.Config mentionConfig) {
        String mentionSymbol = (String)mentionConfig.MENTION_SYMBOL.value;
        List players = sender.func_184102_h().func_184103_al().func_181057_v();
        Pattern allPlayersPattern = this.buildAllPlayersMentionPattern(players, mentionSymbol);
        Matcher mentionMatcher = allPlayersPattern.matcher(rawMessage);
        if (!mentionMatcher.find()) {
            return;
        }
        mentionMatcher.reset();
        if (!this.hasPermission(sender, "paradigm.mention.player", 2)) {
            return;
        }
        if (!this.canMentionIndividualNow(sender, mentionConfig)) {
            sender.func_145747_a(this.services.getMessageParser().parseMessage("&cYou are mentioning players too frequently. Please wait.", null));
            event.setCanceled(true);
            return;
        }
        boolean mentionedSomeone = false;
        while (mentionMatcher.find()) {
            String playerName = mentionMatcher.group(1);
            EntityPlayerMP targetPlayer = sender.func_184102_h().func_184103_al().func_152612_a(playerName);
            if (targetPlayer == null) continue;
            this.services.getDebugLogger().debugLog("Mention player detected: " + targetPlayer.func_70005_c_() + " by " + sender.func_70005_c_());
            this.notifyPlayer(targetPlayer, sender, rawMessage, false, mentionConfig, mentionMatcher.group(0));
            mentionedSomeone = true;
        }
        if (mentionedSomeone) {
            this.markMentionIndividualUsed(sender);
        }
    }

    private int executeMentionCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new CommandException("Usage: /mention <message>", new Object[0]);
        }
        String message = String.join((CharSequence)" ", args);
        List players = server.func_184103_al().func_181057_v();
        boolean isConsole = !(sender instanceof EntityPlayerMP);
        EntityPlayerMP senderPlayer = isConsole ? null : (EntityPlayerMP)sender;
        MentionConfigHandler.Config mentionConfig = MentionConfigHandler.CONFIG;
        if (message.contains((String)mentionConfig.MENTION_SYMBOL.value + "everyone")) {
            if (senderPlayer != null) {
                if (!this.hasPermission(senderPlayer, "paradigm.mention.everyone", 2)) {
                    throw new CommandException("You do not have permission to mention everyone.", new Object[0]);
                }
                if (!this.canMentionEveryoneNow(senderPlayer, mentionConfig)) {
                    throw new CommandException("You are mentioning everyone too frequently.", new Object[0]);
                }
            }
            this.notifyEveryone(players, senderPlayer, message, isConsole, mentionConfig, (String)mentionConfig.MENTION_SYMBOL.value + "everyone");
            if (senderPlayer != null) {
                this.markMentionEveryoneUsed(senderPlayer);
            }
            CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this.getCommand(), (String)"Mentioned everyone successfully.", (Object[])new Object[0]);
            return 1;
        }
        boolean mentionedSomeone = false;
        for (EntityPlayerMP targetPlayer : players) {
            String mention = (String)mentionConfig.MENTION_SYMBOL.value + targetPlayer.func_70005_c_();
            if (!message.contains(mention)) continue;
            if (senderPlayer != null) {
                if (!this.hasPermission(senderPlayer, "paradigm.mention.player", 2)) continue;
                if (!this.canMentionIndividualNow(senderPlayer, mentionConfig)) {
                    throw new CommandException("You are mentioning players too frequently.", new Object[0]);
                }
            }
            this.notifyPlayer(targetPlayer, senderPlayer, message, isConsole, mentionConfig, mention);
            mentionedSomeone = true;
        }
        if (mentionedSomeone) {
            if (senderPlayer != null) {
                this.markMentionIndividualUsed(senderPlayer);
            }
        } else {
            throw new CommandException("No valid mentions found in the message.", new Object[0]);
        }
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this.getCommand(), (String)"Mentioned player(s) successfully.", (Object[])new Object[0]);
        return mentionedSomeone ? 1 : 0;
    }

    private boolean canMentionEveryoneNow(EntityPlayerMP sender, MentionConfigHandler.Config config) {
        if (sender == null) {
            return true;
        }
        if (sender.func_70003_b(2, "")) {
            return true;
        }
        long rateLimit = ((Integer)config.EVERYONE_MENTION_RATE_LIMIT.value).intValue();
        if (rateLimit <= 0L) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        UUID senderUUID = sender.func_110124_au();
        Long last = this.lastEveryoneMentionBySender.get(senderUUID);
        return last == null || currentTime - last >= rateLimit * 1000L;
    }

    private void markMentionEveryoneUsed(EntityPlayerMP sender) {
        if (sender == null) {
            return;
        }
        this.lastEveryoneMentionBySender.put(sender.func_110124_au(), System.currentTimeMillis());
    }

    private boolean canMentionIndividualNow(EntityPlayerMP sender, MentionConfigHandler.Config config) {
        if (sender == null) {
            return true;
        }
        if (sender.func_70003_b(2, "")) {
            return true;
        }
        long rateLimit = ((Integer)config.INDIVIDUAL_MENTION_RATE_LIMIT.value).intValue();
        if (rateLimit <= 0L) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        UUID senderUUID = sender.func_110124_au();
        Long last = this.lastIndividualMentionBySender.get(senderUUID);
        return last == null || currentTime - last >= rateLimit * 1000L;
    }

    private void markMentionIndividualUsed(EntityPlayerMP sender) {
        if (sender == null) {
            return;
        }
        this.lastIndividualMentionBySender.put(sender.func_110124_au(), System.currentTimeMillis());
    }

    private void notifyEveryone(List<EntityPlayerMP> players, EntityPlayerMP sender, String originalMessage, boolean isConsole, MentionConfigHandler.Config config, String matchedEveryoneMention) {
        String senderName = isConsole || sender == null ? "Console" : sender.func_70005_c_();
        String chatFormat = (String)config.EVERYONE_MENTION_MESSAGE.value;
        String titleFormat = (String)config.EVERYONE_TITLE_MESSAGE.value;
        String content = originalMessage.replace(matchedEveryoneMention, "").trim();
        String chatMessageText = String.format(chatFormat, senderName);
        String titleMessageText = String.format(titleFormat, senderName);
        for (EntityPlayerMP targetPlayer : players) {
            this.sendMentionNotification(targetPlayer, chatMessageText, titleMessageText, content);
        }
    }

    private void notifyPlayer(EntityPlayerMP targetPlayer, EntityPlayerMP sender, String originalMessage, boolean isConsole, MentionConfigHandler.Config config, String matchedPlayerMention) {
        String senderName = isConsole || sender == null ? "Console" : sender.func_70005_c_();
        String chatFormat = (String)config.INDIVIDUAL_MENTION_MESSAGE.value;
        String titleFormat = (String)config.INDIVIDUAL_TITLE_MESSAGE.value;
        String content = originalMessage.replace(matchedPlayerMention, "").trim();
        String chatMessageText = String.format(chatFormat, senderName);
        String titleMessageText = String.format(titleFormat, senderName);
        this.sendMentionNotification(targetPlayer, chatMessageText, titleMessageText, content);
    }

    private void sendMentionNotification(EntityPlayerMP targetPlayer, String chatMessage, String titleMessage, String subtitleMessage) {
        SoundEvent sound;
        ITextComponent formattedChatMessage = this.services.getMessageParser().parseMessage(chatMessage, targetPlayer);
        if (!subtitleMessage.isEmpty()) {
            ITextComponent formattedSubtitle = this.services.getMessageParser().parseMessage("- " + subtitleMessage, targetPlayer);
            formattedChatMessage.func_150257_a((ITextComponent)new TextComponentString("\n")).func_150257_a(formattedSubtitle);
        }
        targetPlayer.func_145747_a(formattedChatMessage);
        ITextComponent titleComp = this.services.getMessageParser().parseMessage(titleMessage, targetPlayer);
        targetPlayer.field_71135_a.func_147359_a((Packet)new SPacketTitle(SPacketTitle.Type.TITLE, titleComp));
        if (!subtitleMessage.isEmpty()) {
            ITextComponent subtitleComp = this.services.getMessageParser().parseMessage(subtitleMessage, targetPlayer);
            targetPlayer.field_71135_a.func_147359_a((Packet)new SPacketTitle(SPacketTitle.Type.SUBTITLE, subtitleComp));
        }
        if ((sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.player.levelup"))) != null) {
            targetPlayer.field_70170_p.func_184148_a(null, targetPlayer.field_70165_t, targetPlayer.field_70163_u, targetPlayer.field_70161_v, sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    private boolean hasPermission(EntityPlayerMP player, String permissionNode, int permissionLevel) {
        return this.services.getPermissionsHandler().hasPermission(player, permissionNode) || player.func_70003_b(permissionLevel, "");
    }

    private Pattern buildAllPlayersMentionPattern(List<EntityPlayerMP> players, String mentionSymbol) {
        if (players.isEmpty()) {
            return Pattern.compile("a^");
        }
        String allPlayerNames = players.stream().map(p -> Pattern.quote(p.func_70005_c_())).collect(Collectors.joining("|"));
        return Pattern.compile(Pattern.quote(mentionSymbol) + "(" + allPlayerNames + ")", 2);
    }

    public class MentionCommand
    extends CommandBase {
        private final Services services;

        public MentionCommand(Services services) {
            this.services = services;
        }

        public String func_71517_b() {
            return "mention";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/mention <message>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            Mentions.this.executeMentionCommand(server, sender, args);
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            if (args.length >= 1) {
                return MentionCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            return Collections.emptyList();
        }
    }
}

