/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;

public class Restart
implements ParadigmModule {
    private static final String NAME = "Restart";
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("00");
    private Services services;
    private final AtomicBoolean tasksScheduled = new AtomicBoolean(false);
    private BossInfoServer restartBossBar = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getMainConfig().restartEnable.value;
    }

    @Override
    public void onLoad(FMLPreInitializationEvent event, Services services) {
        this.services = services;
        services.getDebugLogger().debugLog("Restart module loaded.");
    }

    @Override
    public void onServerStarting(FMLServerStartingEvent event, Services services) {
        if (!this.isEnabled(services)) {
            services.getDebugLogger().debugLog("Restart feature is disabled.");
            return;
        }
        services.getDebugLogger().debugLog("Restart module: Server starting, scheduling restarts.");
        this.scheduleConfiguredRestarts(services);
    }

    @Override
    public void onEnable(Services services) {
        services.getDebugLogger().debugLog("Restart module enabled.");
        if (services.getMinecraftServer() != null) {
            this.scheduleConfiguredRestarts(services);
        }
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("Restart module disabled. Cancelling scheduled restart tasks.");
        this.cleanup();
    }

    @Override
    public void onServerStopping(FMLServerStoppingEvent event, Services services) {
        services.getDebugLogger().debugLog("Restart module: Server stopping. Cancelling scheduled restart tasks.");
        this.cleanup();
    }

    private void cleanup() {
        this.tasksScheduled.set(false);
        if (this.restartBossBar != null && this.services.getMinecraftServer() != null) {
            new ArrayList<EntityPlayerMP>(this.restartBossBar.func_186757_c()).forEach(arg_0 -> ((BossInfoServer)this.restartBossBar).func_186761_b(arg_0));
            this.restartBossBar = null;
        }
    }

    @Override
    public ICommand getCommand() {
        return null;
    }

    @Override
    public void registerEventListeners(Services services) {
    }

    private void scheduleConfiguredRestarts(Services services) {
        if (this.tasksScheduled.getAndSet(true)) {
            services.getDebugLogger().debugLog("Restart: Restart tasks already scheduled. Ignoring request.");
            return;
        }
        this.cleanup();
        this.tasksScheduled.set(true);
        RestartConfigHandler.Config config = services.getRestartConfig();
        String restartType = (String)config.restartType.value;
        services.getDebugLogger().debugLog("Restart: Configured restart type: " + restartType);
        switch (restartType.toLowerCase()) {
            case "fixed": {
                this.scheduleFixedRestart(services, config);
                break;
            }
            case "realtime": {
                this.scheduleRealTimeRestarts(services, config);
                break;
            }
            default: {
                services.getDebugLogger().debugLog("Restart: Unknown or 'none' restart type. No tasks scheduled.");
                this.tasksScheduled.set(false);
            }
        }
    }

    private void scheduleFixedRestart(Services services, RestartConfigHandler.Config config) {
        double intervalHours = (Double)config.restartInterval.value;
        if (intervalHours <= 0.0) {
            services.getDebugLogger().debugLog("Restart: Invalid fixed restart interval: " + intervalHours);
            this.tasksScheduled.set(false);
            return;
        }
        long intervalMillis = (long)(intervalHours * 3600.0 * 1000.0);
        services.getDebugLogger().debugLog("Restart: Scheduling fixed restart sequence every " + intervalHours + " hours.");
        services.getTaskScheduler().scheduleAtFixedRate(() -> {
            if (!this.tasksScheduled.get()) {
                return;
            }
            this.initiateRestartSequence((double)intervalMillis / 1000.0, services, config);
        }, intervalMillis, intervalMillis, TimeUnit.MILLISECONDS);
    }

    private void scheduleRealTimeRestarts(Services services, RestartConfigHandler.Config config) {
        List realTimeIntervals = (List)config.realTimeInterval.value;
        if (realTimeIntervals == null || realTimeIntervals.isEmpty()) {
            services.getDebugLogger().debugLog("Restart: No valid real-time restart times found.");
            this.tasksScheduled.set(false);
            return;
        }
        long nowMillis = System.currentTimeMillis();
        long minDelayMillis = Long.MAX_VALUE;
        for (String restartTimeStr : realTimeIntervals) {
            try {
                long delay;
                Calendar restartCal = Calendar.getInstance();
                restartCal.setTime(new SimpleDateFormat("HH:mm").parse(restartTimeStr));
                Calendar nowCal = Calendar.getInstance();
                nowCal.setTimeInMillis(nowMillis);
                restartCal.set(1, nowCal.get(1));
                restartCal.set(2, nowCal.get(2));
                restartCal.set(5, nowCal.get(5));
                if (restartCal.getTimeInMillis() <= nowMillis) {
                    restartCal.add(5, 1);
                }
                if ((delay = restartCal.getTimeInMillis() - nowMillis) >= minDelayMillis) continue;
                minDelayMillis = delay;
            }
            catch (ParseException e) {
                services.getDebugLogger().debugLog("Restart: Error parsing restart time: " + restartTimeStr, e);
            }
        }
        if (minDelayMillis == Long.MAX_VALUE) {
            services.getDebugLogger().debugLog("Restart: No valid upcoming real-time restart found.");
            this.tasksScheduled.set(false);
            return;
        }
        services.getDebugLogger().debugLog("Restart: Next real-time restart sequence will begin in " + (double)minDelayMillis / 1000.0 + " seconds.");
        long finalMinDelayMillis = minDelayMillis;
        services.getTaskScheduler().schedule(() -> {
            if (!this.tasksScheduled.get()) {
                return;
            }
            this.initiateRestartSequence((double)finalMinDelayMillis / 1000.0, services, config);
        }, minDelayMillis, TimeUnit.MILLISECONDS);
    }

    private void initiateRestartSequence(double totalIntervalSeconds, Services services, RestartConfigHandler.Config config) {
        services.getDebugLogger().debugLog("Restart: Initiating restart sequence. Shutdown in " + totalIntervalSeconds + " seconds.");
        long totalIntervalMillis = (long)(totalIntervalSeconds * 1000.0);
        if (((Boolean)config.bossbarEnabled.value).booleanValue()) {
            ITextComponent bossBarMessage = services.getMessageParser().parseMessage("Server Restart Initializing...", null);
            this.restartBossBar = new BossInfoServer(bossBarMessage, BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
            this.restartBossBar.func_186735_a(1.0f);
            if (services.getMinecraftServer() != null) {
                services.getMinecraftServer().func_184103_al().func_181057_v().forEach(arg_0 -> ((BossInfoServer)this.restartBossBar).func_186760_a(arg_0));
            }
        }
        ArrayList broadcastTimes = new ArrayList((Collection)config.timerBroadcast.value);
        Collections.sort(broadcastTimes, Collections.reverseOrder());
        Iterator iterator = broadcastTimes.iterator();
        while (iterator.hasNext()) {
            int broadcastTimeSecBeforeRestart = (Integer)iterator.next();
            int secondsBefore = broadcastTimeSecBeforeRestart;
            long delayUntilWarningMillis = totalIntervalMillis - (long)secondsBefore * 1000L;
            if (delayUntilWarningMillis < 0L) continue;
            services.getTaskScheduler().schedule(() -> {
                if (!this.tasksScheduled.get()) {
                    return;
                }
                this.sendRestartWarning(secondsBefore, services, config, totalIntervalSeconds);
            }, delayUntilWarningMillis, TimeUnit.MILLISECONDS);
        }
        services.getTaskScheduler().schedule(() -> {
            if (!this.tasksScheduled.get()) {
                return;
            }
            this.performShutdown(services);
        }, totalIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private void sendRestartWarning(long timeLeftSeconds, Services services, RestartConfigHandler.Config config, double originalTotalIntervalSeconds) {
        SoundEvent soundEvent;
        MinecraftServer server = services.getMinecraftServer();
        if (server == null) {
            return;
        }
        int hours = (int)(timeLeftSeconds / 3600L);
        int minutes = (int)(timeLeftSeconds % 3600L / 60L);
        int seconds = (int)(timeLeftSeconds % 60L);
        String formattedTime = String.format("%dh %sm %ss", hours, TIME_FORMATTER.format(minutes), TIME_FORMATTER.format(seconds));
        String broadcastMessage = (String)config.broadcastMessage.value;
        String titleMessage = (String)config.titleMessage.value;
        String bossBarMessage = (String)config.bossBarMessage.value;
        String finalMessage = broadcastMessage.replace("{hours}", String.valueOf(hours)).replace("{minutes}", TIME_FORMATTER.format(minutes)).replace("{seconds}", TIME_FORMATTER.format(seconds)).replace("{time}", formattedTime);
        String finalTitle = titleMessage.replace("{hours}", String.valueOf(hours)).replace("{minutes}", TIME_FORMATTER.format(minutes)).replace("{seconds}", TIME_FORMATTER.format(seconds)).replace("{time}", formattedTime);
        String finalBossBar = bossBarMessage.replace("{hours}", String.valueOf(hours)).replace("{minutes}", TIME_FORMATTER.format(minutes)).replace("{seconds}", TIME_FORMATTER.format(seconds)).replace("{time}", formattedTime);
        if (((Boolean)config.timerUseChat.value).booleanValue()) {
            server.func_184103_al().func_148539_a(services.getMessageParser().parseMessage(finalMessage, null));
        }
        if (((Boolean)config.titleEnabled.value).booleanValue()) {
            ITextComponent titleComponent = services.getMessageParser().parseMessage(finalTitle, null);
            SPacketTitle packet = new SPacketTitle(SPacketTitle.Type.TITLE, titleComponent, 10, (Integer)config.titleStayTime.value * 20, 10);
            server.func_184103_al().func_148540_a((Packet)packet);
        }
        if (((Boolean)config.playSoundEnabled.value).booleanValue() && (double)timeLeftSeconds <= (Double)config.playSoundFirstTime.value && (soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation((String)config.playSoundString.value))) != null) {
            server.func_184103_al().func_181057_v().forEach(player -> player.func_184185_a(soundEvent, 1.0f, 1.0f));
        }
        if (((Boolean)config.bossbarEnabled.value).booleanValue() && this.restartBossBar != null) {
            this.restartBossBar.func_186739_a(services.getMessageParser().parseMessage(finalBossBar, null));
            float progress = Math.max(0.0f, (float)((double)timeLeftSeconds / Math.max(1.0, originalTotalIntervalSeconds)));
            this.restartBossBar.func_186735_a(progress);
        }
    }

    private void performShutdown(Services services) {
        MinecraftServer server = services.getMinecraftServer();
        if (server != null) {
            services.getDebugLogger().debugLog("Restart: Shutdown initiated at: " + new Date());
            ITextComponent kickMessage = services.getMessageParser().parseMessage((String)services.getRestartConfig().defaultRestartReason.value, null);
            ArrayList playerList = new ArrayList(server.func_184103_al().func_181057_v());
            for (EntityPlayerMP player : playerList) {
                player.field_71135_a.func_194028_b(kickMessage);
            }
            server.func_71263_m();
        } else {
            services.getDebugLogger().debugLog("Restart: Server instance is null, cannot perform shutdown.");
        }
    }
}

