/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StaffChat
implements ParadigmModule {
    private static final String NAME = "StaffChat";
    private final Map<UUID, Boolean> staffChatEnabledMap = new HashMap<UUID, Boolean>();
    private final Map<UUID, BossInfoServer> bossBarsMap = new HashMap<UUID, BossInfoServer>();
    private Services services;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getChatConfig().enableStaffChat.value;
    }

    @Override
    public void onLoad(FMLPreInitializationEvent event, Services services) {
        this.services = services;
        services.getDebugLogger().debugLog("StaffChat module loaded.");
    }

    @Override
    public void onServerStarting(FMLServerStartingEvent event, Services services) {
        services.getDebugLogger().debugLog("StaffChat module: Server starting.");
    }

    @Override
    public void onEnable(Services services) {
        services.getDebugLogger().debugLog("StaffChat module enabled.");
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("StaffChat module disabled.");
        MinecraftServer server = services.getMinecraftServer();
        if (server != null) {
            this.staffChatEnabledMap.forEach((uuid, isEnabled) -> {
                EntityPlayerMP player;
                if (isEnabled.booleanValue() && (player = server.func_184103_al().func_177451_a(uuid)) != null) {
                    this.removeBossBar(player);
                }
            });
        }
        this.staffChatEnabledMap.clear();
        this.bossBarsMap.clear();
    }

    @Override
    public void onServerStopping(FMLServerStoppingEvent event, Services services) {
        services.getDebugLogger().debugLog("StaffChat module: Server stopping.");
        this.onDisable(services);
    }

    @Override
    public ICommand getCommand() {
        return new StaffChatCommand(this.services);
    }

    @Override
    public void registerEventListeners(Services services) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (this.services == null || !this.isEnabled(this.services)) {
            return;
        }
        EntityPlayerMP player = event.getPlayer();
        if (this.staffChatEnabledMap.getOrDefault(player.func_110124_au(), false).booleanValue()) {
            MinecraftServer server = this.services.getMinecraftServer();
            if (server == null) {
                this.services.getLogger().warn("StaffChatModule: Server instance is null during ServerChatEvent for " + player.func_70005_c_());
                return;
            }
            this.sendStaffChatMessage(player, event.getMessage(), server, this.services);
            event.setCanceled(true);
        }
    }

    private void toggleStaffChat(EntityPlayerMP player, Services services) {
        boolean isCurrentlyEnabled = this.staffChatEnabledMap.getOrDefault(player.func_110124_au(), false);
        this.staffChatEnabledMap.put(player.func_110124_au(), !isCurrentlyEnabled);
        player.func_145747_a((ITextComponent)new TextComponentString("Staff chat " + (!isCurrentlyEnabled ? "\u00a7aenabled" : "\u00a7cdisabled")));
        if (!isCurrentlyEnabled) {
            this.showBossBar(player, services);
        } else {
            this.removeBossBar(player);
        }
        services.getDebugLogger().debugLog("Player " + player.func_70005_c_() + " toggled staff chat to " + !isCurrentlyEnabled);
    }

    private void sendStaffChatMessage(EntityPlayerMP sender, String message, MinecraftServer server, Services services) {
        ChatConfigHandler.Config chatConfig = services.getChatConfig();
        String format = (String)chatConfig.staffChatFormat.value;
        String rawFormattedMessage = String.format(format, sender.func_70005_c_(), message);
        ITextComponent chatComponent = services.getMessageParser().parseMessage(rawFormattedMessage, sender);
        server.func_184103_al().func_181057_v().forEach(onlinePlayer -> {
            if (services.getPermissionsHandler().hasPermission((EntityPlayerMP)onlinePlayer, "paradigm.staff") || onlinePlayer.func_70003_b(2, "")) {
                onlinePlayer.func_145747_a(chatComponent);
            }
        });
        services.getLogger().info("(StaffChat) {}: {}", (Object)sender.func_70005_c_(), (Object)message);
    }

    private void showBossBar(EntityPlayerMP player, Services services) {
        if (((Boolean)services.getChatConfig().enableStaffBossBar.value).booleanValue()) {
            this.removeBossBar(player);
            ITextComponent title = services.getMessageParser().parseMessage("\u00a7cStaff Chat Mode \u00a7aEnabled", player);
            BossInfoServer bossBar = new BossInfoServer(title, BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
            bossBar.func_186760_a(player);
            this.bossBarsMap.put(player.func_110124_au(), bossBar);
        }
    }

    private void removeBossBar(EntityPlayerMP player) {
        BossInfoServer bossBar = this.bossBarsMap.remove(player.func_110124_au());
        if (bossBar != null) {
            bossBar.func_186761_b(player);
        }
    }

    public class StaffChatCommand
    extends CommandBase {
        private final Services services;

        public StaffChatCommand(Services services) {
            this.services = services;
        }

        public String func_71517_b() {
            return "sc";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/sc [message] or /sc toggle";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            if (!(sender instanceof EntityPlayerMP)) {
                return false;
            }
            return this.services.getPermissionsHandler().hasPermission((EntityPlayerMP)sender, "paradigm.staff") || sender.func_70003_b(2, "");
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            EntityPlayerMP player = StaffChatCommand.func_71521_c((ICommandSender)sender);
            if (args.length == 0) {
                StaffChat.this.toggleStaffChat(player, this.services);
                return;
            }
            if (args[0].equalsIgnoreCase("toggle")) {
                StaffChat.this.toggleStaffChat(player, this.services);
            } else {
                String message = String.join((CharSequence)" ", args);
                StaffChat.this.sendStaffChatMessage(player, message, server, this.services);
            }
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            if (args.length == 1) {
                return StaffChatCommand.func_71530_a((String[])args, (String[])new String[]{"toggle"});
            }
            return Collections.emptyList();
        }
    }
}

