/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.data.Group;
import eu.avalanche7.paradigm.data.PlayerGroupData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class GroupChatManager {
    private final Map<String, Group> groups = new HashMap<String, Group>();
    private final Map<UUID, PlayerGroupData> playerData = new HashMap<UUID, PlayerGroupData>();
    private Services services;

    public void setServices(Services services) {
        this.services = services;
    }

    private ITextComponent translate(String key) {
        if (this.services != null && this.services.getLang() != null) {
            return this.services.getLang().translate(key);
        }
        return new TextComponentString(key);
    }

    private ITextComponent parseMessage(String message, EntityPlayerMP player) {
        if (this.services != null && this.services.getMessageParser() != null) {
            return this.services.getMessageParser().parseMessage(message, player);
        }
        return new TextComponentString(message);
    }

    private MinecraftServer getServer() {
        return this.services != null ? this.services.getMinecraftServer() : null;
    }

    private void debugLog(String message) {
        if (this.services != null && this.services.getDebugLogger() != null) {
            this.services.getDebugLogger().debugLog(message);
        }
    }

    public boolean createGroup(EntityPlayerMP player, String groupName) {
        if (groupName == null || groupName.trim().isEmpty() || groupName.length() > 32) {
            player.func_145747_a(this.translate("group.invalid_name"));
            return false;
        }
        if (this.groups.containsKey(groupName)) {
            player.func_145747_a(this.translate("group.already_exists"));
            return false;
        }
        Group group = new Group(groupName, player.func_110124_au());
        this.groups.put(groupName, group);
        this.getPlayerData(player).setCurrentGroup(groupName);
        player.func_145747_a(this.translate("group.created_successfully"));
        this.debugLog("Player " + player.func_70005_c_() + " created group: " + groupName);
        return true;
    }

    public boolean deleteGroup(EntityPlayerMP player) {
        PlayerGroupData data = this.getPlayerData(player);
        String groupName = data.getCurrentGroup();
        if (groupName == null || !this.groups.containsKey(groupName)) {
            player.func_145747_a(this.translate("group.no_group_to_delete"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(player.func_110124_au())) {
            player.func_145747_a(this.translate("group.not_owner"));
            return false;
        }
        MinecraftServer server = this.getServer();
        if (server != null) {
            group.getMembers().forEach(memberUUID -> {
                PlayerGroupData memberData = this.playerData.get(memberUUID);
                if (memberData != null && groupName.equals(memberData.getCurrentGroup())) {
                    memberData.setCurrentGroup(null);
                    EntityPlayerMP memberPlayer = server.func_184103_al().func_177451_a(memberUUID);
                    if (memberPlayer != null && !memberPlayer.equals((Object)player)) {
                        ITextComponent messageToMember = this.parseMessage(this.translate("group.group_deleted_by_owner").func_150260_c().replace("{group_name}", groupName), memberPlayer);
                        memberPlayer.func_145747_a(messageToMember);
                    }
                }
            });
        }
        this.groups.remove(groupName);
        player.func_145747_a(this.translate("group.deleted_successfully"));
        this.debugLog("Player " + player.func_70005_c_() + " deleted group: " + groupName);
        return true;
    }

    public void listGroups(EntityPlayerMP player) {
        if (this.groups.isEmpty()) {
            player.func_145747_a(this.translate("group.no_groups_available"));
            return;
        }
        player.func_145747_a(this.translate("group.available_groups"));
        for (String groupName : this.groups.keySet()) {
            player.func_145747_a((ITextComponent)new TextComponentString("- " + groupName));
        }
    }

    public Set<String> getAllGroupNames() {
        return this.groups.keySet();
    }

    public void groupInfo(EntityPlayerMP player, String groupName) {
        Group group = this.groups.get(groupName);
        if (group == null) {
            player.func_145747_a(this.translate("group.group_not_found"));
            return;
        }
        player.func_145747_a(this.parseMessage("&6Group Information: &e" + groupName, player));
        MinecraftServer server = this.getServer();
        String ownerName = server != null && server.func_152358_ax().func_152652_a(group.getOwner()) != null ? server.func_152358_ax().func_152652_a(group.getOwner()).getName() : "Unknown (Offline)";
        player.func_145747_a(this.parseMessage("&7Owner: &f" + ownerName, player));
        player.func_145747_a(this.parseMessage("&7Members (" + group.getMembers().size() + "):", player));
        group.getMembers().forEach(memberUUID -> {
            String memberName = server != null && server.func_152358_ax().func_152652_a(memberUUID) != null ? server.func_152358_ax().func_152652_a(memberUUID).getName() : "Unknown (Offline)";
            player.func_145747_a((ITextComponent)new TextComponentString("- " + memberName));
        });
    }

    public boolean invitePlayer(EntityPlayerMP inviter, EntityPlayerMP target) {
        PlayerGroupData inviterData = this.getPlayerData(inviter);
        String groupName = inviterData.getCurrentGroup();
        if (groupName == null || !this.groups.containsKey(groupName)) {
            inviter.func_145747_a(this.translate("group.no_group_to_invite_from"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(inviter.func_110124_au())) {
            inviter.func_145747_a(this.translate("group.not_owner_invite"));
            return false;
        }
        if (group.getMembers().contains(target.func_110124_au())) {
            ITextComponent alreadyInGroupMessage = this.parseMessage(this.translate("group.player_already_in_group").func_150260_c().replace("{player_name}", target.func_70005_c_()), inviter);
            inviter.func_145747_a(alreadyInGroupMessage);
            return false;
        }
        PlayerGroupData targetData = this.getPlayerData(target);
        targetData.addInvitation(groupName);
        ITextComponent inviteMessage = this.parseMessage(this.translate("group.invited").func_150260_c().replace("{group_name}", groupName).replace("{inviter_name}", inviter.func_70005_c_()), target);
        target.func_145747_a(inviteMessage);
        ITextComponent inviteSentMessage = this.parseMessage(this.translate("group.invite_sent").func_150260_c().replace("{player_name}", target.func_70005_c_()).replace("{group_name}", groupName), inviter);
        inviter.func_145747_a(inviteSentMessage);
        this.debugLog("Player " + inviter.func_70005_c_() + " invited " + target.func_70005_c_() + " to group: " + groupName);
        return true;
    }

    public boolean joinGroup(EntityPlayerMP player, String groupName) {
        PlayerGroupData playerData = this.getPlayerData(player);
        Group group = this.groups.get(groupName);
        if (group == null) {
            player.func_145747_a(this.translate("group.group_not_found"));
            return false;
        }
        String currentGroup = playerData.getCurrentGroup();
        if (currentGroup != null && !currentGroup.equals(groupName)) {
            this.leaveGroup(player);
        }
        group.addMember(player.func_110124_au());
        playerData.setCurrentGroup(groupName);
        playerData.removeInvitation(groupName);
        ITextComponent joinedMessage = this.parseMessage(this.translate("group.joined").func_150260_c().replace("{group_name}", groupName), player);
        player.func_145747_a(joinedMessage);
        MinecraftServer server = this.getServer();
        if (server != null) {
            ITextComponent playerJoinedNotification = this.parseMessage(this.translate("group.player_joined_notification").func_150260_c().replace("{player_name}", player.func_70005_c_()), null);
            group.getMembers().forEach(memberUUID -> {
                EntityPlayerMP member;
                if (!memberUUID.equals(player.func_110124_au()) && (member = server.func_184103_al().func_177451_a(memberUUID)) != null) {
                    member.func_145747_a(playerJoinedNotification);
                }
            });
        }
        this.debugLog("Player " + player.func_70005_c_() + " joined group: " + groupName);
        return true;
    }

    public boolean leaveGroup(EntityPlayerMP player) {
        UUID newOwner;
        PlayerGroupData data = this.getPlayerData(player);
        String groupName = data.getCurrentGroup();
        if (groupName == null || !this.groups.containsKey(groupName)) {
            player.func_145747_a(this.translate("group.no_group_to_leave"));
            return false;
        }
        Group group = this.groups.get(groupName);
        group.removeMember(player.func_110124_au());
        data.setCurrentGroup(null);
        ITextComponent leftMessage = this.parseMessage(this.translate("group.left").func_150260_c().replace("{group_name}", groupName), player);
        player.func_145747_a(leftMessage);
        MinecraftServer server = this.getServer();
        if (server != null) {
            ITextComponent playerLeftNotification = this.parseMessage(this.translate("group.player_left_notification").func_150260_c().replace("{player_name}", player.func_70005_c_()), null);
            group.getMembers().forEach(memberUUID -> {
                EntityPlayerMP member = server.func_184103_al().func_177451_a(memberUUID);
                if (member != null) {
                    member.func_145747_a(playerLeftNotification);
                }
            });
        }
        if (group.getMembers().isEmpty()) {
            this.groups.remove(groupName);
            this.debugLog("Group " + groupName + " disbanded as last member left.");
        } else if (group.getOwner().equals(player.func_110124_au()) && (newOwner = (UUID)group.getMembers().stream().findFirst().orElse(null)) != null && server != null) {
            group.setOwner(newOwner);
            EntityPlayerMP newOwnerPlayer = server.func_184103_al().func_177451_a(newOwner);
            if (newOwnerPlayer != null) {
                newOwnerPlayer.func_145747_a(this.translate("group.new_owner_notification"));
                this.debugLog("Ownership of group " + groupName + " transferred to " + newOwnerPlayer.func_70005_c_());
            }
        }
        this.debugLog("Player " + player.func_70005_c_() + " left group: " + groupName);
        return true;
    }

    public void toggleGroupChat(EntityPlayerMP player) {
        PlayerGroupData data = this.getPlayerData(player);
        boolean currentToggleState = data.isGroupChatToggled();
        if (!currentToggleState && data.getCurrentGroup() == null) {
            player.func_145747_a(this.translate("group.must_be_in_group_to_toggle"));
            return;
        }
        data.setGroupChatToggled(!currentToggleState);
        ITextComponent message = !currentToggleState ? this.translate("group.chat_enabled") : this.translate("group.chat_disabled");
        player.func_145747_a(message);
        this.debugLog("Player " + player.func_70005_c_() + " toggled group chat to " + !currentToggleState);
    }

    public boolean isGroupChatToggled(EntityPlayerMP player) {
        return this.getPlayerData(player).isGroupChatToggled();
    }

    public void setGroupChatToggled(EntityPlayerMP player, boolean toggled) {
        this.getPlayerData(player).setGroupChatToggled(toggled);
    }

    public void sendMessageToGroup(EntityPlayerMP sender, String groupName, String messageContent) {
        Group group = this.groups.get(groupName);
        if (group == null || !group.getMembers().contains(sender.func_110124_au())) {
            sender.func_145747_a(this.translate("group.not_in_group_or_not_exists"));
            return;
        }
        String format = "&9[{group_name}] &r{player_name} &7>&f {message}";
        String preFormatted = format.replace("{group_name}", groupName).replace("{player_name}", sender.func_70005_c_()).replace("{message}", messageContent);
        ITextComponent finalMessage = this.parseMessage(preFormatted, sender);
        MinecraftServer server = this.getServer();
        if (server != null) {
            group.getMembers().forEach(memberUUID -> {
                EntityPlayerMP member = server.func_184103_al().func_177451_a(memberUUID);
                if (member != null) {
                    member.func_145747_a(finalMessage);
                }
            });
        }
    }

    public void sendMessageFromCommand(EntityPlayerMP sender, String messageContent) {
        PlayerGroupData data = this.getPlayerData(sender);
        String groupName = data.getCurrentGroup();
        if (groupName == null) {
            sender.func_145747_a(this.translate("group.no_group_to_send_message"));
            return;
        }
        this.sendMessageToGroup(sender, groupName, messageContent);
    }

    public PlayerGroupData getPlayerData(EntityPlayerMP player) {
        return this.playerData.computeIfAbsent(player.func_110124_au(), k -> new PlayerGroupData());
    }

    public void clearAllGroupsAndPlayerData() {
        this.groups.clear();
        this.playerData.clear();
        this.debugLog("All group chat data cleared.");
    }
}

