/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.avalanche7.paradigm.Paradigm;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.utils.MessageParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.logging.log4j.Logger;

public class Lang {
    private final Logger logger;
    private Path langFolder;
    private final Map<String, String> translations = new HashMap<String, String>();
    private final MainConfigHandler.Config mainConfig;
    private final MessageParser messageParser;

    public Lang(Logger logger, MainConfigHandler.Config mainConfig, MessageParser messageParser) {
        this.logger = logger;
        this.mainConfig = mainConfig;
        this.messageParser = messageParser;
    }

    public void init(File configDir) {
        this.langFolder = new File(configDir, "lang").toPath();
        try {
            this.ensureDefaultLangFiles();
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize Lang class", (Throwable)e);
        }
    }

    public void initializeLanguage() {
        String language = (String)this.mainConfig.defaultLanguage.value;
        this.logger.info("Paradigm: Loaded language setting: {}", (Object)language);
        this.loadLanguage(language);
    }

    public void loadLanguage(String language) {
        this.logger.info("Paradigm: Attempting to load language: {}", (Object)language);
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Path langFile = this.langFolder.resolve(language + ".json");
        if (!Files.exists(langFile, new LinkOption[0])) {
            this.logger.error("Language file not found: {}. Attempting to use 'en'.", (Object)langFile);
            if (!language.equals("en")) {
                this.loadLanguage("en");
            } else {
                this.logger.error("English language file also missing. Translations will not work.");
            }
            return;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(langFile.toFile()), StandardCharsets.UTF_8);){
            Map rawMap = (Map)gson.fromJson((Reader)reader, type);
            this.translations.clear();
            this.flattenMap("", rawMap);
            this.logger.info("Paradigm: Successfully loaded language: {}", (Object)language);
        }
        catch (Exception e) {
            this.logger.error("Paradigm: Failed to load language file: " + language, (Throwable)e);
        }
    }

    private void flattenMap(String prefix, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                this.translations.put(key, (String)value);
                continue;
            }
            if (value instanceof Map) {
                Map castedMap = (Map)value;
                this.flattenMap(key, castedMap);
                continue;
            }
            if (value == null) continue;
            this.translations.put(key, value.toString());
        }
    }

    public ITextComponent translate(String key) {
        String translatedText = this.translations.getOrDefault(key, key);
        if (this.messageParser == null) {
            this.logger.warn("Lang.translate: MessageParser is null for key '{}'.", (Object)key);
            return new TextComponentString(translatedText.replace("&", "\u00a7"));
        }
        return this.messageParser.parseMessage(translatedText, null);
    }

    private void ensureDefaultLangFiles() throws IOException {
        if (!Files.exists(this.langFolder, new LinkOption[0])) {
            Files.createDirectories(this.langFolder, new FileAttribute[0]);
        }
        List<String> availableLanguages = Arrays.asList("en", "cs", "ru", "zh");
        for (String langCode : availableLanguages) {
            Path langFile = this.langFolder.resolve(langCode + ".json");
            if (Files.exists(langFile, new LinkOption[0])) continue;
            this.logger.warn("Language file missing: {}.json. Attempting to copy from resources.", (Object)langCode);
            try {
                InputStream in = Paradigm.class.getResourceAsStream("/lang/" + langCode + ".json");
                Throwable throwable = null;
                try {
                    if (in == null) {
                        this.logger.error("Default language file /lang/{}.json not found in JAR resources.", (Object)langCode);
                        continue;
                    }
                    Files.copy(in, langFile, StandardCopyOption.REPLACE_EXISTING);
                    this.logger.info("Copied default language file for: {}", (Object)langCode);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to copy default language file for: " + langCode, (Throwable)e);
            }
        }
    }
}

