/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.utils.Placeholders;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class MessageParser {
    private final Pattern urlPattern = Pattern.compile("https?://[\\w\\d./?=#&%-]+");
    private final Map<Pattern, BiConsumer<Matcher, TagContext>> tagHandlers;
    private final Map<String, ITextComponent> messageCache = new ConcurrentHashMap<String, ITextComponent>();
    private final Placeholders placeholders;

    public MessageParser(Placeholders placeholders) {
        this.placeholders = placeholders;
        this.tagHandlers = new LinkedHashMap<Pattern, BiConsumer<Matcher, TagContext>>();
        this.initializeTagHandlers();
    }

    private void initializeTagHandlers() {
        this.tagHandlers.put(Pattern.compile("\\[link=(.*?)\\]"), (matcher, context) -> {
            String url = matcher.group(1);
            ITextComponent linkContent = this.parseMessageInternal(url, context.getPlayer(), context.getCurrentStyle().func_150206_m());
            linkContent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this.formatUrl(url)));
            context.getComponent().func_150257_a(linkContent);
        });
        this.tagHandlers.put(Pattern.compile("\\[command=(.*?)\\]"), (matcher, context) -> {
            String command = matcher.group(1);
            String fullCommand = command.startsWith("/") ? command : "/" + command;
            ITextComponent commandContent = this.parseMessageInternal(fullCommand, context.getPlayer(), context.getCurrentStyle().func_150206_m());
            commandContent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, fullCommand));
            context.getComponent().func_150257_a(commandContent);
        });
        this.tagHandlers.put(Pattern.compile("\\[hover=(.*?)\\](.*?)\\[/hover\\]", 32), (matcher, context) -> {
            String hoverTextContent = matcher.group(1);
            String mainTextContent = matcher.group(2);
            ITextComponent hoverComponent = this.parseMessageInternal(hoverTextContent, context.getPlayer(), new Style());
            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponent);
            TextComponentString textWithHover = new TextComponentString("");
            this.parseTextRecursive(mainTextContent, (ITextComponent)textWithHover, context.getCurrentStyle(), context.getPlayer());
            this.applyHoverToComponent((ITextComponent)textWithHover, hoverEvent);
            context.getComponent().func_150257_a((ITextComponent)textWithHover);
        });
        this.tagHandlers.put(Pattern.compile("\\[divider\\]"), (matcher, context) -> context.getComponent().func_150257_a(new TextComponentString("--------------------").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150225_c(Boolean.valueOf(true)))));
        this.tagHandlers.put(Pattern.compile("\\[title=(.*?)\\]", 32), (matcher, context) -> {
            if (context.getPlayer() != null) {
                String titleText = matcher.group(1);
                ITextComponent titleComponent = this.parseTitleOrSubtitle(titleText, context.getCurrentStyle(), context.getPlayer());
                context.getPlayer().field_71135_a.func_147359_a((Packet)new SPacketTitle(SPacketTitle.Type.RESET, null));
                context.getPlayer().field_71135_a.func_147359_a((Packet)new SPacketTitle(SPacketTitle.Type.TITLE, titleComponent));
            }
        });
        this.tagHandlers.put(Pattern.compile("\\[subtitle=(.*?)\\]", 32), (matcher, context) -> {
            if (context.getPlayer() != null) {
                String subtitleText = matcher.group(1);
                ITextComponent subtitleComponent = this.parseTitleOrSubtitle(subtitleText, context.getCurrentStyle(), context.getPlayer());
                context.getPlayer().field_71135_a.func_147359_a((Packet)new SPacketTitle(SPacketTitle.Type.SUBTITLE, subtitleComponent));
            }
        });
        this.tagHandlers.put(Pattern.compile("\\[center\\](.*?)\\[/center\\]", 32), (matcher, context) -> {
            int totalPadding;
            int leftPadding;
            String textToCenter = matcher.group(1);
            ITextComponent innerComponent = this.parseMessageInternal(textToCenter, context.getPlayer(), context.getCurrentStyle());
            int APPROXIMATE_CHAT_WIDTH_CHARS = 53;
            String plainInnerText = innerComponent.func_150260_c();
            int textLength = plainInnerText.length();
            if (textLength < 53 && (leftPadding = (totalPadding = 53 - textLength) / 2) > 0) {
                String paddingSpaces = new String(new char[leftPadding]).replace('\u0000', ' ');
                context.getComponent().func_150257_a((ITextComponent)new TextComponentString(paddingSpaces));
            }
            context.getComponent().func_150257_a(innerComponent);
        });
    }

    private void applyHoverToComponent(ITextComponent component, HoverEvent hoverEvent) {
        component.func_150256_b().func_150209_a(hoverEvent);
        for (ITextComponent sibling : component.func_150253_a()) {
            this.applyHoverToComponent(sibling, hoverEvent);
        }
    }

    public ITextComponent parseMessage(String rawMessage, EntityPlayerMP player) {
        if (rawMessage == null || rawMessage.isEmpty()) {
            return new TextComponentString("");
        }
        return this.parseMessageInternal(rawMessage, player, new Style());
    }

    private ITextComponent parseMessageInternal(String rawMessage, EntityPlayerMP player, Style initialStyle) {
        String processedMessage = this.placeholders.replacePlaceholders(rawMessage, player);
        String messageForParsing = processedMessage.replace("&", "\u00a7");
        String cacheKey = messageForParsing;
        ITextComponent cached = this.messageCache.get(cacheKey);
        if (cached != null) {
            return cached.func_150259_f();
        }
        TextComponentString rootComponent = new TextComponentString("");
        this.parseTextRecursive(messageForParsing, (ITextComponent)rootComponent, initialStyle, player);
        this.messageCache.put(cacheKey, (ITextComponent)rootComponent);
        return rootComponent;
    }

    private void parseTextRecursive(String textToParse, ITextComponent parentComponent, Style currentStyle, EntityPlayerMP player) {
        int currentIndex = 0;
        int length = textToParse.length();
        Matcher urlMatcher = this.urlPattern.matcher(textToParse);
        while (currentIndex < length) {
            int nextLegacyFormat = textToParse.indexOf(167, currentIndex);
            int nextTagStart = textToParse.indexOf(91, currentIndex);
            int nextUrlStart = -1;
            if (urlMatcher.find(currentIndex)) {
                nextUrlStart = urlMatcher.start();
            }
            int firstEventIndex = length;
            if (nextLegacyFormat != -1) {
                firstEventIndex = Math.min(firstEventIndex, nextLegacyFormat);
            }
            if (nextTagStart != -1) {
                firstEventIndex = Math.min(firstEventIndex, nextTagStart);
            }
            if (nextUrlStart != -1) {
                firstEventIndex = Math.min(firstEventIndex, nextUrlStart);
            }
            if (firstEventIndex > currentIndex) {
                parentComponent.func_150257_a(new TextComponentString(textToParse.substring(currentIndex, firstEventIndex)).func_150255_a(currentStyle.func_150206_m()));
            }
            if (firstEventIndex == length) break;
            if (nextLegacyFormat == firstEventIndex) {
                if (firstEventIndex + 1 < length) {
                    currentStyle = this.applyFormatCode(currentStyle, textToParse.charAt(firstEventIndex + 1));
                    currentIndex = firstEventIndex + 2;
                    continue;
                }
                parentComponent.func_150257_a(new TextComponentString("\u00a7").func_150255_a(currentStyle.func_150206_m()));
                currentIndex = firstEventIndex + 1;
                continue;
            }
            if (nextTagStart == firstEventIndex) {
                boolean tagHandled = false;
                for (Map.Entry<Pattern, BiConsumer<Matcher, TagContext>> entry : this.tagHandlers.entrySet()) {
                    Pattern tagPattern = entry.getKey();
                    Matcher tagMatcher = tagPattern.matcher(textToParse);
                    if (!tagMatcher.find(firstEventIndex) || tagMatcher.start() != firstEventIndex) continue;
                    TagContext context = new TagContext(parentComponent, currentStyle, player);
                    entry.getValue().accept(tagMatcher, context);
                    currentIndex = tagMatcher.end();
                    tagHandled = true;
                    break;
                }
                if (tagHandled) continue;
                parentComponent.func_150257_a(new TextComponentString("[").func_150255_a(currentStyle.func_150206_m()));
                currentIndex = firstEventIndex + 1;
                continue;
            }
            if (nextUrlStart != -1 && nextUrlStart == firstEventIndex) {
                String url = urlMatcher.group(0);
                Style urlStyle = currentStyle.func_150206_m().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this.formatUrl(url)));
                parentComponent.func_150257_a(new TextComponentString(url).func_150255_a(urlStyle));
                currentIndex = urlMatcher.end();
                continue;
            }
            currentIndex = firstEventIndex + 1;
        }
    }

    private Style applyFormatCode(Style style, char colorCode) {
        switch (Character.toLowerCase(colorCode)) {
            case '0': {
                return style.func_150206_m().func_150238_a(TextFormatting.BLACK);
            }
            case '1': {
                return style.func_150206_m().func_150238_a(TextFormatting.DARK_BLUE);
            }
            case '2': {
                return style.func_150206_m().func_150238_a(TextFormatting.DARK_GREEN);
            }
            case '3': {
                return style.func_150206_m().func_150238_a(TextFormatting.DARK_AQUA);
            }
            case '4': {
                return style.func_150206_m().func_150238_a(TextFormatting.DARK_RED);
            }
            case '5': {
                return style.func_150206_m().func_150238_a(TextFormatting.DARK_PURPLE);
            }
            case '6': {
                return style.func_150206_m().func_150238_a(TextFormatting.GOLD);
            }
            case '7': {
                return style.func_150206_m().func_150238_a(TextFormatting.GRAY);
            }
            case '8': {
                return style.func_150206_m().func_150238_a(TextFormatting.DARK_GRAY);
            }
            case '9': {
                return style.func_150206_m().func_150238_a(TextFormatting.BLUE);
            }
            case 'a': {
                return style.func_150206_m().func_150238_a(TextFormatting.GREEN);
            }
            case 'b': {
                return style.func_150206_m().func_150238_a(TextFormatting.AQUA);
            }
            case 'c': {
                return style.func_150206_m().func_150238_a(TextFormatting.RED);
            }
            case 'd': {
                return style.func_150206_m().func_150238_a(TextFormatting.LIGHT_PURPLE);
            }
            case 'e': {
                return style.func_150206_m().func_150238_a(TextFormatting.YELLOW);
            }
            case 'f': {
                return style.func_150206_m().func_150238_a(TextFormatting.WHITE);
            }
            case 'k': {
                return style.func_150206_m().func_150237_e(Boolean.valueOf(true));
            }
            case 'l': {
                return style.func_150206_m().func_150227_a(Boolean.valueOf(true));
            }
            case 'm': {
                return style.func_150206_m().func_150225_c(Boolean.valueOf(true));
            }
            case 'n': {
                return style.func_150206_m().func_150228_d(Boolean.valueOf(true));
            }
            case 'o': {
                return style.func_150206_m().func_150217_b(Boolean.valueOf(true));
            }
            case 'r': {
                return new Style();
            }
        }
        return style;
    }

    private ITextComponent parseTitleOrSubtitle(String rawText, Style baseStyle, EntityPlayerMP player) {
        ITextComponent parsedComponent = this.parseMessageInternal(rawText, player, new Style());
        return this.applyBaseStyle(parsedComponent, baseStyle);
    }

    private ITextComponent applyBaseStyle(ITextComponent component, Style baseStyle) {
        component.func_150256_b().func_150221_a(baseStyle);
        for (ITextComponent child : component.func_150253_a()) {
            this.applyBaseStyle(child, baseStyle);
        }
        return component;
    }

    private String formatUrl(String url) {
        if (url != null && !url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
            return "http://" + url;
        }
        return url;
    }

    private static class TagContext {
        private final ITextComponent component;
        private final Style currentStyle;
        private final EntityPlayerMP player;

        TagContext(ITextComponent component, Style style, EntityPlayerMP player) {
            this.component = component;
            this.currentStyle = style;
            this.player = player;
        }

        public ITextComponent getComponent() {
            return this.component;
        }

        public Style getCurrentStyle() {
            return this.currentStyle;
        }

        public EntityPlayerMP getPlayer() {
            return this.player;
        }
    }
}

