/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.IPermissionsHelper;
import eu.avalanche7.paradigm.configs.CMConfig;
import eu.avalanche7.paradigm.utils.DebugLogger;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import org.apache.logging.log4j.Logger;

public class PermissionsHandler {
    private final Logger logger;
    private final CMConfig cmConfig;
    private final DebugLogger debugLogger;
    public static final String MENTION_EVERYONE_PERMISSION = "paradigm.mention.everyone";
    public static final String MENTION_PLAYER_PERMISSION = "paradigm.mention.player";
    public static final String STAFF_CHAT_PERMISSION = "paradigm.staff";
    public static final int MENTION_EVERYONE_PERMISSION_LEVEL = 2;
    public static final int MENTION_PLAYER_PERMISSION_LEVEL = 2;
    public static final int BROADCAST_PERMISSION_LEVEL = 2;
    public static final int ACTIONBAR_PERMISSION_LEVEL = 2;
    public static final int TITLE_PERMISSION_LEVEL = 2;
    public static final int BOSSBAR_PERMISSION_LEVEL = 2;
    private PermissionChecker checker;

    public PermissionsHandler(Logger logger, CMConfig cmConfig, DebugLogger debugLogger) {
        this.logger = logger;
        this.cmConfig = cmConfig;
        this.debugLogger = debugLogger;
    }

    public void initialize() {
        this.initializeChecker();
        this.registerPermissions();
    }

    private void initializeChecker() {
        if (this.checker != null) {
            return;
        }
        if (Loader.isModLoaded((String)"luckperms")) {
            this.checker = new LuckPermsChecker();
            this.logger.info("Paradigm: Using LuckPerms for permission checks.");
        } else if (Loader.isModLoaded((String)"forgeessentials")) {
            this.checker = new ForgeEssentialsChecker();
            this.logger.info("Paradigm: Using ForgeEssentials for permission checks.");
        } else {
            this.checker = new ForgePermissionChecker();
            this.logger.info("Paradigm: No compatible permissions mod found. Using vanilla OP level checks.");
        }
    }

    private void registerPermissions() {
        if (this.checker instanceof ForgeEssentialsChecker) {
            this.debugLogger.debugLog("Registering permissions with ForgeEssentials.");
            ForgeEssentialsChecker feChecker = (ForgeEssentialsChecker)this.checker;
            feChecker.registerPermission(MENTION_EVERYONE_PERMISSION, DefaultPermissionLevel.OP, "Allows mentioning everyone");
            feChecker.registerPermission(MENTION_PLAYER_PERMISSION, DefaultPermissionLevel.ALL, "Allows mentioning a player");
            feChecker.registerPermission(STAFF_CHAT_PERMISSION, DefaultPermissionLevel.OP, "Allows access to staff chat");
            if (this.cmConfig != null) {
                this.cmConfig.getLoadedCommands().forEach(command -> {
                    if (command.isRequirePermission() && command.getPermission() != null && !command.getPermission().isEmpty()) {
                        String desc = command.getDescription() != null ? command.getDescription() : "Execute the custom command: " + command.getName();
                        feChecker.registerPermission(command.getPermission(), DefaultPermissionLevel.OP, desc);
                        this.debugLogger.debugLog("Registered FE custom permission: " + command.getPermission());
                    }
                });
            }
        }
    }

    public boolean hasPermission(EntityPlayerMP player, String permission) {
        if (player == null) {
            return false;
        }
        if (this.checker == null) {
            this.logger.warn("PermissionsHandler checker not initialized. Defaulting to OP check.");
            return player.func_70003_b(4, "");
        }
        return this.checker.hasPermission(player, permission);
    }

    public static class ForgePermissionChecker
    implements PermissionChecker {
        @Override
        public boolean hasPermission(EntityPlayerMP player, String permission) {
            return player.func_70003_b(this.getPermissionLevel(permission), "");
        }

        private int getPermissionLevel(String permission) {
            switch (permission) {
                case "paradigm.mention.everyone": {
                    return 2;
                }
                case "paradigm.mention.player": {
                    return 2;
                }
                case "paradigm.staff": {
                    return 2;
                }
            }
            return 4;
        }
    }

    public static class ForgeEssentialsChecker
    implements PermissionChecker {
        @Override
        public boolean hasPermission(EntityPlayerMP player, String permission) {
            IPermissionsHelper permissionsHelper = APIRegistry.perms;
            return permissionsHelper != null && permissionsHelper.checkPermission((EntityPlayer)player, permission);
        }

        public void registerPermission(String permission, DefaultPermissionLevel level, String description) {
            IPermissionsHelper permissionsHelper = APIRegistry.perms;
            if (permissionsHelper != null) {
                permissionsHelper.registerPermission(permission, level, description);
            }
        }
    }

    public static class LuckPermsChecker
    implements PermissionChecker {
        @Override
        public boolean hasPermission(EntityPlayerMP player, String permission) {
            try {
                LuckPerms api = LuckPermsProvider.get();
                User user = api.getUserManager().getUser(player.func_110124_au());
                if (user != null) {
                    return user.getCachedData().getPermissionData().checkPermission(permission).asBoolean();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public static interface PermissionChecker {
        public boolean hasPermission(EntityPlayerMP var1, String var2);
    }
}

