/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import eu.avalanche7.paradigm.utils.DebugLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CooldownConfigHandler {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path cooldownsFilePath = Path.of("config", "paradigm", "cooldowns.json");
    private Map<UUID, Map<String, Long>> playerCooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();
    private final DebugLogger debugLogger;

    public CooldownConfigHandler(DebugLogger debugLogger) {
        this.debugLogger = debugLogger;
    }

    public void loadCooldowns() {
        if (Files.exists(this.cooldownsFilePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.cooldownsFilePath, StandardCharsets.UTF_8);){
                Type type = new TypeToken<ConcurrentHashMap<UUID, Map<String, Long>>>(){}.getType();
                Map loaded = (Map)this.gson.fromJson((Reader)reader, type);
                if (loaded != null) {
                    loaded.forEach((uuid, map) -> this.playerCooldowns.put((UUID)uuid, new ConcurrentHashMap(map)));
                    this.debugLogger.debugLog("CooldownConfigHandler: Loaded cooldowns from " + this.cooldownsFilePath);
                }
            }
            catch (JsonSyntaxException | IOException e) {
                this.debugLogger.debugLog("CooldownConfigHandler: Failed to load or parse cooldowns.json. Starting with empty cooldowns.", (Exception)e);
            }
        } else {
            this.debugLogger.debugLog("CooldownConfigHandler: cooldowns.json not found. Starting with empty cooldowns.");
        }
    }

    public void saveCooldowns() {
        try {
            Files.createDirectories(this.cooldownsFilePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.cooldownsFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                this.gson.toJson(this.playerCooldowns, (Appendable)writer);
                this.debugLogger.debugLog("CooldownConfigHandler: Saved cooldowns to " + this.cooldownsFilePath);
            }
        }
        catch (IOException e) {
            this.debugLogger.debugLog("CooldownConfigHandler: Failed to save cooldowns.json.", e);
        }
    }

    public long getLastUsage(UUID playerUUID, String commandName) {
        return this.playerCooldowns.getOrDefault(playerUUID, Collections.emptyMap()).getOrDefault(commandName, 0L);
    }

    public void setLastUsage(UUID playerUUID, String commandName, long timestamp) {
        this.playerCooldowns.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(commandName, timestamp);
    }

    public void clearPlayerCooldowns(UUID playerUUID) {
        this.playerCooldowns.remove(playerUUID);
        this.debugLogger.debugLog("CooldownConfigHandler: Cleared cooldowns for player " + playerUUID);
    }

    public void clearCommandCooldown(String commandName) {
        this.playerCooldowns.values().forEach(playerMap -> playerMap.remove(commandName));
        this.debugLogger.debugLog("CooldownConfigHandler: Cleared cooldowns for command " + commandName);
    }
}

