/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.JsonValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"paradigm");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("paradigm/restart.json");
    public static Config CONFIG = new Config();
    private static JsonValidator jsonValidator;

    public static void setJsonValidator(DebugLogger debugLogger) {
        jsonValidator = new JsonValidator(debugLogger);
    }

    public static void load() {
        boolean shouldSaveMerged;
        Config defaultConfig;
        block30: {
            defaultConfig = new Config();
            shouldSaveMerged = false;
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH, StandardCharsets.UTF_8);){
                    int c;
                    StringBuilder content = new StringBuilder();
                    while ((c = ((Reader)reader).read()) != -1) {
                        content.append((char)c);
                    }
                    if (jsonValidator != null) {
                        JsonValidator.ValidationResult result = jsonValidator.validateAndFix(content.toString());
                        if (result.isValid()) {
                            Config loadedConfig;
                            if (result.hasIssues()) {
                                LOGGER.info("[Paradigm] Fixed JSON syntax issues in restart.json: " + result.getIssuesSummary());
                                LOGGER.info("[Paradigm] Saving corrected version to preserve user values");
                                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                                try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                                    writer.write(result.getFixedJson());
                                    LOGGER.info("[Paradigm] Saved corrected restart.json with preserved user values");
                                }
                                catch (IOException saveError) {
                                    LOGGER.warn("[Paradigm] Failed to save corrected file: " + saveError.getMessage());
                                }
                            }
                            if ((loadedConfig = (Config)GSON.fromJson(result.getFixedJson(), Config.class)) != null) {
                                RestartConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                                LOGGER.info("[Paradigm] Successfully loaded restart.json configuration");
                                shouldSaveMerged = true;
                            }
                            break block30;
                        }
                        LOGGER.warn("[Paradigm] Critical JSON syntax errors in restart.json: " + result.getMessage());
                        LOGGER.warn("[Paradigm] Please fix the JSON syntax manually. Using default values for this session.");
                        LOGGER.warn("[Paradigm] Your file has NOT been modified - fix the syntax and restart the server.");
                        break block30;
                    }
                    Config loadedConfig = (Config)GSON.fromJson(content.toString(), Config.class);
                    if (loadedConfig != null) {
                        RestartConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                        shouldSaveMerged = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("[Paradigm] Could not parse restart.json, using defaults and regenerating file.", (Throwable)e);
                }
            } else {
                LOGGER.info("[Paradigm] restart.json not found, generating with default values.");
            }
        }
        CONFIG = defaultConfig;
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            RestartConfigHandler.save();
            LOGGER.info("[Paradigm] Generated new restart.json with default values.");
        } else if (shouldSaveMerged) {
            try {
                RestartConfigHandler.save();
                LOGGER.info("[Paradigm] Synchronized restart.json with new defaults while preserving user values.");
            }
            catch (Exception e) {
                LOGGER.warn("[Paradigm] Failed to write merged restart.json: " + e.getMessage());
            }
        }
    }

    private static void mergeConfigs(Config defaults, Config loaded) {
        try {
            Field[] fields;
            for (Field field : fields = Config.class.getDeclaredFields()) {
                if (field.getType() != ConfigEntry.class) continue;
                field.setAccessible(true);
                ConfigEntry loadedEntry = (ConfigEntry)field.get(loaded);
                ConfigEntry defaultEntry = (ConfigEntry)field.get(defaults);
                if (loadedEntry != null && loadedEntry.value != null) {
                    defaultEntry.value = loadedEntry.value;
                    LOGGER.debug("[Paradigm] Preserved user setting for: " + field.getName());
                    continue;
                }
                LOGGER.debug("[Paradigm] Using default value for new/missing config: " + field.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("[Paradigm] Error merging restart configs", (Throwable)e);
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Restart config", e);
        }
    }

    public static class Config {
        public ConfigEntry<String> restartType = new ConfigEntry<String>("Realtime", "The method for scheduling restarts. Use \"Fixed\" for intervals, \"Realtime\" for specific times, or \"None\".");
        public ConfigEntry<Double> restartInterval = new ConfigEntry<Double>(6.0, "If restartType is \"Fixed\", this is the interval in hours between restarts.");
        public ConfigEntry<List<String>> realTimeInterval = new ConfigEntry<List<String>>(Arrays.asList("00:00", "06:00", "12:00", "18:00"), "If restartType is \"Realtime\", this is a list of times (in HH:mm 24-hour format) to restart the server.");
        public ConfigEntry<Boolean> bossbarEnabled = new ConfigEntry<Boolean>(true, "Enable a boss bar for the restart countdown.");
        public ConfigEntry<String> bossBarMessage = new ConfigEntry<String>("&cThe server will be restarting in {minutes}:{seconds}", "Message for the boss bar. Placeholders: {hours}, {minutes}, {seconds}, {time}.");
        public ConfigEntry<Boolean> timerUseChat = new ConfigEntry<Boolean>(true, "Broadcast restart warnings in chat.");
        public ConfigEntry<String> BroadcastMessage = new ConfigEntry<String>("&cThe server will be restarting in &e{time}", "Custom message for chat warnings. Placeholders: {hours}, {minutes}, {seconds}, {time}.");
        public ConfigEntry<List<Integer>> timerBroadcast = new ConfigEntry<List<Integer>>(Arrays.asList(3600, 1800, 600, 300, 120, 60, 30, 10, 5, 4, 3, 2, 1), "A list of times in seconds before a restart to broadcast a warning.");
        public ConfigEntry<String> defaultRestartReason = new ConfigEntry<String>("&6The server is restarting!", "The kick message shown to players when the server restarts.");
        public ConfigEntry<Boolean> playSoundEnabled = new ConfigEntry<Boolean>(true, "Enable notification sounds for restart warnings.");
        public ConfigEntry<String> playSoundString = new ConfigEntry<String>("minecraft:block.note_block.pling", "The sound event ID to play for warnings (e.g., 'minecraft:entity.player.levelup').");
        public ConfigEntry<Double> playSoundFirstTime = new ConfigEntry<Double>(60.0, "Time in seconds before restart to begin playing warning sounds.");
        public ConfigEntry<Boolean> titleEnabled = new ConfigEntry<Boolean>(true, "Enable title messages for restart warnings.");
        public ConfigEntry<Integer> titleStayTime = new ConfigEntry<Integer>(2, "Duration in seconds for the title message to stay on screen.");
        public ConfigEntry<String> titleMessage = new ConfigEntry<String>("&cRestarting in {minutes}:{seconds}", "Message for the title warning. Use '\\n' for a subtitle.");
        public ConfigEntry<List<PreRestartCommand>> preRestartCommands = new ConfigEntry(Collections.emptyList(), "Optional commands to run before restart. Each entry has 'secondsBefore' and 'command'. Prefix with 'each:' or 'asplayer:' or '[asPlayer]' to execute once per online player; otherwise runs as console. Placeholders supported.");
    }

    public static class PreRestartCommand {
        public int secondsBefore;
        public String command;
    }
}

