/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.mixin;

import eu.avalanche7.paradigm.Paradigm;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.core.Services;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin {
    @Inject(method={"*(Lnet/minecraft/network/chat/Component;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void paradigm$filterJoinLeaveMessages(Component message, boolean overlay, CallbackInfo ci) {
        boolean joinLeaveEnabled;
        if (message == null) {
            return;
        }
        int type = this.paradigm$getVanillaJoinLeaveType(message);
        if (type == 0) {
            return;
        }
        Services services = Paradigm.getServices();
        if (services == null) {
            return;
        }
        ChatConfigHandler.Config cfg = services.getChatConfig();
        boolean bl = joinLeaveEnabled = cfg != null && Boolean.TRUE.equals(cfg.enableJoinLeaveMessages.get());
        if (joinLeaveEnabled) {
            System.out.println("[Paradigm-Mixin] Suppressed vanilla: " + this.paradigm$safeToString(message));
            ci.cancel();
        }
    }

    @Unique
    private int paradigm$getVanillaJoinLeaveType(Component message) {
        try {
            String lower;
            String text;
            if (message instanceof TranslatableComponent) {
                TranslatableComponent tc = (TranslatableComponent)message;
                String key = tc.m_131328_();
                if ("multiplayer.player.joined".equals(key) || "multiplayer.player.joined.renamed".equals(key)) {
                    return 1;
                }
                if ("multiplayer.player.left".equals(key)) {
                    return 2;
                }
            }
            if ((text = message.getString()) != null && !(lower = text.toLowerCase()).contains("&") && !lower.contains("\u00a7")) {
                if (lower.endsWith(" joined the game")) {
                    return 1;
                }
                if (lower.endsWith(" left the game")) {
                    return 2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    @Unique
    private String paradigm$safeToString(Component c) {
        try {
            String text = c == null ? "null" : c.getString();
            return text.length() > 50 ? text.substring(0, 50) + "..." : text;
        }
        catch (Throwable t) {
            return "<component>";
        }
    }

    static {
        System.out.println("[Paradigm-Mixin] PlayerListMixin loaded!");
    }
}

