/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.platform.Interfaces;

import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IEventSystem;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.utils.MessageParser;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public interface IPlatformAdapter {
    public void provideMessageParser(MessageParser var1);

    public Object getMinecraftServer();

    public void setMinecraftServer(Object var1);

    public List<IPlayer> getOnlinePlayers();

    @Nullable
    public IPlayer getPlayerByName(String var1);

    @Nullable
    public IPlayer getPlayerByUuid(UUID var1);

    public String getPlayerName(IPlayer var1);

    public IComponent getPlayerDisplayName(IPlayer var1);

    public IComponent createLiteralComponent(String var1);

    public IComponent createTranslatableComponent(String var1, Object ... var2);

    public Object createItemStack(String var1);

    public boolean hasPermission(IPlayer var1, String var2);

    public boolean hasPermission(IPlayer var1, String var2, int var3);

    public boolean hasPermissionNode(IPlayer var1, String var2);

    public boolean hasCommandPermission(Object var1, String var2);

    public boolean hasCommandPermission(Object var1, String var2, int var3);

    public void sendSystemMessage(IPlayer var1, IComponent var2);

    public void sendSystemMessage(IPlayer var1, String var2);

    public void broadcastSystemMessage(IComponent var1);

    public void broadcastChatMessage(IComponent var1);

    public void broadcastSystemMessage(IComponent var1, String var2, String var3, @Nullable IPlayer var4);

    public void sendTitle(IPlayer var1, IComponent var2, IComponent var3);

    public void sendTitle(IPlayer var1, String var2, String var3);

    public void sendSubtitle(IPlayer var1, IComponent var2);

    public void sendActionBar(IPlayer var1, IComponent var2);

    public void sendActionBar(IPlayer var1, String var2);

    public void clearTitles(IPlayer var1);

    public void sendBossBar(List<IPlayer> var1, IComponent var2, int var3, BossBarColor var4, float var5);

    public void sendBossBar(List<IPlayer> var1, String var2, int var3, BossBarColor var4, float var5);

    public void showPersistentBossBar(IPlayer var1, IComponent var2, BossBarColor var3, BossBarOverlay var4);

    public void removePersistentBossBar(IPlayer var1);

    public void createOrUpdateRestartBossBar(IComponent var1, BossBarColor var2, float var3);

    public void createOrUpdateRestartBossBar(String var1, BossBarColor var2, float var3);

    public void removeRestartBossBar();

    public void playSound(IPlayer var1, String var2, SoundCategory var3, float var4, float var5);

    public String replacePlaceholders(String var1, @Nullable IPlayer var2);

    public boolean hasPermissionForCustomCommand(Object var1, CustomCommand var2);

    public void shutdownServer(IComponent var1);

    public void shutdownServer(String var1);

    public void sendSuccess(Object var1, IComponent var2, boolean var3);

    public void sendFailure(Object var1, IComponent var2);

    public void teleportPlayer(IPlayer var1, double var2, double var4, double var6);

    public boolean playerHasItem(IPlayer var1, String var2, int var3);

    public boolean isPlayerInArea(IPlayer var1, String var2, List<Integer> var3, List<Integer> var4);

    public void executeCommandAs(Object var1, String var2);

    public void executeCommandAsConsole(String var1);

    public boolean isModLoaded(String var1);

    public ICommandSource wrapCommandSource(Object var1);

    public void sendSuccess(ICommandSource var1, IComponent var2, boolean var3);

    public void sendFailure(ICommandSource var1, IComponent var2);

    public boolean hasCommandPermission(ICommandSource var1, String var2);

    public boolean hasCommandPermission(ICommandSource var1, String var2, int var3);

    public void executeCommandAs(ICommandSource var1, String var2);

    public IEventSystem getEventSystem();

    public List<String> getWorldNames();

    public List<String> getOnlinePlayerNames();

    public static enum SoundCategory {
        MASTER,
        MUSIC,
        RECORDS,
        WEATHER,
        BLOCKS,
        HOSTILE,
        NEUTRAL,
        PLAYERS,
        AMBIENT,
        VOICE;

    }

    public static enum AdvancementFrame {
        TASK,
        CHALLENGE,
        GOAL;

    }

    public static enum BossBarOverlay {
        PROGRESS,
        NOTCHED_6,
        NOTCHED_10,
        NOTCHED_12,
        NOTCHED_20;

    }

    public static enum BossBarColor {
        PINK,
        BLUE,
        RED,
        GREEN,
        YELLOW,
        PURPLE,
        WHITE;

    }
}

