/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.configs.MainConfigHandler;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugLogger {
    private static final Logger SLF4J_LOGGER = LoggerFactory.getLogger(DebugLogger.class);
    private final MainConfigHandler.Config mainConfig;
    private static final AtomicBoolean hasLoggedStatus = new AtomicBoolean(false);

    public DebugLogger(MainConfigHandler.Config mainConfig) {
        this.mainConfig = mainConfig;
        boolean debugEnabledInConfig = mainConfig != null && mainConfig.debugEnable.get() != false;
        SLF4J_LOGGER.info("[Paradigm-DebugLogger] Ensuring logger exists for dynamic level setting");
        if (!hasLoggedStatus.getAndSet(true)) {
            if (debugEnabledInConfig) {
                SLF4J_LOGGER.info("[Paradigm] Debug logging is ENABLED. Verbose logs will now be shown. (Check both console and logs/latest.log)");
                this.setParadigmLogLevel(DebugLogger.class.getName(), true);
            } else {
                SLF4J_LOGGER.info("[Paradigm] Debug logging is DISABLED. To see verbose logs, enable 'debugEnable' in the main config.");
                this.setParadigmLogLevel(DebugLogger.class.getName(), false);
                SLF4J_LOGGER.warn("[Paradigm] DebugLogger constructed with debug disabled! No debug logs will be shown.");
            }
        } else if (!debugEnabledInConfig) {
            SLF4J_LOGGER.warn("[Paradigm] DebugLogger constructed with debug disabled! No debug logs will be shown.");
        }
    }

    private void setParadigmLogLevel(String loggerName, boolean debug) {
        try {
            SLF4J_LOGGER.info("[Paradigm-DebugLogger] Trying Logback for logger: {} (debug={})", (Object)loggerName, (Object)debug);
            Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
            Object loggerContext = loggerFactoryClass.getMethod("getILoggerFactory", new Class[0]).invoke(null, new Object[0]);
            if (loggerContext.getClass().getName().equals("ch.qos.logback.classic.LoggerContext")) {
                Class<?> loggerClass = Class.forName("ch.qos.logback.classic.Logger");
                Class<?> levelClass = Class.forName("ch.qos.logback.classic.Level");
                Object level = debug ? levelClass.getField("DEBUG").get(null) : levelClass.getField("INFO").get(null);
                Object logger = loggerContext.getClass().getMethod("getLogger", String.class).invoke(loggerContext, loggerName);
                if (loggerClass.isInstance(logger)) {
                    loggerClass.getMethod("setLevel", levelClass).invoke(logger, level);
                    SLF4J_LOGGER.info("[Paradigm-DebugLogger] Logback logger '{}' level set to {}", (Object)loggerName, (Object)(debug ? "DEBUG" : "INFO"));
                    return;
                }
                SLF4J_LOGGER.warn("[Paradigm-DebugLogger] Logger instance is not Logback Logger!");
            } else {
                SLF4J_LOGGER.info("[Paradigm-DebugLogger] Not a Logback context, falling back to Log4j2.");
            }
        }
        catch (Throwable t) {
            SLF4J_LOGGER.info("[Paradigm-DebugLogger] Logback not available or failed: {}", (Object)t.toString());
        }
        try {
            Object rootLoggerConfig;
            SLF4J_LOGGER.info("[Paradigm-DebugLogger] Trying Log4j2 for logger: {} (debug={})", (Object)loggerName, (Object)debug);
            Class<?> logManagerClass = Class.forName("org.apache.logging.log4j.LogManager");
            Class<?> levelClass = Class.forName("org.apache.logging.log4j.Level");
            Object level = debug ? levelClass.getField("DEBUG").get(null) : levelClass.getField("INFO").get(null);
            Object ctx = logManagerClass.getMethod("getContext", Boolean.TYPE).invoke(null, false);
            Object config = ctx.getClass().getMethod("getConfiguration", new Class[0]).invoke(ctx, new Object[0]);
            Map loggers = (Map)config.getClass().getMethod("getLoggers", new Class[0]).invoke(config, new Object[0]);
            String currentLogger = loggerName;
            boolean set = false;
            while (currentLogger != null) {
                Object loggerConfig = loggers.get(currentLogger);
                if (loggerConfig != null) {
                    loggerConfig.getClass().getMethod("setLevel", levelClass).invoke(loggerConfig, level);
                    ctx.getClass().getMethod("updateLoggers", new Class[0]).invoke(ctx, new Object[0]);
                    SLF4J_LOGGER.info("[Paradigm-DebugLogger] Log4j2 logger '{}' level set to {}", (Object)currentLogger, (Object)(debug ? "DEBUG" : "INFO"));
                    set = true;
                    break;
                }
                int lastDot = currentLogger.lastIndexOf(46);
                if (lastDot > 0) {
                    currentLogger = currentLogger.substring(0, lastDot);
                    continue;
                }
                if (!currentLogger.isEmpty()) {
                    currentLogger = "";
                    continue;
                }
                currentLogger = null;
            }
            if (!set && (rootLoggerConfig = loggers.get("root")) != null) {
                rootLoggerConfig.getClass().getMethod("setLevel", levelClass).invoke(rootLoggerConfig, level);
                ctx.getClass().getMethod("updateLoggers", new Class[0]).invoke(ctx, new Object[0]);
                SLF4J_LOGGER.info("[Paradigm-DebugLogger] Log4j2 root logger level set to {}", (Object)(debug ? "DEBUG" : "INFO"));
                set = true;
            }
            if (!set) {
                SLF4J_LOGGER.warn("[Paradigm-DebugLogger] Log4j2 logger '{}' and its parents not found in config map! (Did you define it in log4j2.xml?)", (Object)loggerName);
            }
            if (set) {
                return;
            }
        }
        catch (Throwable t) {
            SLF4J_LOGGER.error("[Paradigm-DebugLogger] Log4j2 log level set failed: {}", (Object)t.toString());
        }
        SLF4J_LOGGER.warn("[Paradigm-DebugLogger] Could not set log level for '{}'! No compatible logging backend found.", (Object)loggerName);
    }

    public void debugLog(String message) {
        if (this.mainConfig != null && this.mainConfig.debugEnable.get().booleanValue()) {
            SLF4J_LOGGER.info("[Paradigm-Debug] " + message);
        }
    }

    public void debugLog(String message, Exception e) {
        if (this.mainConfig != null && this.mainConfig.debugEnable.get().booleanValue()) {
            SLF4J_LOGGER.info("[Paradigm-Debug] " + message, (Throwable)e);
        }
    }

    public void debugLog(String message, Object ... args) {
        if (this.mainConfig != null && this.mainConfig.debugEnable.get().booleanValue()) {
            SLF4J_LOGGER.info("[Paradigm-Debug] " + message, args);
        }
    }
}

