/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftComponent;
import eu.avalanche7.paradigm.utils.Placeholders;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public class MessageParser {
    private final Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private final Pattern urlPattern = Pattern.compile("https?://\\S+");
    private final Map<Pattern, BiConsumer<Matcher, TagContext>> tagHandlers;
    private final Map<String, IComponent> messageCache = new ConcurrentHashMap<String, IComponent>();
    private final Placeholders placeholders;
    private final IPlatformAdapter platformAdapter;

    public MessageParser(Placeholders placeholders, IPlatformAdapter platformAdapter) {
        this.placeholders = placeholders;
        this.platformAdapter = platformAdapter;
        this.tagHandlers = new LinkedHashMap<Pattern, BiConsumer<Matcher, TagContext>>();
        this.initializeTagHandlers();
    }

    private void initializeTagHandlers() {
        this.tagHandlers.put(Pattern.compile("\\[link=(.*?)\\]"), (matcher, context) -> {
            String url = matcher.group(1);
            context.getComponent().append(this.platformAdapter.createLiteralComponent(url).setStyle(context.getCurrentStyle().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, this.formatUrl(url))))).append(this.platformAdapter.createLiteralComponent(" ").setStyle(context.getCurrentStyle()));
        });
        this.tagHandlers.put(Pattern.compile("\\[command=(.*?)\\]"), (matcher, context) -> {
            String command = matcher.group(1);
            Object fullCommand = command.startsWith("/") ? command : "/" + command;
            context.getComponent().append(this.platformAdapter.createLiteralComponent((String)fullCommand).setStyle(context.getCurrentStyle().m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, (String)fullCommand)))).append(this.platformAdapter.createLiteralComponent(" ").setStyle(context.getCurrentStyle()));
        });
        this.tagHandlers.put(Pattern.compile("\\[hover=(.*?)\\](.*?)\\[/hover\\]", 32), (matcher, context) -> {
            String hoverTextContent = matcher.group(1);
            String mainTextContent = matcher.group(2);
            IComponent hoverComponent = this.parseMessageInternal(hoverTextContent, context.getPlayer(), Style.f_131099_);
            IComponent textWithHover = this.platformAdapter.createLiteralComponent("");
            this.parseTextRecursive(mainTextContent, textWithHover, context.getCurrentStyle(), context.getPlayer());
            this.applyHoverToComponent(textWithHover, new HoverEvent(HoverEvent.Action.f_130831_, (Object)((MinecraftComponent)hoverComponent).getHandle()));
            context.getComponent().append(textWithHover);
        });
        this.tagHandlers.put(Pattern.compile("\\[divider\\]"), (matcher, context) -> context.getComponent().append(this.platformAdapter.createLiteralComponent("--------------------").setStyle(context.getCurrentStyle().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)))));
        this.tagHandlers.put(Pattern.compile("\\[title=(.*?)\\]", 32), (matcher, context) -> {
            if (context.getPlayer() != null) {
                String titleText = matcher.group(1);
                IComponent titleComponent = this.parseTitleOrSubtitle(titleText, context.getCurrentStyle(), context.getPlayer());
                this.platformAdapter.clearTitles(context.getPlayer());
                this.platformAdapter.sendTitle(context.getPlayer(), titleComponent, this.platformAdapter.createLiteralComponent(""));
            }
        });
        this.tagHandlers.put(Pattern.compile("\\[subtitle=(.*?)\\]", 32), (matcher, context) -> {
            if (context.getPlayer() != null) {
                String subtitleText = matcher.group(1);
                IComponent subtitleComponent = this.parseTitleOrSubtitle(subtitleText, context.getCurrentStyle(), context.getPlayer());
                this.platformAdapter.sendSubtitle(context.getPlayer(), subtitleComponent);
            }
        });
        this.tagHandlers.put(Pattern.compile("\\[center\\](.*?)\\[/center\\]", 32), (matcher, context) -> {
            int totalPadding;
            int leftPadding;
            String textToCenter = matcher.group(1);
            IComponent innerComponent = this.parseMessageInternal(textToCenter, context.getPlayer(), context.getCurrentStyle());
            String plainInnerText = innerComponent.getRawText();
            int approximateChatWidthChars = 53;
            String paddingSpaces = "";
            int textLength = plainInnerText.length();
            if (textLength < approximateChatWidthChars && (leftPadding = (totalPadding = approximateChatWidthChars - textLength) / 2) > 0) {
                paddingSpaces = " ".repeat(leftPadding);
            }
            if (!paddingSpaces.isEmpty()) {
                context.getComponent().append(this.platformAdapter.createLiteralComponent(paddingSpaces).setStyle(context.getCurrentStyle()));
            }
            context.getComponent().append(innerComponent);
        });
    }

    private void applyHoverToComponent(IComponent component, HoverEvent hoverEvent) {
        component.setStyle(component.getStyle().m_131144_(hoverEvent));
        for (Object sibling : component.getSiblings()) {
            if (!(sibling instanceof IComponent)) continue;
            IComponent mutableSibling = (IComponent)sibling;
            this.applyHoverToComponent(mutableSibling, hoverEvent);
        }
    }

    public IComponent parseMessage(String rawMessage, IPlayer player) {
        return this.parseMessageInternal(rawMessage, player, Style.f_131099_);
    }

    private IComponent parseMessageInternal(String rawMessage, IPlayer player, Style initialStyle) {
        if (rawMessage == null) {
            return this.platformAdapter.createLiteralComponent("").setStyle(initialStyle);
        }
        String processedMessage = this.placeholders.replacePlaceholders(rawMessage, player);
        Matcher hexMatcher = this.hexPattern.matcher(processedMessage);
        StringBuffer sb = new StringBuffer();
        while (hexMatcher.find()) {
            String hexColor = hexMatcher.group(1);
            hexMatcher.appendReplacement(sb, "\u00a7#" + hexColor);
        }
        hexMatcher.appendTail(sb);
        processedMessage = sb.toString();
        String messageForParsing = processedMessage.replace("&", "\u00a7");
        String finalCacheKey = messageForParsing + "_style_" + initialStyle.hashCode() + (player != null ? player.getUUID() : "null_player");
        if (this.messageCache.containsKey(finalCacheKey)) {
            return this.messageCache.get(finalCacheKey).copy();
        }
        IComponent rootComponent = this.platformAdapter.createLiteralComponent("");
        this.parseTextRecursive(messageForParsing, rootComponent, initialStyle, player);
        this.messageCache.put(finalCacheKey, rootComponent);
        return rootComponent;
    }

    private void parseTextRecursive(String textToParse, IComponent parentComponent, Style currentStyle, IPlayer player) {
        int currentIndex = 0;
        int length = textToParse.length();
        Matcher urlMatcher = this.urlPattern.matcher(textToParse);
        while (currentIndex < length) {
            int nextLegacyFormat = textToParse.indexOf(167, currentIndex);
            int nextTagStart = textToParse.indexOf(91, currentIndex);
            boolean nextUrlFound = urlMatcher.find(currentIndex);
            int nextUrlStart = nextUrlFound ? urlMatcher.start() : -1;
            int firstEventIndex = length;
            if (nextLegacyFormat != -1) {
                firstEventIndex = Math.min(firstEventIndex, nextLegacyFormat);
            }
            if (nextTagStart != -1) {
                firstEventIndex = Math.min(firstEventIndex, nextTagStart);
            }
            if (nextUrlFound) {
                firstEventIndex = Math.min(firstEventIndex, nextUrlStart);
            }
            if (firstEventIndex > currentIndex) {
                parentComponent.append(this.platformAdapter.createLiteralComponent(textToParse.substring(currentIndex, firstEventIndex)).setStyle(currentStyle));
            }
            if ((currentIndex = firstEventIndex) == length) break;
            if (nextLegacyFormat == currentIndex) {
                if (currentIndex + 1 < length) {
                    char formatChar = textToParse.charAt(currentIndex + 1);
                    if (formatChar == '#') {
                        if (currentIndex + 7 < length) {
                            String hex = textToParse.substring(currentIndex + 2, currentIndex + 8);
                            try {
                                currentStyle = currentStyle.m_131148_(TextColor.m_131266_((int)Integer.parseInt(hex, 16)));
                                currentIndex += 8;
                            }
                            catch (NumberFormatException e) {
                                parentComponent.append(this.platformAdapter.createLiteralComponent(textToParse.substring(currentIndex, currentIndex + 2)).setStyle(currentStyle));
                                currentIndex += 2;
                            }
                            continue;
                        }
                        parentComponent.append(this.platformAdapter.createLiteralComponent(textToParse.substring(currentIndex, currentIndex + 1)).setStyle(currentStyle));
                        ++currentIndex;
                        continue;
                    }
                    ChatFormatting format = ChatFormatting.m_126645_((char)formatChar);
                    if (format != null) {
                        currentStyle = currentStyle.m_131157_(format);
                        if (format == ChatFormatting.RESET) {
                            currentStyle = Style.f_131099_;
                        }
                    } else {
                        parentComponent.append(this.platformAdapter.createLiteralComponent("\u00a7").setStyle(currentStyle));
                    }
                    currentIndex += 2;
                    continue;
                }
                parentComponent.append(this.platformAdapter.createLiteralComponent("\u00a7").setStyle(currentStyle));
                ++currentIndex;
                continue;
            }
            if (nextTagStart == currentIndex) {
                boolean tagHandled = false;
                for (Map.Entry<Pattern, BiConsumer<Matcher, TagContext>> entry : this.tagHandlers.entrySet()) {
                    Pattern tagPattern = entry.getKey();
                    Matcher tagMatcher = tagPattern.matcher(textToParse);
                    if (!tagMatcher.find(currentIndex) || tagMatcher.start() != currentIndex) continue;
                    TagContext context = new TagContext(parentComponent, currentStyle, player);
                    entry.getValue().accept(tagMatcher, context);
                    currentIndex = tagMatcher.end();
                    tagHandled = true;
                    break;
                }
                if (tagHandled) continue;
                parentComponent.append(this.platformAdapter.createLiteralComponent("[").setStyle(currentStyle));
                ++currentIndex;
                continue;
            }
            if (nextUrlFound && nextUrlStart == currentIndex) {
                String url = urlMatcher.group(0);
                Style urlStyle = currentStyle.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, this.formatUrl(url)));
                parentComponent.append(this.platformAdapter.createLiteralComponent(url).setStyle(urlStyle));
                currentIndex = urlMatcher.end();
                continue;
            }
            if (currentIndex >= length) continue;
            parentComponent.append(this.platformAdapter.createLiteralComponent(textToParse.substring(currentIndex, currentIndex + 1)).setStyle(currentStyle));
            ++currentIndex;
        }
    }

    private IComponent parseTitleOrSubtitle(String rawText, Style baseStyle, IPlayer player) {
        IComponent parsedComponent = this.parseMessageInternal(rawText, player, Style.f_131099_);
        return this.applyBaseStyle(parsedComponent, baseStyle);
    }

    private IComponent applyBaseStyle(IComponent component, Style baseStyle) {
        if (component instanceof MinecraftComponent) {
            MinecraftComponent mc = (MinecraftComponent)component;
            MutableComponent root = mc.getHandle().m_6881_();
            root.m_6270_(baseStyle.m_131146_(root.m_7383_()));
            ArrayList children = new ArrayList(root.m_7360_());
            try {
                root.m_7360_().clear();
            }
            catch (UnsupportedOperationException ignored) {
                root = new TextComponent(root.getString()).m_6270_(root.m_7383_());
            }
            for (Component child : children) {
                root.m_7220_(this.applyBaseStyleRecursive(child, baseStyle));
            }
            return new MinecraftComponent(root);
        }
        IComponent styledComponent = component.copy();
        styledComponent.setStyle(baseStyle.m_131146_(styledComponent.getStyle()));
        return styledComponent;
    }

    private Component applyBaseStyleRecursive(Component comp, Style baseStyle) {
        MutableComponent copy = comp.m_6881_();
        copy.m_6270_(baseStyle.m_131146_(copy.m_7383_()));
        List kids = new ArrayList(copy.m_7360_());
        try {
            copy.m_7360_().clear();
        }
        catch (UnsupportedOperationException ignored) {
            copy = new TextComponent(copy.getString()).m_6270_(copy.m_7383_());
            kids = List.of();
        }
        for (Component k : kids) {
            copy.m_7220_(this.applyBaseStyleRecursive(k, baseStyle));
        }
        return copy;
    }

    private String formatUrl(String url) {
        if (url != null && !url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
            return "https://" + url;
        }
        return url;
    }

    private static class TagContext {
        private final IComponent component;
        private final Style currentStyle;
        private final IPlayer player;

        TagContext(IComponent component, Style style, IPlayer player) {
            this.component = component;
            this.currentStyle = style;
            this.player = player;
        }

        public IComponent getComponent() {
            return this.component;
        }

        public Style getCurrentStyle() {
            return this.currentStyle;
        }

        public IPlayer getPlayer() {
            return this.player;
        }
    }
}

