/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.webeditor.store;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class WebEditorKeystore {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path consoleKeysPath;
    private final Set<String> trustedConsoleKeys;
    private final Map<String, String> trustedPlayerKeys;

    public WebEditorKeystore(Path consoleKeysPath) {
        this.consoleKeysPath = consoleKeysPath;
        this.trustedConsoleKeys = new CopyOnWriteArraySet<String>();
        this.trustedPlayerKeys = new HashMap<String, String>();
        try {
            this.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isTrusted(byte[] publicKey) {
        return this.trustedConsoleKeys.contains(WebEditorKeystore.hash(publicKey));
    }

    public void trust(byte[] publicKey) {
        if (publicKey == null) {
            return;
        }
        String h = WebEditorKeystore.hash(publicKey);
        if (this.trustedConsoleKeys.add(h)) {
            try {
                this.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isTrusted(ICommandSource sender, byte[] publicKey) {
        if (sender == null || publicKey == null) {
            return false;
        }
        String h = WebEditorKeystore.hash(publicKey);
        if (sender.isConsole()) {
            return this.trustedConsoleKeys.contains(h);
        }
        IPlayer p = sender.getPlayer();
        if (p == null) {
            return false;
        }
        String uuid = p.getUUID();
        String stored = this.trustedPlayerKeys.get(uuid);
        return h.equals(stored);
    }

    public boolean trust(ICommandSource sender, byte[] publicKey) {
        if (sender == null || publicKey == null) {
            return false;
        }
        String h = WebEditorKeystore.hash(publicKey);
        if (sender.isConsole()) {
            boolean added = this.trustedConsoleKeys.add(h);
            if (added) {
                try {
                    this.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return added;
        }
        IPlayer p = sender.getPlayer();
        if (p == null) {
            return false;
        }
        String uuid = p.getUUID();
        String prev = this.trustedPlayerKeys.put(uuid, h);
        try {
            this.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !h.equals(prev);
    }

    public boolean untrust(ICommandSource sender, String hashOrAll) {
        boolean existed;
        if (sender == null) {
            return false;
        }
        if (sender.isConsole()) {
            if (hashOrAll == null || hashOrAll.isEmpty()) {
                return false;
            }
            if ("all".equalsIgnoreCase(hashOrAll)) {
                boolean changed = !this.trustedConsoleKeys.isEmpty();
                this.trustedConsoleKeys.clear();
                if (changed) {
                    try {
                        this.save();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return changed;
            }
            boolean removed = this.trustedConsoleKeys.remove(hashOrAll);
            if (removed) {
                try {
                    this.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return removed;
        }
        IPlayer p = sender.getPlayer();
        if (p == null) {
            return false;
        }
        String uuid = p.getUUID();
        if (hashOrAll != null && !hashOrAll.isEmpty()) {
            String cur = this.trustedPlayerKeys.get(uuid);
            if (hashOrAll.equals(cur)) {
                this.trustedPlayerKeys.remove(uuid);
                try {
                    this.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
        boolean bl = existed = this.trustedPlayerKeys.remove(uuid) != null;
        if (existed) {
            try {
                this.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return existed;
    }

    public List<String> listTrusted(ICommandSource sender) {
        ArrayList<String> out = new ArrayList<String>();
        if (sender == null) {
            return out;
        }
        if (sender.isConsole()) {
            out.addAll(this.trustedConsoleKeys);
        } else {
            String v;
            IPlayer p = sender.getPlayer();
            if (p != null && (v = this.trustedPlayerKeys.get(p.getUUID())) != null) {
                out.add(v);
            }
        }
        return out;
    }

    private void load() throws Exception {
        if (Files.exists(this.consoleKeysPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.consoleKeysPath, StandardCharsets.UTF_8);){
                KeystoreFile file = (KeystoreFile)GSON.fromJson((Reader)reader, KeystoreFile.class);
                if (file != null) {
                    if (file.consoleKeys != null) {
                        this.trustedConsoleKeys.addAll(file.consoleKeys);
                    }
                    if (file.playerKeys != null) {
                        this.trustedPlayerKeys.putAll(file.playerKeys);
                    }
                }
            }
        }
    }

    private void save() throws Exception {
        if (this.consoleKeysPath.getParent() != null && !Files.exists(this.consoleKeysPath.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(this.consoleKeysPath.getParent(), new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.consoleKeysPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            KeystoreFile file = new KeystoreFile();
            file.consoleKeys = new ArrayList<String>(this.trustedConsoleKeys);
            file.playerKeys = new HashMap<String, String>(this.trustedPlayerKeys);
            GSON.toJson((Object)file, (Appendable)writer);
        }
    }

    public static String hash(byte[] buf) {
        byte[] digest = WebEditorKeystore.createDigest().digest(buf);
        return Base64.getEncoder().encodeToString(digest);
    }

    private static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class KeystoreFile {
        private String _comment = "This file stores a list of trusted editor public keys";
        private List<String> consoleKeys = null;
        private Map<String, String> playerKeys = null;

        private KeystoreFile() {
        }
    }
}

