package com.joshiegemfinder.apolimorph;

import java.util.Optional;
import java.util.function.UnaryOperator;

import io.github.apace100.apoli.recipe.ModifiedCraftingRecipe;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public class Apolimorph implements ModInitializer {
	public static final String MOD_ID = "apolimorph";
	
	@Override
	public void onInitialize() {}
	
	public static <T extends class_1860<?>> Optional<class_8786<T>> makeApoliRecipe(Optional<class_8786<T>> entry, class_9695 craftingInput) {
		return entry.map(makeApoliRecipe(craftingInput));
	}
	
	public static <T extends class_1860<?>> UnaryOperator<class_8786<T>> makeApoliRecipe(class_9695 craftingInput) {
		return entry -> makeApoliRecipe(entry, craftingInput);
	}
	
	@SuppressWarnings("unchecked")
	public static <T extends class_1860<?>> class_8786<T> makeApoliRecipe(class_8786<T> entry, class_9695 craftingInput) {
		class_2960 id = entry.comp_1932();
		class_1860<?> recipe = entry.comp_1933();
		
		if (recipe instanceof class_3955 craftingRecipe && !(recipe instanceof ModifiedCraftingRecipe) && ModifiedCraftingRecipe.canModify(id, craftingRecipe, craftingInput)) {
			return new class_8786<>(id, (T)new ModifiedCraftingRecipe(id, craftingRecipe));
		}
		else {
			return entry;
		}
	}
}