/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.data.client;

import com.google.common.collect.ImmutableMap;
import fuzs.eternalnether.data.ModAdvancementProvider;
import fuzs.eternalnether.init.ModBlockFamilies;
import fuzs.eternalnether.init.ModBlocks;
import fuzs.eternalnether.init.ModEntityTypes;
import fuzs.eternalnether.init.ModItems;
import fuzs.eternalnether.init.ModRegistry;
import fuzs.eternalnether.init.ModSoundEvents;
import fuzs.puzzleslib.api.client.data.v2.AbstractLanguageProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.data.BlockFamily;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModLanguageProvider
extends AbstractLanguageProvider {
    static final Map<BlockFamily.Variant, BiFunction<BlockFamilyBuilder, Block, BlockFamilyBuilder>> VARIANT_FUNCTIONS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, BlockFamilyBuilder::button).put((Object)BlockFamily.Variant.CHISELED, BlockFamilyBuilder::chiseled).put((Object)BlockFamily.Variant.CRACKED, BlockFamilyBuilder::cracked).put((Object)BlockFamily.Variant.CUT, BlockFamilyBuilder::cut).put((Object)BlockFamily.Variant.DOOR, BlockFamilyBuilder::door).put((Object)BlockFamily.Variant.CUSTOM_FENCE, BlockFamilyBuilder::fence).put((Object)BlockFamily.Variant.FENCE, BlockFamilyBuilder::fence).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, BlockFamilyBuilder::fenceGate).put((Object)BlockFamily.Variant.FENCE_GATE, BlockFamilyBuilder::fenceGate).put((Object)BlockFamily.Variant.MOSAIC, BlockFamilyBuilder::mosaic).put((Object)BlockFamily.Variant.SIGN, BlockFamilyBuilder::sign).put((Object)BlockFamily.Variant.SLAB, BlockFamilyBuilder::slab).put((Object)BlockFamily.Variant.STAIRS, BlockFamilyBuilder::stairs).put((Object)BlockFamily.Variant.PRESSURE_PLATE, BlockFamilyBuilder::pressurePlate).put((Object)BlockFamily.Variant.POLISHED, BlockFamilyBuilder::polished).put((Object)BlockFamily.Variant.TRAPDOOR, BlockFamilyBuilder::trapdoor).put((Object)BlockFamily.Variant.WALL, BlockFamilyBuilder::wall).put((Object)BlockFamily.Variant.WALL_SIGN, BlockFamilyBuilder::wallSign).build();

    public ModLanguageProvider(DataProviderContext context) {
        super(context);
    }

    public void addTranslations(AbstractLanguageProvider.TranslationBuilder builder) {
        builder.addCreativeModeTab(ModRegistry.CREATIVE_MODE_TAB, "Eternal Nether");
        builder.addBlock(ModBlocks.COBBLED_BLACKSTONE, "Cobbled Blackstone");
        ModLanguageProvider.blockFamily(builder, "Withered Blackstone").baseBlock((Block)ModBlocks.WITHERED_BLACKSTONE.value()).slab((Block)ModBlocks.WITHERED_BLACKSTONE_SLAB.value()).stairs((Block)ModBlocks.WITHERED_BLACKSTONE_STAIRS.value()).wall((Block)ModBlocks.WITHERED_BLACKSTONE_WALL.value()).chiseled((Block)ModBlocks.CHISELED_WITHERED_BLACKSTONE.value());
        ModLanguageProvider.blockFamily(builder, "Cracked Withered Blackstone").generateFor(ModBlockFamilies.CRACKED_WITHERED_BLACKSTONE_FAMILY);
        ModLanguageProvider.blockFamily(builder, "Warped Nether Brick", "Warped Nether Bricks").generateFor(ModBlockFamilies.WARPED_NETHER_BRICKS_FAMILY);
        builder.add((Block)ModBlocks.WITHERED_BASALT.value(), "Withered Basalt");
        builder.add((Block)ModBlocks.WITHERED_COAL_BLOCK.value(), "Withered Coal Block");
        builder.add((Block)ModBlocks.WITHERED_QUARTZ_BLOCK.value(), "Withered Quartz Block");
        builder.add((Block)ModBlocks.WITHERED_DEBRIS.value(), "Withered Debris");
        builder.add((Block)ModBlocks.SOUL_STONE.value(), "Soul Stone");
        builder.add((Block)ModBlocks.WITHERED_BONE_BLOCK.value(), "Withered Bone Block");
        builder.add((Block)ModBlocks.NETHERITE_BELL.value(), "Netherite Bell");
        builder.addSpawnEgg((Item)ModItems.WEX_SPAWN_EGG.value(), "Wex");
        builder.addSpawnEgg((Item)ModItems.WARPED_ENDERMAN_SPAWN_EGG.value(), "Warped Enderman");
        builder.addSpawnEgg((Item)ModItems.PIGLIN_PRISONER_SPAWN_EGG.value(), "Piglin Prisoner");
        builder.addSpawnEgg((Item)ModItems.PIGLIN_HUNTER_SPAWN_EGG.value(), "Piglin Hunter");
        builder.addSpawnEgg((Item)ModItems.WRAITHER_SPAWN_EGG.value(), "Wraither");
        builder.addSpawnEgg((Item)ModItems.WITHER_SKELETON_KNIGHT_SPAWN_EGG.value(), "Wither Skeleton Knight");
        builder.addSpawnEgg((Item)ModItems.CORPOR_SPAWN_EGG.value(), "Corpor");
        builder.addSpawnEgg((Item)ModItems.WITHER_SKELETON_HORSE_SPAWN_EGG.value(), "Withered Skeleton Horse");
        builder.add(ModItems.WITHER_WALTZ_JUKEBOX_SONG, "Izofar - Wither Waltz");
        builder.add((Item)ModItems.WITHER_WALTZ_MUSIC_DISC.value(), "Music Disc");
        builder.add((Item)ModItems.WARPED_ENDER_PEARL.value(), "Warped Ender Pearl");
        builder.add((Item)ModItems.WITHERED_BONE.value(), "Withered Bone");
        builder.add((Item)ModItems.WITHERED_BONE_MEAL.value(), "Withered Bone Meal");
        builder.add((Item)ModItems.GILDED_NETHERITE_SHIELD.value(), "Gilded Netherite Shield");
        builder.add((Item)ModItems.CUTLASS.value(), "Cutlass");
        builder.add((EntityType)ModEntityTypes.WEX.value(), "Wex");
        builder.add((EntityType)ModEntityTypes.WARPED_ENDERMAN.value(), "Warped Enderman");
        builder.add((EntityType)ModEntityTypes.PIGLIN_PRISONER.value(), "Piglin Prisoner");
        builder.add((EntityType)ModEntityTypes.PIGLIN_HUNTER.value(), "Piglin Hunter");
        builder.add((EntityType)ModEntityTypes.WRAITHER.value(), "Wraither");
        builder.add((EntityType)ModEntityTypes.WITHER_SKELETON_KNIGHT.value(), "Wither Skeleton Knight");
        builder.add((EntityType)ModEntityTypes.CORPOR.value(), "Corpor");
        builder.add((EntityType)ModEntityTypes.WITHER_SKELETON_HORSE.value(), "Withered Skeleton Horse");
        builder.add((EntityType)ModEntityTypes.WARPED_ENDER_PEARL.value(), "Warped Ender Pearl");
        builder.add((SoundEvent)ModSoundEvents.ITEM_SWORD_BLOCK_SOUND_EVENT.value(), "Sword blocks");
        builder.add((SoundEvent)ModSoundEvents.WEX_CHARGE.value(), "Wex shrieks");
        builder.add((SoundEvent)ModSoundEvents.WEX_DEATH.value(), "Wex dies");
        builder.add((SoundEvent)ModSoundEvents.WEX_HURT.value(), "Wex hurts");
        builder.add((SoundEvent)ModSoundEvents.WEX_AMBIENT.value(), "Wex wexes");
        builder.add((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_DEATH.value(), "Warped Enderman dies");
        builder.add((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_HURT.value(), "Warped Enderman hurts");
        builder.add((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_AMBIENT.value(), "Warped Enderman vwoops");
        builder.add((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_TELEPORT.value(), "Warped Enderman teleports");
        builder.add((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_SCREAM.value(), "Warped Enderman screams");
        builder.add((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_STARE.value(), "Warped Enderman cries out");
        builder.add(ModAdvancementProvider.ROOT_ADVANCEMENT.title(), "Eternal Nether");
        builder.add(ModAdvancementProvider.ROOT_ADVANCEMENT.description(), "Explore the Nether for new structures!");
        builder.add(ModAdvancementProvider.ACQUIRE_WITHER_WALTZ_ADVANCEMENT.title(), "Here I Waltz");
        builder.add(ModAdvancementProvider.ACQUIRE_WITHER_WALTZ_ADVANCEMENT.description(), "Acquire the Wither Waltz Music Disc");
        builder.add(ModAdvancementProvider.CATACOMB_ADVANCEMENT.title(), "To Wither Or Not To Wither");
        builder.add(ModAdvancementProvider.CATACOMB_ADVANCEMENT.description(), "Locate a Catacomb structure");
        builder.add(ModAdvancementProvider.CITADEL_ADVANCEMENT.title(), "The Warping Citadel");
        builder.add(ModAdvancementProvider.CITADEL_ADVANCEMENT.description(), "Locate a Citadel structure");
        builder.add(ModAdvancementProvider.EXPLORE_STRUCTURES_ADVANCEMENT.title(), "Hotter Tourist Destinations");
        builder.add(ModAdvancementProvider.EXPLORE_STRUCTURES_ADVANCEMENT.description(), "Locate all Eternal Nether structures");
        builder.add(ModAdvancementProvider.PIGLIN_MANOR_ADVANCEMENT.title(), "Mind Your Manors");
        builder.add(ModAdvancementProvider.PIGLIN_MANOR_ADVANCEMENT.description(), "Locate a Piglin Manor structure");
        builder.add(ModAdvancementProvider.RIDE_WITHER_SKELETON_HORSE_ADVANCEMENT.title(), "Dark Horse");
        builder.add(ModAdvancementProvider.RIDE_WITHER_SKELETON_HORSE_ADVANCEMENT.description(), "Ride a Wither Skeleton Horse");
        builder.add(ModAdvancementProvider.SUMMON_ENDERMAN_ADVANCEMENT.title(), "A Little Off The Top");
        builder.add(ModAdvancementProvider.SUMMON_ENDERMAN_ADVANCEMENT.description(), "Trim the Warp from a Warped Enderman");
        builder.add(ModAdvancementProvider.RESCUE_PIGLIN_PRISONER_ADVANCEMENT.title(), "Saving Private Swine");
        builder.add(ModAdvancementProvider.RESCUE_PIGLIN_PRISONER_ADVANCEMENT.description(), "Rescue a Piglin Prisoner");
    }

    public static BlockFamilyBuilder blockFamily(AbstractLanguageProvider.TranslationBuilder builder, String blockValue) {
        return new BlockFamilyBuilder((arg_0, arg_1) -> ((AbstractLanguageProvider.TranslationBuilder)builder).add(arg_0, arg_1), blockValue);
    }

    public static BlockFamilyBuilder blockFamily(AbstractLanguageProvider.TranslationBuilder builder, String blockValue, String baseBlockValue) {
        return new BlockFamilyBuilder((arg_0, arg_1) -> ((AbstractLanguageProvider.TranslationBuilder)builder).add(arg_0, arg_1), blockValue, baseBlockValue);
    }

    public static class BlockFamilyBuilder {
        private final BiConsumer<Block, String> valueConsumer;
        private final String blockValue;
        private final String baseBlockValue;

        public BlockFamilyBuilder(BiConsumer<Block, String> valueConsumer, String blockValue) {
            this(valueConsumer, blockValue, blockValue);
        }

        public BlockFamilyBuilder(BiConsumer<Block, String> valueConsumer, String blockValue, String baseBlockValue) {
            this.valueConsumer = valueConsumer;
            this.blockValue = blockValue;
            this.baseBlockValue = baseBlockValue;
        }

        public void generateFor(BlockFamily blockFamily) {
            this.baseBlock(blockFamily.getBaseBlock());
            blockFamily.getVariants().forEach((variant, block) -> {
                BiFunction<BlockFamilyBuilder, Block, BlockFamilyBuilder> variantFunction = VARIANT_FUNCTIONS.get(variant);
                if (variantFunction != null) {
                    variantFunction.apply(this, (Block)block);
                }
            });
        }

        public BlockFamilyBuilder baseBlock(Block block) {
            this.valueConsumer.accept(block, this.baseBlockValue);
            return this;
        }

        public BlockFamilyBuilder button(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Button");
            return this;
        }

        public BlockFamilyBuilder chiseled(Block block) {
            this.valueConsumer.accept(block, "Chiseled " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder cracked(Block block) {
            this.valueConsumer.accept(block, "Cracked " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder cut(Block block) {
            this.valueConsumer.accept(block, "Cut " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder door(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Door");
            return this;
        }

        public BlockFamilyBuilder fence(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Fence");
            return this;
        }

        public BlockFamilyBuilder fenceGate(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Fence Gate");
            return this;
        }

        public BlockFamilyBuilder mosaic(Block block) {
            this.valueConsumer.accept(block, "Mosaic " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder sign(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Sign");
            return this;
        }

        public BlockFamilyBuilder slab(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Slab");
            return this;
        }

        public BlockFamilyBuilder stairs(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Stairs");
            return this;
        }

        public BlockFamilyBuilder pressurePlate(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Pressure Plate");
            return this;
        }

        public BlockFamilyBuilder polished(Block block) {
            this.valueConsumer.accept(block, "Polished " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder trapdoor(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Trapdoor");
            return this;
        }

        public BlockFamilyBuilder wall(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Wall");
            return this;
        }

        public BlockFamilyBuilder wallSign(Block block) {
            this.valueConsumer.accept(block, this.blockValue + " Wall Sign");
            return this;
        }
    }
}

