/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster;

import fuzs.eternalnether.EternalNether;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public interface ShieldedMob {
    public static final ResourceLocation SPEED_MODIFIER_BLOCKING_ID = EternalNether.id("blocking");
    public static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(SPEED_MODIFIER_BLOCKING_ID, -0.1, AttributeModifier.Operation.ADD_VALUE);

    public boolean isUsingShield();

    public void setUsingShield(boolean var1);

    public boolean isShieldDisabled();

    public void startUsingShield();

    public void stopUsingShield();

    public static <T extends Mob> void startUsingShield(T mob) {
        if (!((ShieldedMob)mob).isUsingShield() && !((ShieldedMob)mob).isShieldDisabled()) {
            for (InteractionHand interactionHand : InteractionHand.values()) {
                if (!mob.getItemInHand(interactionHand).has(DataComponents.BLOCKS_ATTACKS)) continue;
                mob.startUsingItem(interactionHand);
                ((ShieldedMob)mob).setUsingShield(true);
                AttributeInstance attributeInstance = mob.getAttribute(Attributes.MOVEMENT_SPEED);
                if (attributeInstance == null || attributeInstance.hasModifier(SPEED_MODIFIER_BLOCKING_ID)) continue;
                attributeInstance.addTransientModifier(SPEED_MODIFIER_BLOCKING);
            }
        }
    }

    public static <T extends Mob> void stopUsingShield(T mob) {
        if (((ShieldedMob)mob).isUsingShield()) {
            for (InteractionHand interactionHand : InteractionHand.values()) {
                if (!mob.getItemInHand(interactionHand).has(DataComponents.BLOCKS_ATTACKS)) continue;
                mob.stopUsingItem();
                ((ShieldedMob)mob).setUsingShield(false);
                AttributeInstance attributeinstance = mob.getAttribute(Attributes.MOVEMENT_SPEED);
                if (attributeinstance == null) continue;
                attributeinstance.removeModifier(SPEED_MODIFIER_BLOCKING);
            }
        }
    }
}

