/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import fuzs.eternalnether.init.ModRegistry;
import fuzs.eternalnether.init.ModSoundEvents;
import fuzs.eternalnether.init.ModTags;
import fuzs.puzzleslib.api.network.v4.codec.ExtraStreamCodecs;
import fuzs.puzzleslib.api.util.v1.CodecExtras;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class WarpedEnderman
extends EnderMan
implements Shearable {
    private static final Map<SoundEvent, SoundEvent> SOUND_EVENTS = ImmutableMap.of((Object)SoundEvents.ENDERMAN_AMBIENT, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_AMBIENT.value()), (Object)SoundEvents.ENDERMAN_DEATH, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_DEATH.value()), (Object)SoundEvents.ENDERMAN_HURT, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_HURT.value()), (Object)SoundEvents.ENDERMAN_SCREAM, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_SCREAM.value()), (Object)SoundEvents.ENDERMAN_STARE, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_STARE.value()), (Object)SoundEvents.ENDERMAN_TELEPORT, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_TELEPORT.value()));
    private static final int SHEAR_COOLDOWN = 20;
    private static final EntityDataAccessor<Variant> VARIANT_ID = SynchedEntityData.defineId(WarpedEnderman.class, (EntityDataSerializer)((EntityDataSerializer)ModRegistry.WARPED_ENDER_MAN_VARIANT_ENTITY_DATA_SERIALIZER.value()));
    private int shearCooldownCounter;

    public WarpedEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 55.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 8.5).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT_ID, (Object)Variant.LONG_VINE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void aiStep() {
        super.aiStep();
        if (this.level() instanceof ServerLevel && this.shearCooldownCounter > 0) {
            --this.shearCooldownCounter;
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData spawnGroupData1 = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        this.setVariant(Variant.random(this.random));
        return spawnGroupData1;
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        super.playSound(SOUND_EVENTS.getOrDefault(event, event), volume, pitch);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.store("Variant", Variant.CODEC, (Object)this.getVariant());
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        valueInput.read("Variant", Variant.CODEC).ifPresent(this::setVariant);
    }

    public Variant getVariant() {
        return (Variant)((Object)this.entityData.get(VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.entityData.set(VARIANT_ID, (Object)variant);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionResult) {
        ItemStack itemStack = player.getItemInHand(interactionResult);
        if (itemStack.is(ModTags.SHEAR_TOOLS_ITEM_TAG_KEY) && this.readyForShearing()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.shear(serverLevel, SoundSource.PLAYERS, itemStack);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                itemStack.hurtAndBreak(1, (LivingEntity)player, interactionResult.asEquipmentSlot());
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, interactionResult);
    }

    public void shear(ServerLevel level, SoundSource soundSource, ItemStack shears) {
        level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, soundSource, 1.0f, 1.0f);
        this.dropFromShearingLootTable(level, ModRegistry.SHEARING_WARPED_ENDER_MAN_LOOT_TABLE, shears, (serverLevel, itemStack) -> this.spawnAtLocation((ServerLevel)serverLevel, (ItemStack)itemStack, this.getEyeHeight()));
        this.shearCooldownCounter = 20;
        this.shearWarp(level);
    }

    private void shearWarp(ServerLevel level) {
        switch (this.getVariant().ordinal()) {
            case 0: {
                this.convertTo(EntityType.ENDERMAN, ConversionParams.single((Mob)this, (boolean)false, (boolean)false), enderMan -> level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0));
                break;
            }
            case 1: {
                this.setVariant(Variant.FRESH);
                break;
            }
            case 2: {
                this.setVariant(Variant.SHORT_VINE);
            }
        }
    }

    public boolean readyForShearing() {
        return this.isAlive() && this.shearCooldownCounter == 0;
    }

    public static enum Variant {
        FRESH,
        SHORT_VINE,
        LONG_VINE;

        public static final Codec<Variant> CODEC;
        public static final StreamCodec<ByteBuf, Variant> STREAM_CODEC;
        private static final Variant[] VALUES;

        public static Variant random(RandomSource random) {
            return VALUES[random.nextInt(VALUES.length)];
        }

        static {
            CODEC = CodecExtras.fromEnum(Variant.class);
            STREAM_CODEC = ExtraStreamCodecs.fromEnum(Variant.class);
            VALUES = Variant.values();
        }
    }
}

