/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.level.block.entity;

import fuzs.eternalnether.init.ModBlocks;
import fuzs.eternalnether.init.ModEntityTypes;
import fuzs.eternalnether.world.entity.monster.piglin.PiglinPrisoner;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class NetheriteBellBlockEntity
extends BellBlockEntity
implements TickingBlockEntity {
    public NetheriteBellBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModBlocks.NETHERITE_BELL_BLOCK_ENTITY_TYPE.value();
    }

    public void clientTick() {
        this.tick();
    }

    public void serverTick() {
        if (this.tick()) {
            this.nearbyEntities.stream().filter(this::isPiglinPrisonerWithinRange).forEach(this::rescue);
        }
    }

    private boolean tick() {
        if (this.shaking) {
            ++this.ticks;
        }
        if (this.ticks >= 50) {
            this.shaking = false;
            this.ticks = 0;
        }
        if (this.ticks >= 5 && this.resonationTicks == 0 && this.arePiglinPrisonersNearby(this.getBlockPos(), this.nearbyEntities)) {
            this.resonating = true;
            this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.BELL_RESONATE, SoundSource.BLOCKS, 1.5f, 0.8f);
        }
        if (this.resonating) {
            if (this.resonationTicks < 40) {
                ++this.resonationTicks;
            } else {
                this.resonating = false;
                return true;
            }
        }
        return false;
    }

    protected boolean arePiglinPrisonersNearby(BlockPos pos, List<LivingEntity> livingEntities) {
        for (LivingEntity livingEntity : livingEntities) {
            if (!livingEntity.isAlive() || livingEntity.isRemoved() || !pos.closerToCenterThan((Position)livingEntity.position(), 32.0) || !this.isRescuedPiglinPrisoner(livingEntity)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPiglinPrisonerWithinRange(LivingEntity livingEntity) {
        return livingEntity.isAlive() && !livingEntity.isRemoved() && this.getBlockPos().closerToCenterThan((Position)livingEntity.position(), 48.0) && this.isRescuedPiglinPrisoner(livingEntity);
    }

    private boolean isRescuedPiglinPrisoner(LivingEntity livingEntity) {
        return livingEntity.getType() == ModEntityTypes.PIGLIN_PRISONER.value() && ((PiglinPrisoner)livingEntity).getOwner() != null;
    }

    protected void rescue(LivingEntity livingEntity) {
        livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 300));
        ((PiglinPrisoner)livingEntity).isBeingRescued();
    }
}

