/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.level.levelgen.feature;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MobFeature
extends Feature<NoneFeatureConfiguration> {
    private final WeightedList<Holder<? extends EntityType<? extends Mob>>> entityTypes;

    public MobFeature(Holder<? extends EntityType<? extends Mob>> entityType) {
        this((WeightedList<Holder<? extends EntityType<? extends Mob>>>)WeightedList.of(entityType));
    }

    public MobFeature(WeightedList<Holder<? extends EntityType<? extends Mob>>> entityTypes) {
        super(NoneFeatureConfiguration.CODEC);
        this.entityTypes = entityTypes;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos position = context.origin().below();
        Mob mob = this.entityTypes.getRandom(context.random()).map(Holder::value).map(entityType -> (Mob)entityType.create((Level)context.level().getLevel(), EntitySpawnReason.SPAWNER)).orElse(null);
        if (mob != null) {
            mob.snapTo((double)position.getX() + 0.5, (double)position.getY(), (double)position.getZ() + 0.5, 0.0f, 0.0f);
            mob.finalizeSpawn((ServerLevelAccessor)context.level(), context.level().getCurrentDifficultyAt(position), EntitySpawnReason.SPAWNER, null);
            mob.setPersistenceRequired();
            context.level().addFreshEntity((Entity)mob);
            return true;
        }
        return false;
    }
}

