/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster;

import fuzs.eternalnether.world.entity.ai.goal.ShieldDefenseGoal;
import fuzs.eternalnether.world.entity.monster.ShieldedMob;
import net.minecraft.class_10707;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1588;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_9334;

public class WitherSkeletonKnight
extends class_1639
implements ShieldedMob {
    private static final class_2940<Boolean> DATA_IS_SHIELDED = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_SHIELD_COOLDOWN = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_IS_DISARMORED = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2960 SPEED_MODIFIER_DISARMOURED_ID = class_2960.method_60656((String)"disarmoured");
    private static final class_1322 SPEED_MODIFIER_DISARMOURED = new class_1322(SPEED_MODIFIER_DISARMOURED_ID, (double)0.35f, class_1322.class_1323.field_6331);
    private static final float BREAK_HEALTH_PERCENT = 0.35f;

    public WitherSkeletonKnight(class_1299<? extends class_1639> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23724, 2.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_IS_DISARMORED, (Object)false);
        builder.method_56912(DATA_IS_SHIELDED, (Object)false);
        builder.method_56912(DATA_SHIELD_COOLDOWN, (Object)0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, new ShieldDefenseGoal<WitherSkeletonKnight, class_1657>(this, class_1657.class));
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_73183() instanceof class_3218 && this.getShieldCooldown() > 0) {
            this.setShieldCooldown(this.getShieldCooldown() - 1);
        }
    }

    protected void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71472("Disarmored", this.isDisarmored());
    }

    protected void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.setDisarmored(valueInput.method_71433("Disarmored", false));
    }

    public boolean isDisarmored() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_DISARMORED);
    }

    private void setDisarmored(boolean disarmored) {
        this.field_6011.method_12778(DATA_IS_DISARMORED, (Object)disarmored);
    }

    public void method_5964(class_5819 random, class_1266 difficulty) {
        super.method_5964(random, difficulty);
        this.method_5673(class_1304.field_6171, new class_1799((class_1935)class_1802.field_8255));
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float damageAmount) {
        if (super.method_64397(serverLevel, damageSource, damageAmount)) {
            if (!this.isDisarmored() && this.method_6032() / this.method_6063() < 0.35f) {
                this.setDisarmored(true);
                this.method_5783((class_3414)class_3417.field_15239.comp_349(), 1.2f, 0.8f + serverLevel.method_8409().method_43057() * 0.4f);
                class_1324 attribute = this.method_5996(class_5134.field_23719);
                if (attribute != null && !attribute.method_6196(SPEED_MODIFIER_DISARMOURED_ID)) {
                    attribute.method_26837(SPEED_MODIFIER_DISARMOURED);
                }
            }
            return true;
        }
        return false;
    }

    public void method_6005(double strength, double x, double z) {
        if (!this.isUsingShield()) {
            super.method_6005(strength, x, z);
        } else {
            this.method_5783((class_3414)class_3417.field_15150.comp_349(), 1.0f, 0.8f + this.method_73183().field_9229.method_43057() * 0.4f);
        }
    }

    protected void method_6090(class_3218 level, class_1309 entity) {
        super.method_6090(level, entity);
        class_1799 itemStack = this.method_62821();
        class_10707 blocksAttacks = itemStack != null ? (class_10707)itemStack.method_58694(class_9334.field_56396) : null;
        float secondsToDisableBlocking = entity.method_67125();
        if (secondsToDisableBlocking > 0.0f && blocksAttacks != null) {
            blocksAttacks.method_67200(level, (class_1309)this, secondsToDisableBlocking, itemStack);
            this.disableShield();
        }
    }

    private void disableShield() {
        this.setShieldCooldown(60);
        this.stopUsingShield();
        this.method_73183().method_8421((class_1297)this, (byte)30);
        this.method_5783((class_3414)class_3417.field_15239.comp_349(), 0.8f, 0.8f + this.method_73183().field_9229.method_43057() * 0.4f);
    }

    @Override
    public boolean isShieldDisabled() {
        return this.getShieldCooldown() > 0;
    }

    @Override
    public void startUsingShield() {
        ShieldedMob.startUsingShield(this);
    }

    @Override
    public void stopUsingShield() {
        ShieldedMob.stopUsingShield(this);
    }

    @Override
    public boolean isUsingShield() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_SHIELDED);
    }

    @Override
    public void setUsingShield(boolean isShielded) {
        this.field_6011.method_12778(DATA_IS_SHIELDED, (Object)isShielded);
    }

    private int getShieldCooldown() {
        return (Integer)this.field_6011.method_12789(DATA_SHIELD_COOLDOWN);
    }

    private void setShieldCooldown(int shieldCooldown) {
        this.field_6011.method_12778(DATA_SHIELD_COOLDOWN, (Object)Math.max(0, shieldCooldown));
    }
}

