/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster.piglin;

import fuzs.eternalnether.init.ModItems;
import fuzs.eternalnether.world.entity.ai.goal.ShieldDefenseGoal;
import fuzs.eternalnether.world.entity.monster.ShieldedMob;
import fuzs.eternalnether.world.entity.monster.piglin.CrossbowAttackPiglin;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5418;
import net.minecraft.class_5819;
import net.minecraft.class_9334;

public class PiglinHunter
extends CrossbowAttackPiglin
implements ShieldedMob {
    private static final class_2940<Boolean> DATA_IS_SHIELDED = class_2945.method_12791(PiglinHunter.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_SHIELD_COOLDOWN = class_2945.method_12791(PiglinHunter.class, (class_2941)class_2943.field_13327);
    private static final float SHIELD_BASE_PROBABILITY = 0.35f;
    private static final float GILDED_SHIELD_PROBABILITY = 0.05f;

    public PiglinHunter(class_1299<? extends class_5418> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_IS_SHIELDED, (Object)false);
        builder.method_56912(DATA_SHIELD_COOLDOWN, (Object)0);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(2, new ShieldDefenseGoal<PiglinHunter, class_1657>(this, class_1657.class));
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_73183() instanceof class_3218 && this.getShieldCooldown() > 0) {
            this.setShieldCooldown(this.getShieldCooldown() - 1);
        }
    }

    @Override
    public void method_5964(class_5819 random, class_1266 difficulty) {
        super.method_5964(random, difficulty);
        if (this.method_6047().method_57826(class_9334.field_55878) && this.field_5974.method_43057() < 0.35f + 0.35f * difficulty.method_5458()) {
            this.method_5673(class_1304.field_6171, this.createShieldWeapon(random));
            this.method_5946(class_1304.field_6171, 0.0f);
        }
    }

    private class_1799 createShieldWeapon(class_5819 random) {
        return random.method_43057() < 0.05f ? new class_1799(ModItems.GILDED_NETHERITE_SHIELD) : new class_1799((class_1935)class_1802.field_8255);
    }

    public void method_6005(double strength, double x, double z) {
        if (!this.isUsingShield()) {
            super.method_6005(strength, x, z);
        } else {
            this.method_5783((class_3414)class_3417.field_15150.comp_349(), 1.0f, 0.8f + this.method_73183().field_9229.method_43057() * 0.4f);
        }
    }

    @Override
    public boolean isShieldDisabled() {
        return false;
    }

    @Override
    public void startUsingShield() {
        ShieldedMob.startUsingShield(this);
    }

    @Override
    public void stopUsingShield() {
        ShieldedMob.stopUsingShield(this);
    }

    @Override
    public boolean isUsingShield() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_SHIELDED);
    }

    @Override
    public void setUsingShield(boolean isShielded) {
        this.field_6011.method_12778(DATA_IS_SHIELDED, (Object)isShielded);
    }

    private int getShieldCooldown() {
        return (Integer)this.field_6011.method_12789(DATA_SHIELD_COOLDOWN);
    }

    private void setShieldCooldown(int shieldCooldown) {
        this.field_6011.method_12778(DATA_SHIELD_COOLDOWN, (Object)Math.max(0, shieldCooldown));
    }
}

