/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster.piglin;

import fuzs.eternalnether.init.ModFeatures;
import fuzs.eternalnether.init.ModItems;
import fuzs.eternalnether.world.entity.ai.goal.FollowOwnerGoal;
import fuzs.eternalnether.world.entity.monster.piglin.GoalBasedPiglin;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10179;
import net.minecraft.class_10583;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1358;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_4215;
import net.minecraft.class_4837;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_5425;
import net.minecraft.class_5534;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class PiglinPrisoner
extends GoalBasedPiglin
implements class_6025 {
    private static final class_2940<Optional<class_10583<class_1309>>> DATA_OWNERUUID_ID = class_2945.method_12791(PiglinPrisoner.class, (class_2941)class_2943.field_55584);
    private static final int RESCUE_TIME = 75;
    private int timeBeingRescued;
    private boolean isBeingRescued;
    private int admiringItem;

    public PiglinPrisoner(class_1299<? extends class_5418> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.35).method_26868(class_5134.field_23721, 6.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(6, new FollowOwnerGoal<PiglinPrisoner>(this, 1.0, 10.0f, 2.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1358((class_1308)this, class_1657.class, 3.0f, 1.0f));
    }

    public void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71465("TimeBeingRescued", this.timeBeingRescued);
        valueOutput.method_71472("IsBeingRescued", this.isBeingRescued);
        class_10583.method_71612(this.method_66287(), (class_11372)valueOutput, (String)"Owner");
    }

    public void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.timeBeingRescued = valueInput.method_71424("TimeBeingRescued", 0);
        this.isBeingRescued = valueInput.method_71433("IsBeingRescued", false);
        this.setOwnerReference((class_10583<class_1309>)class_10583.method_66262((class_11368)valueInput, (String)"Owner"));
    }

    protected void method_5958(class_3218 serverLevel) {
        super.method_5958(serverLevel);
        if (this.admiringItem > 0 && --this.admiringItem == 0) {
            this.stopHoldingOffHandItem(serverLevel);
        }
        this.timeBeingRescued = this.isBeingRescued ? ++this.timeBeingRescued : 0;
        if (this.timeBeingRescued > 75) {
            this.method_30238();
            this.throwItems(Collections.singletonList(new class_1799(ModItems.GILDED_NETHERITE_SHIELD)));
            ModFeatures.PIGLIN_PRISONER_CONVERSIONS.method_34992(this.field_5974).map(class_6880::comp_349).ifPresent(entityType -> this.finishRescue(serverLevel, (class_1299<? extends class_1308>)entityType));
        }
    }

    private void finishRescue(class_3218 serverLevel, class_1299<? extends class_1308> entityType) {
        this.method_29243(entityType, class_10179.method_63607((class_1308)this, (boolean)false, (boolean)false), mob -> {
            mob.method_5943((class_5425)serverLevel, serverLevel.method_8404(mob.method_24515()), class_3730.field_16468, null);
            mob.method_5971();
            mob.method_6012();
            mob.method_6092(new class_1293(class_1294.field_5916, 200));
        });
    }

    public void stopHoldingOffHandItem(class_3218 serverLevel) {
        class_1799 itemInHand = this.method_5998(class_1268.field_5810);
        this.method_6122(class_1268.field_5810, class_1799.field_8037);
        if (EntityHelper.isPiglinCurrency((class_1799)itemInHand)) {
            this.method_6092(new class_1293(class_1294.field_5898, 600, 3));
            this.method_6092(new class_1293(class_1294.field_5924, 200, 1));
        } else if (this.method_24523(serverLevel, itemInHand).method_7960()) {
            this.throwItems(Collections.singletonList(itemInHand));
        }
    }

    private void throwItems(List<class_1799> stacks) {
        class_1657 player = this.getOwner();
        if (player != null) {
            this.throwItemsTowardPlayer(player, stacks);
        } else {
            this.throwItemsTowardRandomPos(stacks);
        }
    }

    private void throwItemsTowardRandomPos(List<class_1799> stacks) {
        this.throwItemsTowardPos(stacks, this.getRandomNearbyPos());
    }

    private void throwItemsTowardPlayer(class_1657 player, List<class_1799> stacks) {
        this.throwItemsTowardPos(stacks, player.method_73189());
    }

    private void throwItemsTowardPos(List<class_1799> stacks, class_243 pos) {
        if (!stacks.isEmpty()) {
            this.method_6104(class_1268.field_5810);
            for (class_1799 itemStack : stacks) {
                class_4215.method_19949((class_1309)this, (class_1799)itemStack, (class_243)pos.method_1031(0.0, 1.0, 0.0));
            }
        }
    }

    private class_243 getRandomNearbyPos() {
        class_243 vec3 = class_5534.method_31527((class_1314)this, (int)4, (int)2);
        return vec3 == null ? this.method_73189() : vec3;
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1269 interactionresult = super.method_5992(player, interactionHand);
        if (interactionresult.method_23665()) {
            return interactionresult;
        }
        class_1799 itemInHand = player.method_5998(interactionHand);
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.canAdmire(itemInHand)) {
                this.holdInOffhand(serverLevel, itemInHand.method_7971(1));
                this.setOwner(player);
                this.admireGoldItem();
                this.stopWalking();
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        }
        if (this.canAdmire(itemInHand) && this.method_24705() != class_4837.field_22385) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void holdInOffhand(class_3218 serverLevel, class_1799 itemStack) {
        if (!this.method_6079().method_7960()) {
            this.method_5775(serverLevel, this.method_5998(class_1268.field_5810));
        }
        this.method_24834(class_1304.field_6171, itemStack);
    }

    private void admireGoldItem() {
        this.admiringItem = 120;
    }

    private void stopWalking() {
        this.method_5942().method_6340();
    }

    public boolean canAdmire(class_1799 itemStack) {
        return !this.isAdmiringItem() && this.method_30236() && EntityHelper.isPiglinCurrency((class_1799)itemStack);
    }

    public boolean isAdmiringItem() {
        return this.admiringItem > 0;
    }

    public void cancelAdmiring(class_3218 serverLevel) {
        if (this.isAdmiringItem() && !this.method_6079().method_7960()) {
            this.method_5775(serverLevel, this.method_6079());
            this.method_6122(class_1268.field_5810, class_1799.field_8037);
        }
    }

    public void isBeingRescued() {
        this.isBeingRescued = true;
    }

    protected void method_24694(class_3218 serverLevel) {
        this.cancelAdmiring(serverLevel);
        super.method_24694(serverLevel);
    }

    @Override
    public class_4837 method_24705() {
        return EntityHelper.isPiglinCurrency((class_1799)this.method_6079()) ? class_4837.field_22385 : super.method_24705();
    }

    public boolean method_5939(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_24481);
    }

    @Nullable
    public class_1657 getOwner() {
        return (class_1657)super.method_35057();
    }

    @Nullable
    public class_10583<class_1309> method_66287() {
        return ((Optional)this.field_6011.method_12789(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwner(@Nullable class_1657 player) {
        this.field_6011.method_12778(DATA_OWNERUUID_ID, Optional.ofNullable(player).map(class_10583::method_73299));
    }

    private void setOwnerReference(@Nullable class_10583<class_1309> owner) {
        this.field_6011.method_12778(DATA_OWNERUUID_ID, Optional.ofNullable(owner));
    }
}

