/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.apricot.util.digger;

import com.github.cao.awa.apricot.annotations.Stable;
import com.github.cao.awa.lilium.mathematic.Mathematics;
import com.github.cao.awa.sinuatum.manipulate.Manipulate;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

@Stable
public class MessageDigger {
    private static final int BUF_SIZE = 16384;

    public static String digest(byte[] message, DigestAlgorithm sha) {
        MessageDigest digest = sha.instance();
        if (digest == null) {
            return null;
        }
        digest.update(message);
        StringBuilder result = new StringBuilder();
        MessageDigger.digest(digest, result);
        return result.toString();
    }

    public static String digest(String message, DigestAlgorithm sha) {
        return MessageDigger.digest(message.getBytes(StandardCharsets.UTF_8), sha);
    }

    public static byte[] digestBytes(byte[] message, DigestAlgorithm algorithm) {
        MessageDigest digest = Manipulate.supply(() -> MessageDigest.getInstance(algorithm.instanceName()));
        if (digest == null) {
            return null;
        }
        digest.update(message);
        return digest.digest();
    }

    public static byte[] digestToBytes(byte[] message, DigestAlgorithm sha) {
        return MessageDigger.digestBytes(message, sha);
    }

    public static byte[] digestFileToBytes(File file, DigestAlgorithm sha) throws Exception {
        return Mathematics.toBytes(MessageDigger.digestFile(file, sha), 16);
    }

    public static String digestFile(File file, DigestAlgorithm sha) throws Exception {
        int length;
        if (!file.isFile()) {
            return "0";
        }
        RandomAccessFile accessFile = new RandomAccessFile(file, "r");
        MessageDigest digest = MessageDigest.getInstance(sha.instanceName());
        byte[] buffer = new byte[16384];
        long offset = accessFile.length();
        for (long read = 0L; read < offset; read += (long)length) {
            length = (int)(offset - read < 16384L ? offset - read : 16384L);
            accessFile.read(buffer, 0, length);
            digest.update(buffer, 0, length);
        }
        accessFile.close();
        StringBuilder result = new StringBuilder();
        MessageDigger.digest(digest, result);
        return result.toString();
    }

    private static void digest(MessageDigest digest, StringBuilder result) {
        for (byte b : digest.digest()) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() < 2) {
                result.append(0);
            }
            result.append(hex);
        }
    }

    public static interface DigestAlgorithm {
        public String instanceName();

        public MessageDigest instance();
    }

    public static interface MD
    extends DigestAlgorithm {
    }

    public static interface Sha
    extends DigestAlgorithm {
    }

    public static enum Sha3 implements Sha
    {
        SHA_224("SHA-224"),
        SHA_256("SHA-256"),
        SHA_512("SHA-512");

        private final String instance;
        private final MessageDigest digestInstance;

        private Sha3(String instance) {
            this.instance = instance;
            this.digestInstance = Manipulate.supply(() -> MessageDigest.getInstance(instance));
        }

        @Override
        public String instanceName() {
            return this.instance;
        }

        @Override
        public MessageDigest instance() {
            return this.digestInstance;
        }
    }

    @Deprecated
    public static enum Sha1 implements Sha
    {
        SHA("SHA-1");

        private final String instance;
        private final MessageDigest digestInstance;

        private Sha1(String instance) {
            this.instance = instance;
            this.digestInstance = Manipulate.supply(() -> MessageDigest.getInstance(instance));
        }

        @Override
        public String instanceName() {
            return this.instance;
        }

        @Override
        public MessageDigest instance() {
            return this.digestInstance;
        }
    }
}

