/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.catheter;

import com.github.cao.awa.catheter.BooleanCatheter;
import com.github.cao.awa.catheter.ByteCatheter;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.catheter.DoubleCatheter;
import com.github.cao.awa.catheter.LongCatheter;
import com.github.cao.awa.catheter.action.BiIntegerConsumer;
import com.github.cao.awa.catheter.action.BiIntegerPredicate;
import com.github.cao.awa.catheter.action.BiIntegerToIntegerFunction;
import com.github.cao.awa.catheter.action.BooleanConsumer;
import com.github.cao.awa.catheter.action.IntegerArrayFunction;
import com.github.cao.awa.catheter.action.IntegerToByteFunction;
import com.github.cao.awa.catheter.action.TriIntegerPredicate;
import com.github.cao.awa.catheter.action.TriIntegerToIntegerFunction;
import com.github.cao.awa.catheter.matrix.MatrixFlockPos;
import com.github.cao.awa.catheter.matrix.MatrixPos;
import com.github.cao.awa.catheter.pair.IntegerPair;
import com.github.cao.awa.catheter.receptacle.BooleanReceptacle;
import com.github.cao.awa.catheter.receptacle.IntegerReceptacle;
import com.github.cao.awa.catheter.receptacle.Receptacle;
import com.github.cao.awa.sinuatum.function.QuinFunction;
import com.github.cao.awa.sinuatum.function.TriFunction;
import com.github.cao.awa.sinuatum.function.consumer.TriConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import java.util.stream.IntStream;

public class IntCatheter {
    private static final Random RANDOM = new Random();
    private int[] targets;

    public IntCatheter(int[] targets) {
        this.targets = targets;
    }

    public static IntCatheter make(int ... targets) {
        return new IntCatheter(targets);
    }

    public static IntCatheter makeCapacity(int size) {
        return new IntCatheter(IntCatheter.array(size));
    }

    public static <X> IntCatheter of(int[] targets) {
        return new IntCatheter(targets);
    }

    public static IntCatheter of(Collection<Integer> targets) {
        if (targets == null) {
            return new IntCatheter(IntCatheter.array(0));
        }
        int[] delegate = new int[targets.size()];
        int index = 0;
        for (int target : targets) {
            delegate[index++] = target;
        }
        return new IntCatheter(delegate);
    }

    public IntCatheter each(IntConsumer action) {
        int[] ts;
        for (int i : ts = this.targets) {
            action.accept(i);
        }
        return this;
    }

    public IntCatheter each(IntConsumer action, Runnable poster) {
        this.each(action);
        poster.run();
        return this;
    }

    public <X> IntCatheter each(X initializer, BiConsumer<X, Integer> action) {
        int[] ts;
        for (int i : ts = this.targets) {
            action.accept(initializer, i);
        }
        return this;
    }

    public <X> IntCatheter each(X initializer, BiConsumer<X, Integer> action, Consumer<X> poster) {
        this.each(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public <X> IntCatheter overall(X initializer, TriConsumer<X, Integer, Integer> action) {
        int[] ts = this.targets;
        int index = 0;
        for (int i : ts) {
            action.accept(initializer, index++, i);
        }
        return this;
    }

    public <X> IntCatheter overall(X initializer, TriConsumer<X, Integer, Integer> action, Consumer<X> poster) {
        this.overall(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public IntCatheter overall(BiIntegerConsumer action) {
        int[] ts = this.targets;
        int index = 0;
        for (int i : ts) {
            action.accept(index++, i);
        }
        return this;
    }

    public IntCatheter overall(BiIntegerConsumer action, Runnable poster) {
        this.overall(action);
        poster.run();
        return this;
    }

    public IntCatheter insert(TriIntegerToIntegerFunction maker) {
        HashMap indexes = new HashMap();
        IntegerReceptacle lastItem = new IntegerReceptacle(0);
        this.overall((index, item) -> {
            indexes.put(index + indexes.size(), new IntegerPair(index, maker.apply(index, item, lastItem.get())));
            lastItem.set(item);
        });
        int[] ts = this.targets;
        int[] newDelegate = IntCatheter.array(ts.length + indexes.size());
        IntegerReceptacle lastIndex = new IntegerReceptacle(0);
        IntegerReceptacle lastDest = new IntegerReceptacle(0);
        IntCatheter.of(indexes.keySet()).sort().each(index -> {
            if (lastIndex.get() != index) {
                int maxCopyLength = Math.min(newDelegate.length - lastDest.get() - 1, index - lastIndex.get());
                System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), maxCopyLength);
            }
            IntegerPair item = (IntegerPair)indexes.get(index);
            newDelegate[index] = item.second();
            lastIndex.set(item.first());
            lastDest.set(index + 1);
        }, () -> System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), newDelegate.length - lastDest.get()));
        this.targets = newDelegate;
        return this;
    }

    public IntCatheter pluck(TriIntegerPredicate maker) {
        IntegerReceptacle lastItem = new IntegerReceptacle(0);
        return this.overallFilter((index, item) -> {
            if (maker.test(index, item, lastItem.get())) {
                return false;
            }
            lastItem.set(item);
            return true;
        });
    }

    public IntCatheter discardTo(IntPredicate predicate) {
        IntCatheter result = IntCatheter.make(new int[0]);
        this.overallFilter((index, item) -> !predicate.test(item), result::reset);
        return result;
    }

    public <X> IntCatheter discardTo(Predicate<X> predicate, IntFunction<X> converter) {
        IntCatheter result = IntCatheter.make(new int[0]);
        this.overallFilter((index, item) -> !predicate.test(converter.apply(item)), result::reset);
        return result;
    }

    public IntCatheter discardTo(int initializer, BiIntegerPredicate predicate) {
        IntCatheter result = IntCatheter.make(new int[0]);
        this.overallFilter((index, item) -> !predicate.test(item, initializer), result::reset);
        return result;
    }

    public IntCatheter orDiscardTo(boolean succeed, IntPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate);
    }

    public <X> IntCatheter orDiscardTo(boolean succeed, Predicate<X> predicate, IntFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate, converter);
    }

    public IntCatheter orDiscardTo(boolean succeed, int initializer, BiIntegerPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(initializer, predicate);
    }

    public IntCatheter discard(IntPredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item));
    }

    public <X> IntCatheter discard(Predicate<X> predicate, IntFunction<X> converter) {
        return this.overallFilter((index, item) -> !predicate.test(converter.apply(item)));
    }

    public IntCatheter discard(int initializer, BiIntegerPredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item, initializer));
    }

    public IntCatheter orDiscard(boolean succeed, IntPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate);
    }

    public <X> IntCatheter orDiscard(boolean succeed, Predicate<X> predicate, IntFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate, converter);
    }

    public IntCatheter orDiscard(boolean succeed, int initializer, BiIntegerPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(initializer, predicate);
    }

    public IntCatheter filterTo(IntPredicate predicate) {
        return this.dump().filter(predicate);
    }

    public <X> IntCatheter filterTo(Predicate<X> predicate, IntFunction<X> converter) {
        return this.dump().filter(predicate, converter);
    }

    public IntCatheter filterTo(int initializer, BiIntegerPredicate predicate) {
        return this.dump().filter(initializer, predicate);
    }

    public IntCatheter orFilterTo(boolean succeed, IntPredicate predicate) {
        return this.dump().orFilter(succeed, predicate);
    }

    public <X> IntCatheter orFilterTo(boolean succeed, Predicate<X> predicate, IntFunction<X> converter) {
        return this.dump().orFilter(succeed, predicate, converter);
    }

    public IntCatheter orFilterTo(boolean succeed, int initializer, BiIntegerPredicate predicate) {
        return this.dump().orFilter(succeed, initializer, predicate);
    }

    public IntCatheter filter(IntPredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item));
    }

    public <X> IntCatheter filter(Predicate<X> predicate, IntFunction<X> converter) {
        return this.overallFilter((index, item) -> predicate.test(converter.apply(item)));
    }

    public IntCatheter filter(int initializer, BiIntegerPredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item, initializer));
    }

    public IntCatheter orFilter(boolean succeed, IntPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate);
    }

    public <X> IntCatheter orFilter(boolean succeed, Predicate<X> predicate, IntFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate, converter);
    }

    public IntCatheter orFilter(boolean succeed, int initializer, BiIntegerPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(initializer, predicate);
    }

    public IntCatheter overallFilter(BiIntegerPredicate predicate) {
        return this.overallFilter(predicate, (int[] x) -> {});
    }

    public IntCatheter overallFilter(BiIntegerPredicate predicate, Consumer<int[]> discarding) {
        if (this.isEmpty()) {
            return this;
        }
        int[] ts = this.targets;
        int length = ts.length;
        boolean[] deleting = new boolean[length];
        int newDelegateSize = length;
        int index = 0;
        for (int target : ts) {
            if (predicate.test(index, target)) {
                ++index;
                continue;
            }
            deleting[index++] = true;
            --newDelegateSize;
        }
        int[] newDelegate = IntCatheter.array(newDelegateSize);
        int[] discardingDelegate = IntCatheter.array(length - newDelegateSize);
        int discardingDelegateIndex = 0;
        int newDelegateIndex = 0;
        index = 0;
        for (boolean isDeleting : deleting) {
            int t = ts[index++];
            if (isDeleting) {
                discardingDelegate[discardingDelegateIndex++] = t;
                continue;
            }
            newDelegate[newDelegateIndex++] = t;
        }
        discarding.accept(discardingDelegate);
        this.targets = newDelegate;
        return this;
    }

    public IntCatheter overallFilter(int initializer, TriIntegerPredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(index, item, initializer));
    }

    public boolean isPresent() {
        return this.count() > 0;
    }

    public IntCatheter ifPresent(Consumer<IntCatheter> action) {
        if (this.count() > 0) {
            action.accept(this);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public IntCatheter ifEmpty(Consumer<IntCatheter> action) {
        if (this.count() == 0) {
            action.accept(this);
        }
        return this;
    }

    public IntCatheter removeWithIndex(int index) {
        if (this.isEmpty() || index >= this.count() || index < 0) {
            return this;
        }
        int[] newDelegate = IntCatheter.array(this.count() - 1);
        if (index > 0) {
            System.arraycopy(this.targets, 0, newDelegate, 0, index);
        }
        System.arraycopy(this.targets, index + 1, newDelegate, index, this.count() - 1 - index);
        this.targets = newDelegate;
        return this;
    }

    public IntCatheter distinct() {
        HashMap map = new HashMap();
        return this.filter(item -> {
            if (map.getOrDefault(item, false).booleanValue()) {
                return false;
            }
            map.put(item, true);
            return true;
        });
    }

    public IntCatheter sort() {
        Arrays.sort(this.targets);
        return this;
    }

    public IntCatheter sort(Comparator<Integer> comparator) {
        Integer[] array = new Integer[this.targets.length];
        int index = 0;
        for (int target : this.targets) {
            array[index++] = target;
        }
        Arrays.sort(array, comparator);
        index = 0;
        Integer[] integerArray = array;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int target;
            target = integerArray[i];
            this.targets[index++] = target;
        }
        return this;
    }

    public IntCatheter holdTill(int index) {
        if (this.isEmpty()) {
            return this;
        }
        index = Math.min(index, this.targets.length);
        int[] ts = this.targets;
        int[] newDelegate = IntCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public IntCatheter holdTill(IntPredicate predicate) {
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        int[] ts = this.targets;
        int[] newDelegate = IntCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public IntCatheter whenFlock(int source, BiIntegerToIntegerFunction maker, IntConsumer consumer) {
        consumer.accept(this.flock(source, maker));
        return this;
    }

    public IntCatheter whenFlock(BiIntegerToIntegerFunction maker, IntConsumer consumer) {
        consumer.accept(this.flock(maker));
        return this;
    }

    public int flock(int source, BiIntegerToIntegerFunction maker) {
        int[] ts = this.targets;
        int result = source;
        for (int i : ts) {
            result = maker.applyAsInt(result, i);
        }
        return result;
    }

    public int flock(BiIntegerToIntegerFunction maker) {
        int[] ts = this.targets;
        int length = ts.length;
        int result = length > 0 ? ts[0] : 0;
        for (int i : ts) {
            result = maker.applyAsInt(result, i);
        }
        return result;
    }

    public <X> X alternate(X source, BiFunction<X, Integer, X> maker) {
        int[] ts = this.targets;
        X result = source;
        for (int i : ts) {
            result = maker.apply(result, i);
        }
        return result;
    }

    public <X> IntCatheter whenAlternate(X source, BiFunction<X, Integer, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public <X> IntCatheter whenAlternate(BiFunction<X, Integer, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(null, maker));
        return this;
    }

    public boolean alternate(boolean source, BiIntegerPredicate maker) {
        BooleanReceptacle result = new BooleanReceptacle(source);
        this.flock((older, newer) -> {
            result.and(maker.test(older, newer));
            return newer;
        });
        return result.get();
    }

    public IntCatheter whenAlternate(boolean source, BiIntegerPredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public IntCatheter whenAlternate(BiIntegerPredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(false, maker));
        return this;
    }

    public IntCatheter waiveTill(int index) {
        int[] newDelegate;
        if (this.isEmpty()) {
            return this;
        }
        int[] ts = this.targets;
        if (index >= ts.length) {
            newDelegate = IntCatheter.array(0);
        } else {
            newDelegate = IntCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public IntCatheter waiveTill(IntPredicate predicate) {
        int[] newDelegate;
        int[] ts;
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        if (index >= (ts = this.targets).length) {
            newDelegate = IntCatheter.array(0);
        } else {
            newDelegate = IntCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public IntCatheter till(IntPredicate predicate) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (predicate.test(i)) break;
        }
        return this;
    }

    public int findTill(IntPredicate predicate) {
        int[] ts = this.targets;
        int index = 0;
        for (int i : ts) {
            if (predicate.test(i)) break;
            ++index;
        }
        return index;
    }

    public IntCatheter replace(IntUnaryOperator handler) {
        if (this.isEmpty()) {
            return this;
        }
        int[] ts = this.targets;
        int index = 0;
        for (int i : ts) {
            ts[index++] = handler.applyAsInt(i);
        }
        return this;
    }

    public ByteCatheter vary(IntegerToByteFunction handler) {
        if (this.isEmpty()) {
            return ByteCatheter.make(new byte[0]);
        }
        int[] ts = this.targets;
        byte[] array = new byte[ts.length];
        int index = 0;
        for (int i : ts) {
            array[index++] = handler.applyAsByte(i);
        }
        return ByteCatheter.of(array);
    }

    public BooleanCatheter vary(IntPredicate handler) {
        if (this.isEmpty()) {
            return BooleanCatheter.make(new boolean[0]);
        }
        int[] ts = this.targets;
        boolean[] array = new boolean[ts.length];
        int index = 0;
        for (int i : ts) {
            array[index++] = handler.test(i);
        }
        return BooleanCatheter.of(array);
    }

    public DoubleCatheter vary(IntToDoubleFunction handler) {
        if (this.isEmpty()) {
            return DoubleCatheter.make(new double[0]);
        }
        int[] ts = this.targets;
        double[] array = new double[ts.length];
        int index = 0;
        for (int i : ts) {
            array[index++] = handler.applyAsDouble(i);
        }
        return DoubleCatheter.of(array);
    }

    public IntCatheter vary(IntUnaryOperator handler) {
        return this.replace(handler);
    }

    public LongCatheter vary(IntToLongFunction handler) {
        if (this.isEmpty()) {
            return LongCatheter.make(new long[0]);
        }
        int[] ts = this.targets;
        long[] array = new long[ts.length];
        int index = 0;
        for (int i : ts) {
            array[index++] = handler.applyAsLong(i);
        }
        return LongCatheter.of(array);
    }

    public <X> Catheter<X> vary(IntFunction<X> handler) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        int[] ts = this.targets;
        X[] array = IntCatheter.xArray(ts.length);
        int index = 0;
        for (int i : ts) {
            array[index++] = handler.apply(i);
        }
        return Catheter.of(array);
    }

    public <X> Catheter<X> vary(IntFunction<X> handler, IntFunction<X[]> arrayGenerator) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        int[] ts = this.targets;
        X[] array = arrayGenerator.apply(ts.length);
        int index = 0;
        for (int i : ts) {
            array[index++] = handler.apply(i);
        }
        return Catheter.of(array).arrayGenerator(arrayGenerator);
    }

    public IntCatheter whenAny(IntPredicate predicate, IntConsumer action) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (!predicate.test(i)) continue;
            action.accept(i);
            break;
        }
        return this;
    }

    public IntCatheter whenAll(IntPredicate predicate, Runnable action) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (predicate.test(i)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public IntCatheter whenAll(IntPredicate predicate, IntConsumer action) {
        return this.whenAll(predicate, () -> this.each(action));
    }

    private IntCatheter whenNone(IntPredicate predicate, Runnable action) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (!predicate.test(i)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public boolean hasAny(IntPredicate predicate) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (!predicate.test(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAll(IntPredicate predicate) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (predicate.test(i)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNone(IntPredicate predicate) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (!predicate.test(i)) continue;
            return false;
        }
        return true;
    }

    public int findFirst(IntPredicate predicate) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (!predicate.test(i)) continue;
            return i;
        }
        return 0;
    }

    public int findLast(IntPredicate predicate) {
        int[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            int t;
            if (!predicate.test(t = ts[index--])) continue;
            return t;
        }
        return 0;
    }

    public <X> X whenFoundFirst(IntPredicate predicate, IntFunction<X> function) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (!predicate.test(i)) continue;
            return function.apply(i);
        }
        return null;
    }

    public <X> X whenFoundLast(IntPredicate predicate, IntFunction<X> function) {
        int[] ts;
        for (int i : ts = this.targets) {
            if (!predicate.test(i)) continue;
            return function.apply(i);
        }
        return null;
    }

    public IntCatheter any(IntConsumer consumer) {
        if (this.targets.length > 0) {
            int[] ls = this.targets;
            int index = RANDOM.nextInt(ls.length);
            consumer.accept(ls.length > index ? ls[index] : ls[ls.length - 1]);
        }
        return this;
    }

    public IntCatheter first(IntConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[0]);
        }
        return this;
    }

    public IntCatheter tail(IntConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[this.targets.length - 1]);
        }
        return this;
    }

    public IntCatheter reverse() {
        if (this.isEmpty()) {
            return this;
        }
        int[] ts = this.targets;
        int length = ts.length;
        int split = length / 2;
        for (int index = 0; index < split; ++index) {
            int swapIndex = length - index - 1;
            int temp = ts[index];
            ts[index] = ts[swapIndex];
            ts[swapIndex] = temp;
        }
        return this;
    }

    public int max(Comparator<Integer> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result);
    }

    public int min(Comparator<Integer> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result);
    }

    public IntCatheter whenMax(Comparator<Integer> comparator, IntConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result));
        return this;
    }

    public IntCatheter whenMin(Comparator<Integer> comparator, IntConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result));
        return this;
    }

    public int count() {
        return this.targets.length;
    }

    public IntCatheter count(AtomicInteger target) {
        target.set(this.count());
        return this;
    }

    public IntCatheter count(Receptacle<Integer> target) {
        target.set(this.count());
        return this;
    }

    public IntCatheter count(IntConsumer consumer) {
        consumer.accept(this.count());
        return this;
    }

    public final IntCatheter append(int ... objects) {
        int[] ts = this.targets;
        int[] newDelegate = IntCatheter.array(ts.length + objects.length);
        System.arraycopy(ts, 0, newDelegate, 0, ts.length);
        System.arraycopy(objects, 0, newDelegate, ts.length, objects.length);
        this.targets = newDelegate;
        return this;
    }

    public IntCatheter append(IntCatheter objects) {
        return this.append(objects.array());
    }

    public IntCatheter repeat(int count) {
        int[] ts = this.array();
        for (int i = 0; i < count; ++i) {
            this.append(ts);
        }
        return this;
    }

    public int fetch(int index) {
        return this.targets[Math.min(index, this.targets.length - 1)];
    }

    public void fetch(int index, int item) {
        this.targets[index] = item;
    }

    public IntCatheter matrixEach(int width, BiConsumer<MatrixPos, Integer> action) {
        return this.matrixReplace(width, (pos, item) -> {
            action.accept((MatrixPos)pos, (Integer)item);
            return item;
        });
    }

    public <X> Catheter<X> matrixHomoVary(int width, IntCatheter input, TriFunction<MatrixPos, Integer, Integer, X> action) {
        if (input.count() == this.count()) {
            IntegerReceptacle index = new IntegerReceptacle(0);
            return this.matrixVary(width, (pos, item) -> {
                int indexValue = index.get();
                int inputX = input.fetch(indexValue);
                Object result = action.apply((MatrixPos)pos, (Integer)item, inputX);
                index.set(indexValue + 1);
                return result;
            });
        }
        throw new IllegalArgumentException("The matrix is not homogeneous matrix");
    }

    public IntCatheter matrixMap(int width, int inputWidth, IntCatheter input, QuinFunction<MatrixFlockPos, MatrixPos, MatrixPos, Integer, Integer, Integer> scanFlocked, TriFunction<MatrixPos, Integer, Integer, Integer> combineFlocked) {
        int sourceHeight;
        boolean homoMatrix;
        int inputHeight = input.count() / inputWidth;
        boolean bl = homoMatrix = inputHeight == (sourceHeight = this.count() / width) && width == inputWidth;
        if (width != inputHeight && !homoMatrix) {
            throw new IllegalArgumentException("The matrix cannot be constructed because input height does not match to source width");
        }
        IntCatheter newMatrix = IntCatheter.makeCapacity(homoMatrix ? sourceHeight * width : sourceHeight * inputWidth);
        IntCatheter flockingCatheter = IntCatheter.makeCapacity(width);
        return newMatrix.matrixReplace(inputWidth, (pos, ignored) -> {
            int posX = pos.x();
            int posY = pos.y();
            int flockingIndex = 0;
            int inputY = 0;
            for (int sourceX = 0; sourceX < width; ++sourceX) {
                MatrixFlockPos flockPos = new MatrixFlockPos(posX, posY);
                MatrixPos inputPos = new MatrixPos(posX, inputY);
                MatrixPos sourcePos = new MatrixPos(sourceX, posY);
                int fetchedSource = this.fetch(posY * width + sourceX);
                int fetchedInput = input.fetch(inputY * inputWidth + posX);
                flockingCatheter.fetch(flockingIndex++, (Integer)scanFlocked.apply(flockPos, sourcePos, inputPos, fetchedSource, fetchedInput));
                ++inputY;
            }
            return flockingCatheter.flock((current, next) -> (Integer)combineFlocked.apply((MatrixPos)pos, current, next));
        });
    }

    public <X> Catheter<X> matrixVary(int width, int input, TriFunction<MatrixPos, Integer, Integer, X> action) {
        return this.matrixVary(width, (pos, item) -> action.apply((MatrixPos)pos, (Integer)item, input));
    }

    public IntCatheter matrixReplace(int width, BiFunction<MatrixPos, Integer, Integer> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.replace(item -> {
            int wValue = w.get();
            int hValue = h.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return (Integer)action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public <X> Catheter<X> matrixVary(int width, BiFunction<MatrixPos, Integer, X> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.vary((int item) -> {
            int hValue = h.get();
            int wValue = w.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public Catheter<IntCatheter> matrixLines(int width) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        int sourceHeight = this.count() / width;
        Catheter<IntCatheter> results = Catheter.makeCapacity(sourceHeight);
        IntCatheter catheter = IntCatheter.makeCapacity(width);
        for (int y = 0; y < sourceHeight; ++y) {
            for (int x = 0; x < width; ++x) {
                int element = this.fetch(y * width + x);
                catheter.fetch(x, element);
            }
            results.fetch(y, catheter.dump());
        }
        return results;
    }

    public IntCatheter shuffle() {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public IntCatheter shuffle(RandomGenerator random) {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public IntCatheter swapShuffle(RandomGenerator random) {
        int i;
        int[] elements = this.targets;
        for (int j = i = elements.length; j > 1; --j) {
            int swapTo = random.nextInt(j);
            int swapFrom = j - 1;
            int fromElement = elements[swapFrom];
            int toElement = elements[swapTo];
            elements[swapTo] = fromElement;
            elements[swapFrom] = toElement;
        }
        return this;
    }

    public boolean has(int target) {
        return this.hasAny(t -> t == target);
    }

    public boolean not(int target) {
        return !this.has(target);
    }

    public IntCatheter merge(IntCatheter other) {
        return this.append(other.filter(this::not));
    }

    public IntCatheter dump() {
        return new IntCatheter(this.array());
    }

    public IntCatheter flat(IntFunction<IntCatheter> function) {
        return this.arrayFlat(generator -> ((IntCatheter)function.apply((int)generator)).targets);
    }

    public IntCatheter arrayFlat(IntegerArrayFunction function) {
        int[] targets;
        if (this.isEmpty()) {
            return this;
        }
        int[][] longs = new int[this.count()][];
        int totalSize = 0;
        int index = 0;
        for (int element : targets = this.targets) {
            int[] flatting = function.apply(element);
            longs[index++] = flatting;
            totalSize += flatting.length;
        }
        targets = IntCatheter.array(totalSize);
        int pos = 0;
        int[][] nArrayArray = longs;
        int n = nArrayArray.length;
        for (int i = 0; i < n; ++i) {
            int[] flat;
            for (int l : flat = nArrayArray[i]) {
                targets[pos++] = l;
            }
        }
        this.targets = targets;
        return this;
    }

    public <X> Catheter<X> flatTo(IntFunction<Catheter<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (int element : this.targets) {
            Catheter<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        return Catheter.flatting(catheter, totalSize);
    }

    public <X> Catheter<X> flatToByCollection(IntFunction<Collection<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (int element : this.targets) {
            Collection<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.size();
        }
        return Catheter.flattingCollection(catheter, totalSize);
    }

    public IntCatheter reset() {
        this.targets = IntCatheter.array(0);
        return this;
    }

    public IntCatheter reset(int[] targets) {
        this.targets = targets;
        return this;
    }

    public int[] array() {
        return (int[])this.targets.clone();
    }

    public int[] dArray() {
        return this.targets;
    }

    public IntStream stream() {
        return IntStream.of(this.array());
    }

    public List<Integer> list() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int l : this.array()) {
            list.add(l);
        }
        return list;
    }

    public Set<Integer> set() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int l : this.array()) {
            set.add(l);
        }
        return set;
    }

    public static void main(String[] args) {
        IntCatheter source = IntCatheter.make(1, 2, 3, 4, 5, 6, 7, 8);
        System.out.println("???");
        System.out.println(source.removeWithIndex(4).list());
        System.out.println("???");
    }

    private static int[] array(int size) {
        return new int[size];
    }

    private static <X> X[] xArray(int size) {
        return new Object[size];
    }
}

