/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.lilium.mathematic.base;

import com.github.cao.awa.apricot.annotations.Stable;
import com.github.cao.awa.apricot.io.bytes.reader.BytesReader;

@Stable
public class Base256 {
    public static byte[] longToBuf(long l) {
        return Base256.longToBuf(l, new byte[8]);
    }

    public static byte[] longToBuf(long l, byte[] buf) {
        buf[0] = (byte)(l >>> 56);
        buf[1] = (byte)(l >>> 48);
        buf[2] = (byte)(l >>> 40);
        buf[3] = (byte)(l >>> 32);
        buf[4] = (byte)(l >>> 24);
        buf[5] = (byte)(l >>> 16);
        buf[6] = (byte)(l >>> 8);
        buf[7] = (byte)l;
        return buf;
    }

    public static long longFromBuf(byte[] buf) {
        return (((long)buf[0] & 0xFFL) << 56) + (((long)buf[1] & 0xFFL) << 48) + (((long)buf[2] & 0xFFL) << 40) + (((long)buf[3] & 0xFFL) << 32) + (((long)buf[4] & 0xFFL) << 24) + (((long)buf[5] & 0xFFL) << 16) + (((long)buf[6] & 0xFFL) << 8) + ((long)buf[7] & 0xFFL);
    }

    public static byte[] intToBuf(int i) {
        return Base256.intToBuf(i, new byte[4]);
    }

    public static byte[] intToBuf(int i, byte[] buf) {
        buf[0] = (byte)(i >>> 24);
        buf[1] = (byte)(i >>> 16);
        buf[2] = (byte)(i >>> 8);
        buf[3] = (byte)i;
        return buf;
    }

    public static int intFromBuf(byte[] buf) {
        return ((buf[0] & 0xFF) << 24) + ((buf[1] & 0xFF) << 16) + ((buf[2] & 0xFF) << 8) + (buf[3] & 0xFF);
    }

    public static int tagFromBuf(byte[] buf) {
        return ((buf[0] & 0xFF) << 8) + (buf[1] & 0xFF);
    }

    public static byte[] tagToBuf(int i) {
        return Base256.tagToBuf(i, new byte[2]);
    }

    public static byte[] tagToBuf(int i, byte[] buf) {
        buf[0] = (byte)(i >>> 8);
        buf[1] = (byte)i;
        return buf;
    }

    public static int readTag(BytesReader reader) {
        return Base256.tagFromBuf(reader.read(2));
    }

    public static int readInt(BytesReader reader) {
        return Base256.intFromBuf(reader.read(4));
    }

    public static long readLong(BytesReader reader) {
        return Base256.longFromBuf(reader.read(8));
    }
}

