/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.lilium.mathematic.base;

import com.github.cao.awa.apricot.io.bytes.reader.BytesReader;
import com.github.cao.awa.lilium.mathematic.base.Base256;
import com.github.cao.awa.viburnum.util.bytes.BytesUtil;

public class SkippedBase256 {
    public static long readLong(BytesReader reader, int length) {
        return Base256.longFromBuf(reader.reverseRound(8, length));
    }

    public static long readLong(byte[] bytes) {
        return SkippedBase256.readLong(BytesReader.withOutCheck(bytes));
    }

    public static long readLong(BytesReader reader) {
        byte length = reader.read();
        if (length == -1) {
            return Base256.longFromBuf(reader.read(8));
        }
        if (length == 0) {
            return 0L;
        }
        return Base256.longFromBuf(reader.reverseRound(8, length));
    }

    public static int readInt(byte[] bytes) {
        return SkippedBase256.readInt(BytesReader.withOutCheck(bytes));
    }

    public static int readInt(BytesReader reader) {
        byte length = reader.read();
        if (length == -1) {
            return Base256.intFromBuf(reader.read(4));
        }
        if (length == 0) {
            return 0;
        }
        return Base256.intFromBuf(reader.reverseRound(4, length));
    }

    public static byte[] longToBuf(long l) {
        return SkippedBase256.skip(Base256.longToBuf(l));
    }

    public static byte[] intToBuf(int l) {
        return SkippedBase256.skip(Base256.intToBuf(l));
    }

    public static byte[] tagToBuf(int l) {
        return SkippedBase256.skip(Base256.tagToBuf(l));
    }

    public static byte[] skip(byte[] buf) {
        if (buf[0] == 0 && buf[1] == 0) {
            byte[] skd = BytesUtil.skp(buf, (byte)0);
            byte[] result = new byte[skd.length + 1];
            result[0] = (byte)skd.length;
            System.arraycopy(skd, 0, result, 1, skd.length);
            return result;
        }
        return BytesUtil.concat({-1}, buf);
    }
}

